/*
 * Decompiled with CFR 0.152.
 */
package jdd;

import java.util.List;
import jdd.JDDNode;
import jdd.JDDVars;
import jdd.JDDVectorConsumer;

public class JDD {
    public static final int PLUS = 1;
    public static final int MINUS = 2;
    public static final int TIMES = 3;
    public static final int DIVIDE = 4;
    public static final int MIN = 5;
    public static final int MAX = 6;
    public static final int EQUALS = 7;
    public static final int NOTEQUALS = 8;
    public static final int GREATERTHAN = 9;
    public static final int GREATERTHANEQUALS = 10;
    public static final int LESSTHAN = 11;
    public static final int LESSTHANEQUALS = 12;
    public static final int FLOOR = 13;
    public static final int CEIL = 14;
    public static final int POW = 15;
    public static final int MOD = 16;
    public static final int LOGXY = 17;
    public static final int ZERO_ONE = 1;
    public static final int LOW = 2;
    public static final int NORMAL = 3;
    public static final int HIGH = 4;
    public static final int LIST = 5;
    public static final int CMU = 1;
    public static final int BOULDER = 2;
    public static JDDNode ZERO;
    public static JDDNode ONE;
    public static JDDNode PLUS_INFINITY;
    public static JDDNode MINUS_INFINITY;

    public static native long GetCUDDManager();

    private static native void DD_SetOutputStream(long var0);

    private static native long DD_GetOutputStream();

    private static native void DD_InitialiseCUDD();

    private static native void DD_InitialiseCUDD(long var0, double var2);

    private static native void DD_SetCUDDMaxMem(long var0);

    private static native void DD_SetCUDDEpsilon(double var0);

    private static native void DD_CloseDownCUDD(boolean var0);

    private static native void DD_Ref(long var0);

    private static native void DD_Deref(long var0);

    private static native void DD_PrintCacheInfo();

    private static native long DD_Create();

    private static native long DD_Constant(double var0);

    private static native long DD_PlusInfinity();

    private static native long DD_MinusInfinity();

    private static native long DD_Var(int var0);

    private static native long DD_Not(long var0);

    private static native long DD_Or(long var0, long var2);

    private static native long DD_And(long var0, long var2);

    private static native long DD_Xor(long var0, long var2);

    private static native long DD_Implies(long var0, long var2);

    private static native long DD_Apply(int var0, long var1, long var3);

    private static native long DD_MonadicApply(int var0, long var1);

    private static native long DD_Restrict(long var0, long var2);

    private static native long DD_ITE(long var0, long var2, long var4);

    private static native long DD_PermuteVariables(long var0, long var2, long var4, int var6);

    private static native long DD_SwapVariables(long var0, long var2, long var4, int var6);

    private static native long DD_VariablesGreaterThan(long var0, long var2, int var4);

    private static native long DD_VariablesGreaterThanEquals(long var0, long var2, int var4);

    private static native long DD_VariablesLessThan(long var0, long var2, int var4);

    private static native long DD_VariablesLessThanEquals(long var0, long var2, int var4);

    private static native long DD_VariablesEquals(long var0, long var2, int var4);

    private static native long DD_ThereExists(long var0, long var2, int var4);

    private static native long DD_ForAll(long var0, long var2, int var4);

    private static native long DD_SumAbstract(long var0, long var2, int var4);

    private static native long DD_ProductAbstract(long var0, long var2, int var4);

    private static native long DD_MinAbstract(long var0, long var2, int var4);

    private static native long DD_MaxAbstract(long var0, long var2, int var4);

    private static native long DD_GreaterThan(long var0, double var2);

    private static native long DD_GreaterThanEquals(long var0, double var2);

    private static native long DD_LessThan(long var0, double var2);

    private static native long DD_LessThanEquals(long var0, double var2);

    private static native long DD_Equals(long var0, double var2);

    private static native long DD_Interval(long var0, double var2, double var4);

    private static native long DD_RoundOff(long var0, int var2);

    private static native boolean DD_EqualSupNorm(long var0, long var2, double var4);

    private static native double DD_FindMin(long var0);

    private static native double DD_FindMax(long var0);

    private static native long DD_RestrictToFirst(long var0, long var2, int var4);

    private static native int DD_GetNumNodes(long var0);

    private static native int DD_GetNumTerminals(long var0);

    private static native double DD_GetNumMinterms(long var0, int var2);

    private static native double DD_GetNumPaths(long var0);

    private static native void DD_PrintInfo(long var0, int var2);

    private static native void DD_PrintInfoBrief(long var0, int var2);

    private static native void DD_PrintSupport(long var0);

    private static native void DD_PrintSupportNames(long var0, List<String> var2);

    private static native long DD_GetSupport(long var0);

    private static native void DD_PrintTerminals(long var0);

    private static native void DD_PrintTerminalsAndNumbers(long var0, int var2);

    private static native long DD_SetVectorElement(long var0, long var2, int var4, long var5, double var7);

    private static native long DD_SetMatrixElement(long var0, long var2, int var4, long var5, int var7, long var8, long var10, double var12);

    private static native long DD_Set3DMatrixElement(long var0, long var2, int var4, long var5, int var7, long var8, int var10, long var11, long var13, long var15, double var17);

    private static native double DD_GetVectorElement(long var0, long var2, int var4, long var5);

    private static native long DD_Identity(long var0, long var2, int var4);

    private static native long DD_Transpose(long var0, long var2, long var4, int var6);

    private static native long DD_MatrixMultiply(long var0, long var2, long var4, int var6, int var7);

    private static native void DD_PrintVector(long var0, long var2, int var4, int var5);

    private static native void DD_PrintMatrix(long var0, long var2, int var4, long var5, int var7, int var8);

    private static native void DD_PrintVectorFiltered(long var0, long var2, long var4, int var6, int var7);

    private static native void DD_ExportDDToDotFile(long var0, String var2);

    private static native void DD_ExportDDToDotFileLabelled(long var0, String var2, List<String> var3);

    private static native void DD_ExportMatrixToPPFile(long var0, long var2, int var4, long var5, int var7, String var8);

    private static native void DD_Export3dMatrixToPPFile(long var0, long var2, int var4, long var5, int var7, long var8, int var10, String var11);

    private static native void DD_ExportMatrixToMatlabFile(long var0, long var2, int var4, long var5, int var7, String var8, String var9);

    private static native void DD_ExportMatrixToSpyFile(long var0, long var2, int var4, long var5, int var7, int var8, String var9);

    public static void SetOutputStream(long l) {
        JDD.DD_SetOutputStream(l);
    }

    public static long GetOutputStream() {
        return JDD.DD_GetOutputStream();
    }

    public static void InitialiseCUDD() {
        JDD.DD_InitialiseCUDD();
        ZERO = JDD.Constant(0.0);
        ONE = JDD.Constant(1.0);
        PLUS_INFINITY = JDD.PlusInfinity();
        MINUS_INFINITY = JDD.MinusInfinity();
    }

    public static void InitialiseCUDD(long l, double d) {
        JDD.DD_InitialiseCUDD(l, d);
        ZERO = JDD.Constant(0.0);
        ONE = JDD.Constant(1.0);
        PLUS_INFINITY = JDD.PlusInfinity();
        MINUS_INFINITY = JDD.MinusInfinity();
    }

    public static void SetCUDDMaxMem(long l) {
        JDD.DD_SetCUDDMaxMem(l);
    }

    public static void SetCUDDEpsilon(double d) {
        JDD.DD_SetCUDDEpsilon(d);
    }

    public static void CloseDownCUDD() {
        JDD.CloseDownCUDD(true);
    }

    public static void CloseDownCUDD(boolean bl) {
        JDD.Deref(ZERO);
        JDD.Deref(ONE);
        JDD.Deref(PLUS_INFINITY);
        JDD.Deref(MINUS_INFINITY);
        JDD.DD_CloseDownCUDD(bl);
    }

    public static void Ref(JDDNode jDDNode) {
        JDD.DD_Ref(jDDNode.ptr());
    }

    public static void Deref(JDDNode jDDNode) {
        JDD.DD_Deref(jDDNode.ptr());
    }

    public static void PrintCacheInfo() {
        JDD.DD_PrintCacheInfo();
    }

    public static JDDNode Create() {
        return new JDDNode(JDD.DD_Create());
    }

    public static JDDNode Constant(double d) {
        if (Double.isInfinite(d)) {
            return d > 0.0 ? JDD.PlusInfinity() : JDD.MinusInfinity();
        }
        return new JDDNode(JDD.DD_Constant(d));
    }

    public static JDDNode PlusInfinity() {
        return new JDDNode(JDD.DD_PlusInfinity());
    }

    public static JDDNode MinusInfinity() {
        return new JDDNode(JDD.DD_MinusInfinity());
    }

    public static JDDNode Var(int n) {
        return new JDDNode(JDD.DD_Var(n));
    }

    public static JDDNode Not(JDDNode jDDNode) {
        return new JDDNode(JDD.DD_Not(jDDNode.ptr()));
    }

    public static JDDNode Or(JDDNode jDDNode, JDDNode jDDNode2) {
        return new JDDNode(JDD.DD_Or(jDDNode.ptr(), jDDNode2.ptr()));
    }

    public static JDDNode And(JDDNode jDDNode, JDDNode jDDNode2) {
        return new JDDNode(JDD.DD_And(jDDNode.ptr(), jDDNode2.ptr()));
    }

    public static JDDNode Xor(JDDNode jDDNode, JDDNode jDDNode2) {
        return new JDDNode(JDD.DD_Xor(jDDNode.ptr(), jDDNode2.ptr()));
    }

    public static JDDNode Implies(JDDNode jDDNode, JDDNode jDDNode2) {
        return new JDDNode(JDD.DD_Implies(jDDNode.ptr(), jDDNode2.ptr()));
    }

    public static JDDNode Apply(int n, JDDNode jDDNode, JDDNode jDDNode2) {
        return new JDDNode(JDD.DD_Apply(n, jDDNode.ptr(), jDDNode2.ptr()));
    }

    public static JDDNode MonadicApply(int n, JDDNode jDDNode) {
        return new JDDNode(JDD.DD_MonadicApply(n, jDDNode.ptr()));
    }

    public static JDDNode Restrict(JDDNode jDDNode, JDDNode jDDNode2) {
        return new JDDNode(JDD.DD_Restrict(jDDNode.ptr(), jDDNode2.ptr()));
    }

    public static JDDNode ITE(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3) {
        return new JDDNode(JDD.DD_ITE(jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr()));
    }

    public static boolean AreIntersecting(JDDNode jDDNode, JDDNode jDDNode2) {
        JDD.Ref(jDDNode);
        JDD.Ref(jDDNode2);
        JDDNode jDDNode3 = JDD.And(jDDNode, jDDNode2);
        boolean bl = !jDDNode3.equals(ZERO);
        JDD.Deref(jDDNode3);
        return bl;
    }

    public static boolean IsContainedIn(JDDNode jDDNode, JDDNode jDDNode2) {
        JDD.Ref(jDDNode);
        JDD.Ref(jDDNode2);
        JDDNode jDDNode3 = JDD.And(jDDNode, jDDNode2);
        boolean bl = jDDNode3.equals(jDDNode);
        JDD.Deref(jDDNode3);
        return bl;
    }

    public static JDDNode PermuteVariables(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2) {
        return new JDDNode(JDD.DD_PermuteVariables(jDDNode.ptr(), jDDVars.array(), jDDVars2.array(), jDDVars.n()));
    }

    public static JDDNode SwapVariables(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2) {
        return new JDDNode(JDD.DD_SwapVariables(jDDNode.ptr(), jDDVars.array(), jDDVars2.array(), jDDVars.n()));
    }

    public static JDDNode VariablesGreaterThan(JDDVars jDDVars, JDDVars jDDVars2) {
        return new JDDNode(JDD.DD_VariablesGreaterThan(jDDVars.array(), jDDVars2.array(), jDDVars.n()));
    }

    public static JDDNode VariablesGreaterThanEquals(JDDVars jDDVars, JDDVars jDDVars2) {
        return new JDDNode(JDD.DD_VariablesGreaterThanEquals(jDDVars.array(), jDDVars2.array(), jDDVars.n()));
    }

    public static JDDNode VariablesLessThan(JDDVars jDDVars, JDDVars jDDVars2) {
        return new JDDNode(JDD.DD_VariablesLessThan(jDDVars.array(), jDDVars2.array(), jDDVars.n()));
    }

    public static JDDNode VariablesLessThanEquals(JDDVars jDDVars, JDDVars jDDVars2) {
        return new JDDNode(JDD.DD_VariablesLessThanEquals(jDDVars.array(), jDDVars2.array(), jDDVars.n()));
    }

    public static JDDNode VariablesEquals(JDDVars jDDVars, JDDVars jDDVars2) {
        return new JDDNode(JDD.DD_VariablesEquals(jDDVars.array(), jDDVars2.array(), jDDVars.n()));
    }

    public static JDDNode ThereExists(JDDNode jDDNode, JDDVars jDDVars) {
        return new JDDNode(JDD.DD_ThereExists(jDDNode.ptr(), jDDVars.array(), jDDVars.n()));
    }

    public static JDDNode ForAll(JDDNode jDDNode, JDDVars jDDVars) {
        return new JDDNode(JDD.DD_ForAll(jDDNode.ptr(), jDDVars.array(), jDDVars.n()));
    }

    public static JDDNode SumAbstract(JDDNode jDDNode, JDDVars jDDVars) {
        return new JDDNode(JDD.DD_SumAbstract(jDDNode.ptr(), jDDVars.array(), jDDVars.n()));
    }

    public static JDDNode ProductAbstract(JDDNode jDDNode, JDDVars jDDVars) {
        return new JDDNode(JDD.DD_ProductAbstract(jDDNode.ptr(), jDDVars.array(), jDDVars.n()));
    }

    public static JDDNode MinAbstract(JDDNode jDDNode, JDDVars jDDVars) {
        return new JDDNode(JDD.DD_MinAbstract(jDDNode.ptr(), jDDVars.array(), jDDVars.n()));
    }

    public static JDDNode MaxAbstract(JDDNode jDDNode, JDDVars jDDVars) {
        return new JDDNode(JDD.DD_MaxAbstract(jDDNode.ptr(), jDDVars.array(), jDDVars.n()));
    }

    public static JDDNode GreaterThan(JDDNode jDDNode, double d) {
        return new JDDNode(JDD.DD_GreaterThan(jDDNode.ptr(), d));
    }

    public static JDDNode GreaterThanEquals(JDDNode jDDNode, double d) {
        return new JDDNode(JDD.DD_GreaterThanEquals(jDDNode.ptr(), d));
    }

    public static JDDNode LessThan(JDDNode jDDNode, double d) {
        return new JDDNode(JDD.DD_LessThan(jDDNode.ptr(), d));
    }

    public static JDDNode LessThanEquals(JDDNode jDDNode, double d) {
        return new JDDNode(JDD.DD_LessThanEquals(jDDNode.ptr(), d));
    }

    public static JDDNode Equals(JDDNode jDDNode, double d) {
        return new JDDNode(JDD.DD_Equals(jDDNode.ptr(), d));
    }

    public static JDDNode Interval(JDDNode jDDNode, double d, double d2) {
        return new JDDNode(JDD.DD_Interval(jDDNode.ptr(), d, d2));
    }

    public static JDDNode RoundOff(JDDNode jDDNode, int n) {
        return new JDDNode(JDD.DD_RoundOff(jDDNode.ptr(), n));
    }

    public static boolean EqualSupNorm(JDDNode jDDNode, JDDNode jDDNode2, double d) {
        return JDD.DD_EqualSupNorm(jDDNode.ptr(), jDDNode2.ptr(), d);
    }

    public static double FindMin(JDDNode jDDNode) {
        return JDD.DD_FindMin(jDDNode.ptr());
    }

    public static double FindMax(JDDNode jDDNode) {
        return JDD.DD_FindMax(jDDNode.ptr());
    }

    public static JDDNode RestrictToFirst(JDDNode jDDNode, JDDVars jDDVars) {
        return new JDDNode(JDD.DD_RestrictToFirst(jDDNode.ptr(), jDDVars.array(), jDDVars.n()));
    }

    public static int GetNumNodes(JDDNode jDDNode) {
        return JDD.DD_GetNumNodes(jDDNode.ptr());
    }

    public static int GetNumTerminals(JDDNode jDDNode) {
        return JDD.DD_GetNumTerminals(jDDNode.ptr());
    }

    public static double GetNumMinterms(JDDNode jDDNode, int n) {
        return JDD.DD_GetNumMinterms(jDDNode.ptr(), n);
    }

    public static String GetNumMintermsString(JDDNode jDDNode, int n) {
        double d = JDD.GetNumMinterms(jDDNode, n);
        if (d <= 9.223372036854776E18) {
            return "" + (long)d;
        }
        return "" + d;
    }

    public static double GetNumPaths(JDDNode jDDNode) {
        return JDD.DD_GetNumPaths(jDDNode.ptr());
    }

    public static String GetNumPathsString(JDDNode jDDNode) {
        double d = JDD.GetNumPaths(jDDNode);
        if (d <= 9.223372036854776E18) {
            return "" + (long)d;
        }
        return "" + d;
    }

    public static void PrintInfo(JDDNode jDDNode, int n) {
        JDD.DD_PrintInfo(jDDNode.ptr(), n);
    }

    public static void PrintInfoBrief(JDDNode jDDNode, int n) {
        JDD.DD_PrintInfoBrief(jDDNode.ptr(), n);
    }

    public static String GetInfoString(JDDNode jDDNode, int n) {
        return JDD.GetNumNodes(jDDNode) + " nodes (" + JDD.GetNumTerminals(jDDNode) + " terminal), " + JDD.GetNumMintermsString(jDDNode, n) + " minterms";
    }

    public static String GetInfoBriefString(JDDNode jDDNode, int n) {
        return "[" + JDD.GetNumNodes(jDDNode) + "," + JDD.GetNumTerminals(jDDNode) + "," + JDD.GetNumMintermsString(jDDNode, n) + "]";
    }

    public static void PrintSupport(JDDNode jDDNode) {
        JDD.DD_PrintSupport(jDDNode.ptr());
    }

    public static void PrintSupportNames(JDDNode jDDNode, List<String> list) {
        JDD.DD_PrintSupportNames(jDDNode.ptr(), list);
    }

    public static JDDNode GetSupport(JDDNode jDDNode) {
        return new JDDNode(JDD.DD_GetSupport(jDDNode.ptr()));
    }

    public static void PrintTerminals(JDDNode jDDNode) {
        JDD.DD_PrintTerminals(jDDNode.ptr());
    }

    public static String GetTerminalsString(JDDNode jDDNode) {
        return JDD.GetTerminalsString(jDDNode, 0, false);
    }

    public static void PrintTerminalsAndNumbers(JDDNode jDDNode, int n) {
        JDD.DD_PrintTerminalsAndNumbers(jDDNode.ptr(), n);
    }

    public static String GetTerminalsAndNumbersString(JDDNode jDDNode, int n) {
        return JDD.GetTerminalsString(jDDNode, n, true);
    }

    public static String GetTerminalsString(JDDNode jDDNode, int n, boolean bl) {
        double d = 0.0;
        String string = "";
        JDD.Ref(jDDNode);
        JDDNode jDDNode2 = jDDNode;
        double d2 = JDD.FindMin(jDDNode2);
        while (!jDDNode2.equals(MINUS_INFINITY)) {
            double d3 = JDD.FindMax(jDDNode2);
            string = string + d3 + " ";
            JDD.Ref(jDDNode2);
            JDDNode jDDNode3 = JDD.Equals(jDDNode2, d3);
            if (bl) {
                double d4 = JDD.GetNumMinterms(jDDNode3, n);
                d += d4;
                string = string + "(" + (long)d4 + ") ";
            }
            jDDNode2 = JDD.ITE(jDDNode3, JDD.MinusInfinity(), jDDNode2);
        }
        JDD.Deref(jDDNode2);
        if (bl) {
            if (d < (double)(1 << n)) {
                string = string + "-inf (" + ((double)(1 << n) - d) + ")";
            }
        } else if (d2 == Double.NEGATIVE_INFINITY) {
            string = string + "-inf";
        }
        return string;
    }

    public static JDDNode SetVectorElement(JDDNode jDDNode, JDDVars jDDVars, long l, double d) {
        return new JDDNode(JDD.DD_SetVectorElement(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), l, d));
    }

    public static JDDNode SetMatrixElement(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2, long l, long l2, double d) {
        return new JDDNode(JDD.DD_SetMatrixElement(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), l, l2, d));
    }

    public static JDDNode Set3DMatrixElement(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, long l, long l2, long l3, double d) {
        return new JDDNode(JDD.DD_Set3DMatrixElement(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), l, l2, l3, d));
    }

    public static double GetVectorElement(JDDNode jDDNode, JDDVars jDDVars, long l) {
        return JDD.DD_GetVectorElement(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), l);
    }

    public static JDDNode Identity(JDDVars jDDVars, JDDVars jDDVars2) {
        return new JDDNode(JDD.DD_Identity(jDDVars.array(), jDDVars2.array(), jDDVars.n()));
    }

    public static JDDNode Transpose(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2) {
        return new JDDNode(JDD.DD_Transpose(jDDNode.ptr(), jDDVars.array(), jDDVars2.array(), jDDVars.n()));
    }

    public static JDDNode MatrixMultiply(JDDNode jDDNode, JDDNode jDDNode2, JDDVars jDDVars, int n) {
        return new JDDNode(JDD.DD_MatrixMultiply(jDDNode.ptr(), jDDNode2.ptr(), jDDVars.array(), jDDVars.n(), n));
    }

    public static void PrintVector(JDDNode jDDNode, JDDVars jDDVars) {
        JDD.DD_PrintVector(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), 3);
    }

    public static void PrintVector(JDDNode jDDNode, JDDVars jDDVars, int n) {
        JDD.DD_PrintVector(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), n);
    }

    public static void PrintMatrix(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2) {
        JDD.DD_PrintMatrix(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), 3);
    }

    public static void PrintMatrix(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2, int n) {
        JDD.DD_PrintMatrix(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), n);
    }

    public static void PrintVectorFiltered(JDDNode jDDNode, JDDNode jDDNode2, JDDVars jDDVars) {
        JDD.DD_PrintVectorFiltered(jDDNode.ptr(), jDDNode2.ptr(), jDDVars.array(), jDDVars.n(), 3);
    }

    public static void PrintVectorFiltered(JDDNode jDDNode, JDDNode jDDNode2, JDDVars jDDVars, int n) {
        JDD.DD_PrintVectorFiltered(jDDNode.ptr(), jDDNode2.ptr(), jDDVars.array(), jDDVars.n(), n);
    }

    public static void TraverseVector(JDDNode jDDNode, JDDVars jDDVars, JDDVectorConsumer jDDVectorConsumer, int n) {
        JDD.TraverseVectorRec(jDDNode, jDDVars, 0, 0L, jDDVectorConsumer, n);
    }

    private static void TraverseVectorRec(JDDNode jDDNode, JDDVars jDDVars, int n, long l, JDDVectorConsumer jDDVectorConsumer, int n2) {
        if (jDDNode.equals(ZERO)) {
            return;
        }
        if (n == jDDVars.getNumVars()) {
            jDDVectorConsumer.setElement(l, jDDNode.getValue(), n2);
        } else {
            JDD.Ref(jDDNode);
            JDD.Ref(jDDVars.getVar(n));
            JDDNode jDDNode2 = JDD.Restrict(jDDNode, JDD.Not(jDDVars.getVar(n)));
            JDD.Ref(jDDNode);
            JDD.Ref(jDDVars.getVar(n));
            JDDNode jDDNode3 = JDD.Restrict(jDDNode, jDDVars.getVar(n));
            JDD.TraverseVectorRec(jDDNode2, jDDVars, n + 1, l, jDDVectorConsumer, n2);
            JDD.TraverseVectorRec(jDDNode3, jDDVars, n + 1, l + (1L << jDDVars.getNumVars() - n - 1), jDDVectorConsumer, n2);
            JDD.Deref(jDDNode2);
            JDD.Deref(jDDNode3);
        }
    }

    public static void ExportDDToDotFile(JDDNode jDDNode, String string) {
        JDD.DD_ExportDDToDotFile(jDDNode.ptr(), string);
    }

    public static void ExportDDToDotFileLabelled(JDDNode jDDNode, String string, List<String> list) {
        JDD.DD_ExportDDToDotFileLabelled(jDDNode.ptr(), string, list);
    }

    public static void ExportMatrixToPPFile(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2, String string) {
        JDD.DD_ExportMatrixToPPFile(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), string);
    }

    public static void Export3dMatrixToPPFile(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, String string) {
        JDD.DD_Export3dMatrixToPPFile(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), string);
    }

    public static void ExportMatrixToMatlabFile(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2, String string, String string2) {
        JDD.DD_ExportMatrixToMatlabFile(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), string, string2);
    }

    public static void ExportMatrixToSpyFile(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2, int n, String string) {
        JDD.DD_ExportMatrixToSpyFile(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), n, string);
    }

    static {
        try {
            System.loadLibrary("jdd");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println(unsatisfiedLinkError);
            System.exit(1);
        }
    }
}

