/*
 * Decompiled with CFR 0.152.
 */
package jdd;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jdd.JDDNode;

public class DebugJDD {
    public static final boolean debugEnabled = false;
    protected static HashMap<Integer, StackTraceElement[]> stackTraces;
    protected static HashMap<Integer, Integer> localCounters;
    protected static HashMap<Long, List<Integer>> instances;

    private static native int DebugJDD_GetRefCount(long var0);

    protected static void addToSet(JDDNode jDDNode, int n) {
        StackTraceElement[] stackTraceElementArray;
        long l;
        if (instances == null) {
            instances = new HashMap();
            localCounters = new HashMap();
            stackTraces = new HashMap();
        }
        int n2 = System.identityHashCode(jDDNode);
        if (instances.containsKey(jDDNode.ptr())) {
            l = jDDNode.ptr();
            instances.get(l).add(n2);
        } else {
            l = jDDNode.ptr();
            stackTraceElementArray = new LinkedList();
            stackTraceElementArray.add(n2);
            instances.put(l, (List<Integer>)stackTraceElementArray);
        }
        localCounters.put(n2, n);
        StackTraceElement[] stackTraceElementArray2 = Thread.currentThread().getStackTrace();
        int n3 = stackTraceElementArray2.length - 2;
        stackTraceElementArray = new StackTraceElement[n3];
        for (int i = 0; i < n3; ++i) {
            stackTraceElementArray[i] = stackTraceElementArray2[i + 2];
        }
        stackTraces.put(n2, stackTraceElementArray);
    }

    protected static void decrement(JDDNode jDDNode) {
        int n = System.identityHashCode(jDDNode);
        int n2 = localCounters.get(n) - 1;
        int n3 = DebugJDD.DebugJDD_GetRefCount(jDDNode.ptr());
        assert (n3 > 0);
        assert (n3 - 1 >= n2);
        if (n2 < 0 && n3 == n2) {
            System.out.println("Dereferencing node " + jDDNode + " too often. Printing stack trace where it was created.");
            int n4 = 0;
            for (StackTraceElement stackTraceElement : stackTraces.get(n)) {
                if (n4++ > 5) break;
                System.out.println("  " + stackTraceElement.toString());
            }
            assert (false);
        }
        localCounters.put(n, n2);
    }

    protected static void increment(JDDNode jDDNode) {
        int n = System.identityHashCode(jDDNode);
        int n2 = localCounters.get(n) + 1;
        int n3 = DebugJDD.DebugJDD_GetRefCount(jDDNode.ptr());
        assert (n3 + 1 >= n2);
        localCounters.put(n, n2);
    }

    public static void endLifeCycle() {
        int n;
        Iterator<Long> iterator = instances.keySet().iterator();
        while (iterator.hasNext()) {
            Long l = iterator.next();
            Iterator<Integer> iterator2 = instances.get(l).iterator();
            while (iterator2.hasNext()) {
                n = localCounters.get(iterator2.next());
                if (n == 0) continue;
                iterator2.remove();
            }
            if (!instances.get(l).isEmpty()) continue;
            iterator.remove();
        }
        for (Long l : instances.keySet()) {
            int n2 = DebugJDD.DebugJDD_GetRefCount(l);
            if (n2 == 0) continue;
            n = 0;
            for (Integer n3 : instances.get(l)) {
                int n4 = localCounters.get(n3);
                if (n4 <= 0) continue;
                n = 1;
                break;
            }
            if (n == 0) continue;
            System.out.println("WARNING: there are nodes with nonzero references, printing debug info. Note that the stack traces below are from moments JDDNodes were created. The actual problem can be elsewhere where the node is used");
            System.out.println("Node " + new JDDNode(l, false) + " has " + n2 + " reference(s), printing out stack traces of suspicious node instances:");
            boolean bl = true;
            block4: for (Integer n5 : instances.get(l)) {
                int n6 = localCounters.get(n5);
                if (n6 == 0) continue;
                if (!bl) {
                    System.out.println(" &");
                } else {
                    bl = false;
                }
                int n7 = 0;
                for (StackTraceElement stackTraceElement : stackTraces.get(n5)) {
                    if (n7++ > 8) continue block4;
                    System.out.println("  " + stackTraceElement.toString());
                }
            }
        }
    }

    public static int getRefCount(JDDNode jDDNode) {
        return DebugJDD.DebugJDD_GetRefCount(jDDNode.ptr());
    }

    static {
        try {
            System.loadLibrary("jdd");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println(unsatisfiedLinkError);
            System.exit(1);
        }
    }
}

