/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.Model;
import explicit.NondetModel;
import explicit.PredecessorRelation;
import explicit.StateValues;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parser.State;
import parser.Values;
import parser.VarList;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLog;
import strat.MDStrategy;

public class SubNondetModel
implements NondetModel {
    private NondetModel model = null;
    private BitSet states = null;
    private Map<Integer, BitSet> actions = null;
    private BitSet initialStates = null;
    private List<State> statesList = null;
    private Map<Integer, Integer> stateLookupTable = new HashMap<Integer, Integer>();
    private Map<Integer, Map<Integer, Integer>> actionLookupTable = new HashMap<Integer, Map<Integer, Integer>>();
    private Map<Integer, Integer> inverseStateLookupTable = new HashMap<Integer, Integer>();
    protected PredecessorRelation predecessorRelation;
    private int numTransitions = 0;
    private int maxNumChoices = 0;
    private int numChoices = 0;

    public SubNondetModel(NondetModel nondetModel, BitSet bitSet, Map<Integer, BitSet> map, BitSet bitSet2) {
        this.model = nondetModel;
        this.states = bitSet;
        this.actions = map;
        this.initialStates = bitSet2;
        this.generateStatistics();
        this.generateLookupTable(bitSet, map);
    }

    @Override
    public ModelType getModelType() {
        return this.model.getModelType();
    }

    @Override
    public int getNumStates() {
        return this.states.cardinality();
    }

    @Override
    public int getNumInitialStates() {
        return this.initialStates.cardinality();
    }

    @Override
    public Iterable<Integer> getInitialStates() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = this.initialStates.nextSetBit(0);
        while (n >= 0) {
            arrayList.add(this.translateState(n));
            n = this.initialStates.nextSetBit(n + 1);
        }
        return arrayList;
    }

    @Override
    public int getFirstInitialState() {
        return this.translateState(this.initialStates.nextSetBit(0));
    }

    @Override
    public boolean isInitialState(int n) {
        return this.initialStates.get(this.translateState(n));
    }

    @Override
    public int getNumDeadlockStates() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Integer> getDeadlockStates() {
        throw new UnsupportedOperationException();
    }

    @Override
    public StateValues getDeadlockStatesList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFirstDeadlockState() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDeadlockState(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<State> getStatesList() {
        if (this.statesList == null) {
            this.statesList = this.generateSubStateList(this.states);
        }
        return this.statesList;
    }

    private List<State> generateSubStateList(BitSet bitSet) {
        ArrayList<State> arrayList = new ArrayList<State>();
        for (int i = 0; i < this.model.getNumStates(); ++i) {
            if (!bitSet.get(i)) continue;
            arrayList.add(this.model.getStatesList().get(i));
        }
        return arrayList;
    }

    @Override
    public Values getConstantValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getLabels() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitSet getLabelStates(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumTransitions() {
        return this.numTransitions;
    }

    @Override
    public Iterator<Integer> getSuccessorsIterator(int n) {
        n = this.translateState(n);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < this.model.getNumChoices(n); ++i) {
            if (!this.actions.get(n).get(i)) continue;
            Iterator<Integer> iterator = this.model.getSuccessorsIterator(n, i);
            while (iterator.hasNext()) {
                int n2 = iterator.next();
                hashSet.add(this.inverseTranslateState(n2));
            }
        }
        return hashSet.iterator();
    }

    @Override
    public boolean isSuccessor(int n, int n2) {
        n = this.translateState(n);
        n2 = this.translateState(n2);
        return this.model.isSuccessor(n, n2);
    }

    @Override
    public boolean allSuccessorsInSet(int n, BitSet bitSet) {
        Iterator<Integer> iterator = this.getSuccessorsIterator(n);
        while (iterator.hasNext()) {
            Integer n2 = iterator.next();
            if (!bitSet.get(n2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean someSuccessorsInSet(int n, BitSet bitSet) {
        Iterator<Integer> iterator = this.getSuccessorsIterator(n);
        while (iterator.hasNext()) {
            Integer n2 = iterator.next();
            if (!bitSet.get(n2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkForDeadlocks() throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToPrismExplicit(String string) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToPrismExplicitTra(String string) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToPrismExplicitTra(File file) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToPrismExplicitTra(PrismLog prismLog) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToDotFile(String string) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToDotFile(String string, BitSet bitSet) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToDotFile(PrismLog prismLog) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToDotFile(PrismLog prismLog, BitSet bitSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToDotFile(PrismLog prismLog, BitSet bitSet, boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToDotFileWithStrat(PrismLog prismLog, BitSet bitSet, int[] nArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToPrismLanguage(String string) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportStates(int n, VarList varList, PrismLog prismLog) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String infoString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String infoStringTable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumChoices(int n) {
        n = this.translateState(n);
        return this.actions.get(n).cardinality();
    }

    @Override
    public int getMaxNumChoices() {
        return this.maxNumChoices;
    }

    @Override
    public int getNumChoices() {
        return this.numChoices;
    }

    @Override
    public Object getAction(int n, int n2) {
        int n3 = this.translateState(n);
        int n4 = this.translateAction(n, n2);
        return this.model.getAction(n3, n4);
    }

    @Override
    public boolean areAllChoiceActionsUnique() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public int getNumTransitions(int n, int n2) {
        int n3 = this.translateState(n);
        int n4 = this.translateAction(n, n2);
        return this.model.getNumTransitions(n3, n4);
    }

    @Override
    public boolean allSuccessorsInSet(int n, int n2, BitSet bitSet) {
        Iterator<Integer> iterator = this.getSuccessorsIterator(n, n2);
        while (iterator.hasNext()) {
            Integer n3 = iterator.next();
            if (bitSet.get(n3)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean someSuccessorsInSet(int n, int n2, BitSet bitSet) {
        Iterator<Integer> iterator = this.getSuccessorsIterator(n, n2);
        while (iterator.hasNext()) {
            Integer n3 = iterator.next();
            if (!bitSet.get(n3)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Integer> getSuccessorsIterator(int n, int n2) {
        int n3 = this.translateState(n);
        int n4 = this.translateAction(n, n2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Iterator<Integer> iterator = this.model.getSuccessorsIterator(n3, n4);
        while (iterator.hasNext()) {
            int n5 = iterator.next();
            arrayList.add(this.inverseTranslateState(n5));
        }
        return arrayList.iterator();
    }

    private BitSet translateSet(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            bitSet2.set(this.translateState(n));
            n = bitSet.nextSetBit(n + 1);
        }
        return bitSet2;
    }

    private void generateStatistics() {
        for (int i = 0; i < this.model.getNumStates(); ++i) {
            if (!this.states.get(i)) continue;
            this.numTransitions += this.getTransitions(i);
            this.numChoices += this.actions.get(i).cardinality();
            this.maxNumChoices = Math.max(this.maxNumChoices, this.model.getNumChoices(i));
        }
    }

    private int getTransitions(int n) {
        int n2 = 0;
        for (int i = 0; i < this.model.getNumChoices(n); ++i) {
            if (!this.actions.get(n).get(i)) continue;
            n2 += this.model.getNumTransitions(n, i);
        }
        return n2;
    }

    @Override
    public Model constructInducedModel(MDStrategy mDStrategy) {
        throw new RuntimeException("Not implemented");
    }

    private void generateLookupTable(BitSet bitSet, Map<Integer, BitSet> map) {
        for (int i = 0; i < this.model.getNumStates(); ++i) {
            if (!bitSet.get(i)) continue;
            this.inverseStateLookupTable.put(i, this.stateLookupTable.size());
            this.stateLookupTable.put(this.stateLookupTable.size(), i);
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            for (int j = 0; j < this.model.getNumChoices(i); ++j) {
                if (!map.get(i).get(j)) continue;
                hashMap.put(hashMap.size(), j);
            }
            this.actionLookupTable.put(this.actionLookupTable.size(), hashMap);
        }
    }

    public int translateState(int n) {
        return this.stateLookupTable.get(n);
    }

    private int inverseTranslateState(int n) {
        return this.inverseStateLookupTable.get(n);
    }

    public int translateAction(int n, int n2) {
        return this.actionLookupTable.get(n).get(n2);
    }

    @Override
    public boolean hasStoredPredecessorRelation() {
        return this.predecessorRelation != null;
    }

    @Override
    public PredecessorRelation getPredecessorRelation(PrismComponent prismComponent, boolean bl) {
        if (this.predecessorRelation != null) {
            return this.predecessorRelation;
        }
        PredecessorRelation predecessorRelation = PredecessorRelation.forModel(prismComponent, this);
        if (bl) {
            this.predecessorRelation = predecessorRelation;
        }
        return predecessorRelation;
    }

    @Override
    public void clearPredecessorRelation() {
        this.predecessorRelation = null;
    }
}

