/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.Model;
import explicit.SCCComputer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import prism.PrismComponent;
import prism.PrismException;

public class SCCComputerTarjan
extends SCCComputer {
    private Model model;
    private int numNodes;
    private List<BitSet> sccs = new ArrayList<BitSet>();
    private BitSet notInSCCs;
    private List<BitSet> bsccs = new ArrayList<BitSet>();
    private BitSet notInBSCCs;
    private int index = 0;
    private List<Integer> stack = new LinkedList<Integer>();
    private ArrayList<Node> nodeList;
    private BitSet onStack;

    public SCCComputerTarjan(PrismComponent prismComponent, Model model) throws PrismException {
        super(prismComponent);
        this.model = model;
        this.numNodes = model.getNumStates();
        this.nodeList = new ArrayList(this.numNodes);
        for (int i = 0; i < this.numNodes; ++i) {
            this.nodeList.add(new Node(i));
        }
        this.onStack = new BitSet();
    }

    @Override
    public void computeSCCs() {
        this.tarjan();
        this.notInSCCs = new BitSet();
        Iterator<BitSet> iterator = this.sccs.iterator();
        while (iterator.hasNext()) {
            int n;
            BitSet bitSet = iterator.next();
            if (bitSet.cardinality() != 1 || this.model.someSuccessorsInSet(n = bitSet.nextSetBit(0), bitSet)) continue;
            iterator.remove();
            this.notInSCCs.set(n);
        }
    }

    @Override
    public void computeBSCCs() {
        this.computeSCCs();
        this.notInBSCCs = (BitSet)this.getNotInSCCs().clone();
        int n = this.sccs.size();
        for (int i = 0; i < n; ++i) {
            BitSet bitSet = this.sccs.get(i);
            boolean bl = true;
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                if (!this.model.allSuccessorsInSet(n2, bitSet)) {
                    bl = false;
                    break;
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
            if (bl) {
                this.bsccs.add(bitSet);
                continue;
            }
            this.notInBSCCs.or(bitSet);
        }
    }

    @Override
    public List<BitSet> getSCCs() {
        return this.sccs;
    }

    @Override
    public BitSet getNotInSCCs() {
        return this.notInSCCs;
    }

    @Override
    public List<BitSet> getBSCCs() {
        return this.bsccs;
    }

    @Override
    public BitSet getNotInBSCCs() {
        return this.notInBSCCs;
    }

    public void tarjan() {
        for (int i = 0; i < this.numNodes; ++i) {
            if (this.nodeList.get((int)i).lowlink != -1) continue;
            this.tarjan(i);
        }
    }

    private void tarjan(int n) {
        Object object;
        int n2;
        Node node = this.nodeList.get(n);
        node.index = this.index;
        node.lowlink = this.index++;
        this.stack.add(0, n);
        this.onStack.set(n);
        Iterator<Integer> iterator = this.model.getSuccessorsIterator(n);
        while (iterator.hasNext()) {
            n2 = iterator.next();
            object = this.nodeList.get(n2);
            if (((Node)object).index == -1) {
                this.tarjan(n2);
                node.lowlink = Math.min(node.lowlink, ((Node)object).lowlink);
                continue;
            }
            if (!this.onStack.get(n2)) continue;
            node.lowlink = Math.min(node.lowlink, ((Node)object).index);
        }
        if (node.lowlink == node.index) {
            object = new BitSet();
            do {
                n2 = this.stack.remove(0);
                this.onStack.set(n2, false);
                ((BitSet)object).set(n2);
            } while (n2 != n);
            this.sccs.add((BitSet)object);
        }
    }

    protected static class Node {
        public int lowlink = -1;
        public int index = -1;
        public int id;

        public Node(int n) {
            this.id = n;
        }
    }
}

