/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.ConstructModel;
import explicit.Distribution;
import explicit.DistributionSet;
import explicit.MDPSimple;
import explicit.ModelSimple;
import explicit.QuantAbstractRefine;
import explicit.STPG;
import explicit.STPGAbstrSimple;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import parser.State;
import parser.ast.Expression;
import parser.ast.ModulesFile;
import prism.ModelType;
import prism.Prism;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismNotSupportedException;
import prism.PrismPrintStreamLog;
import prism.UndefinedConstants;

public class QuantAbstractRefineExample
extends QuantAbstractRefine {
    protected boolean rebuildImmed = false;
    protected ModelSimple modelConcrete;
    protected ModulesFile modulesFile;
    protected int nConcrete;
    protected BitSet initialConcrete;
    protected BitSet targetConcrete;
    protected String targetLabel;
    protected int[] concreteToAbstract;
    protected List<List<Set<Integer>>> abstractToConcrete;

    public QuantAbstractRefineExample(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    @Override
    protected void initialise() throws PrismException {
        int n;
        int n2;
        this.mainLog.println("Concrete " + (Object)((Object)this.modelType) + ": " + this.modelConcrete.infoString());
        this.nConcrete = this.modelConcrete.getNumStates();
        this.initialConcrete = new BitSet(this.nConcrete);
        for (int n3 : this.modelConcrete.getInitialStates()) {
            this.initialConcrete.set(n3, 1);
        }
        List<State> list = this.modelConcrete.getStatesList();
        int n4 = this.modulesFile.getLabelList().getLabelIndex(this.targetLabel);
        if ((long)n4 == -1L) {
            throw new PrismException("Unknown label \"" + this.targetLabel + "\"");
        }
        Expression expression = this.modulesFile.getLabelList().getLabel(n4);
        this.targetConcrete = new BitSet(this.nConcrete);
        for (n4 = 0; n4 < this.nConcrete; ++n4) {
            this.targetConcrete.set(n4, expression.evaluateBoolean(list.get(n4)));
        }
        this.concreteToAbstract = new int[this.nConcrete];
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (n2 = 0; n2 < this.nConcrete; ++n2) {
            boolean bl4 = this.targetConcrete.get(n2);
            boolean bl5 = this.initialConcrete.get(n2);
            bl3 |= !bl4 && bl5;
            bl2 |= bl4 && bl5;
            bl |= !bl4 && !bl5;
            this.concreteToAbstract[n2] = bl4 ? 1 : (bl5 ? 0 : 2);
        }
        if (!bl3) {
            throw new PrismException("No non-target initial states");
        }
        if (this.verbosity >= 10) {
            this.mainLog.print("Initial concreteToAbstract: ");
            this.mainLog.println(this.concreteToAbstract);
        }
        int n5 = bl ? 3 : 2;
        switch (this.modelType) {
            case MDP: {
                this.abstraction = new STPGAbstrSimple(n5);
                break;
            }
            default: {
                throw new PrismException("Cannot handle model type " + (Object)((Object)this.modelType));
            }
        }
        this.abstraction.addInitialState(0);
        if (bl2) {
            this.abstraction.addInitialState(1);
        }
        this.target = new BitSet(n5);
        this.target.set(1);
        this.abstractToConcrete = new ArrayList<List<Set<Integer>>>(n5);
        for (n = 0; n < n5; ++n) {
            this.abstractToConcrete.add(new ArrayList());
        }
        for (n2 = 0; n2 < this.nConcrete; ++n2) {
            int n6;
            n = this.concreteToAbstract[n2];
            switch (this.modelType) {
                case MDP: {
                    DistributionSet distributionSet = this.buildAbstractDistributionSet(n2, (MDPSimple)this.modelConcrete, (STPG)((Object)this.abstraction));
                    n6 = ((STPGAbstrSimple)this.abstraction).addDistributionSet(n, distributionSet);
                    break;
                }
                default: {
                    throw new PrismException("Cannot handle model type " + (Object)((Object)this.modelType));
                }
            }
            List<Set<Integer>> list2 = this.abstractToConcrete.get(n);
            if (n6 >= list2.size()) {
                list2.add(new HashSet(1));
            }
            list2.get(n6).add(n2);
        }
    }

    protected DistributionSet buildAbstractDistributionSet(int n, MDPSimple mDPSimple, STPG sTPG) {
        DistributionSet distributionSet = ((STPGAbstrSimple)sTPG).newDistributionSet(null);
        for (Distribution distribution : mDPSimple.getChoices(n)) {
            distributionSet.add(distribution.map(this.concreteToAbstract));
        }
        return distributionSet;
    }

    @Override
    protected int splitState(int n, List<List<Integer>> list, Set<Integer> set, Set<Integer> set2) throws PrismException {
        if (this.verbosity >= 1) {
            this.mainLog.println("Splitting: #" + n);
        }
        this.addRemainderIntoChoiceLists(n, list);
        int n2 = this.abstraction.getNumStates();
        int n3 = list.size();
        List<Set<Integer>> list2 = this.abstractToConcrete.get(n);
        int n4 = 0;
        for (List<Integer> list3 : list) {
            int n5;
            ArrayList arrayList = new ArrayList(1);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            arrayList.add(hashSet);
            if (n4 == 0) {
                n5 = n;
                this.abstractToConcrete.set(n5, arrayList);
            } else {
                n5 = n2 + n4 - 1;
                this.abstractToConcrete.add(arrayList);
            }
            for (int n6 : list3) {
                Set<Integer> set3 = list2.get(n6);
                for (int n7 : set3) {
                    this.concreteToAbstract[n7] = n5;
                    hashSet.add(n7);
                }
            }
            ++n4;
        }
        if (this.verbosity >= 10) {
            this.mainLog.print("New concreteToAbstract: ");
            this.mainLog.println(this.concreteToAbstract);
        }
        this.abstraction.addStates(n3 - 1);
        if (this.abstraction.isInitialState(n)) {
            for (n4 = 1; n4 < n3; ++n4) {
                this.abstraction.addInitialState(n2 + n4 - 1);
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            if (n4 != n && !this.abstraction.isSuccessor(n4, n)) continue;
            if (this.rebuildImmed) {
                this.rebuildAbstractionState(n4);
                set.add(n4);
                continue;
            }
            set2.add(n4);
        }
        for (n4 = 1; n4 < n3; ++n4) {
            if (this.rebuildImmed) {
                this.rebuildAbstractionState(n2 + n4 - 1);
                set.add(n4);
                continue;
            }
            set2.add(n2 + n4 - 1);
        }
        return n3;
    }

    @Override
    protected void rebuildAbstraction(Set<Integer> set) throws PrismException {
        for (int n : set) {
            this.rebuildAbstractionState(n);
        }
    }

    protected void rebuildAbstractionState(int n) throws PrismException {
        List<Set<Integer>> list = this.abstractToConcrete.get(n);
        ArrayList arrayList = new ArrayList();
        this.abstraction.clearState(n);
        for (Set<Integer> set : list) {
            for (int n2 : set) {
                int n3;
                int n4 = this.concreteToAbstract[n2];
                if (n4 != n) {
                    throw new PrismException("Oops");
                }
                switch (this.modelType) {
                    case MDP: {
                        DistributionSet distributionSet = this.buildAbstractDistributionSet(n2, (MDPSimple)this.modelConcrete, (STPG)((Object)this.abstraction));
                        n3 = ((STPGAbstrSimple)this.abstraction).addDistributionSet(n4, distributionSet);
                        break;
                    }
                    default: {
                        throw new PrismNotSupportedException("Cannot handle model type " + (Object)((Object)this.modelType));
                    }
                }
                if (n3 >= arrayList.size()) {
                    arrayList.add(new HashSet(1));
                }
                ((Set)arrayList.get(n3)).add(n2);
            }
        }
        this.abstractToConcrete.set(n, arrayList);
    }

    @Override
    protected void printFinalSummary(String string, boolean bl) {
        this.mainLog.println("\nConcrete " + (Object)((Object)this.modelType) + ": " + this.modelConcrete.infoString());
        super.printFinalSummary(string, bl);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("Usage: java ... <PRISM model> <target label>");
            System.exit(1);
        }
        try {
            PrismPrintStreamLog prismPrintStreamLog = new PrismPrintStreamLog(System.out);
            Prism prism = new Prism(prismPrintStreamLog, prismPrintStreamLog);
            ModulesFile modulesFile = prism.parseModelFile(new File(stringArray[0]));
            UndefinedConstants undefinedConstants = new UndefinedConstants(modulesFile, null);
            undefinedConstants.defineUsingConstSwitch("");
            modulesFile.setUndefinedConstants(undefinedConstants.getMFConstantValues());
            modulesFile = (ModulesFile)modulesFile.deepCopy().expandConstants(modulesFile.getConstantList());
            ConstructModel constructModel = new ConstructModel(prism, prism.getSimulator());
            ModelSimple modelSimple = (ModelSimple)constructModel.constructModel(modulesFile, false, false);
            modelSimple.exportToPrismExplicitTra(stringArray[1]);
            QuantAbstractRefineExample quantAbstractRefineExample = new QuantAbstractRefineExample(prism);
            quantAbstractRefineExample.setModelType(ModelType.MDP);
            quantAbstractRefineExample.setPropertyType(QuantAbstractRefine.PropertyType.PROB_REACH);
            quantAbstractRefineExample.sanityChecks = true;
            quantAbstractRefineExample.modelConcrete = modelSimple;
            quantAbstractRefineExample.modulesFile = modulesFile;
            quantAbstractRefineExample.targetLabel = stringArray[1];
            quantAbstractRefineExample.printSettings();
            boolean bl = true;
            quantAbstractRefineExample.abstractRefine(bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error: " + fileNotFoundException.getMessage());
            System.exit(1);
        }
        catch (PrismException prismException) {
            System.out.println("Error: " + prismException.getMessage());
            System.exit(1);
        }
    }
}

