/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.CTMC;
import explicit.CTMCModelChecker;
import explicit.DTMC;
import explicit.DTMCModelChecker;
import explicit.LTLModelChecker;
import explicit.MDP;
import explicit.MDPModelChecker;
import explicit.MinMax;
import explicit.Model;
import explicit.ModelCheckerResult;
import explicit.NonProbModelChecker;
import explicit.STPG;
import explicit.STPGModelChecker;
import explicit.StateValues;
import explicit.Utils;
import explicit.rewards.ConstructRewards;
import explicit.rewards.MCRewards;
import explicit.rewards.MDPRewards;
import explicit.rewards.Rewards;
import explicit.rewards.STPGRewards;
import java.util.BitSet;
import parser.ast.Coalition;
import parser.ast.Expression;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionSS;
import parser.ast.ExpressionStrategy;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.ast.RewardStruct;
import parser.type.Type;
import parser.type.TypeDouble;
import prism.IntegerBound;
import prism.OpRelOpBound;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismNotSupportedException;

public class ProbModelChecker
extends NonProbModelChecker {
    protected LinEqMethod linEqMethod = LinEqMethod.GAUSS_SEIDEL;
    protected MDPSolnMethod mdpSolnMethod = MDPSolnMethod.GAUSS_SEIDEL;
    protected TermCrit termCrit = TermCrit.RELATIVE;
    protected double termCritParam = 1.0E-8;
    protected int maxIters = 100000;
    protected boolean precomp = true;
    protected boolean prob0 = true;
    protected boolean prob1 = true;
    protected boolean preRel = true;
    protected ValIterDir valIterDir = ValIterDir.BELOW;
    protected SolnMethod solnMethod = SolnMethod.VALUE_ITERATION;
    protected boolean errorOnNonConverge = true;
    protected boolean exportAdv = false;
    protected String exportAdvFilename;

    public ProbModelChecker(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
        if (this.settings != null) {
            String string = this.settings.getString("prism.linEqMethod");
            if (string.equals("Power")) {
                this.setLinEqMethod(LinEqMethod.POWER);
            } else if (string.equals("Jacobi")) {
                this.setLinEqMethod(LinEqMethod.JACOBI);
            } else if (string.equals("Gauss-Seidel")) {
                this.setLinEqMethod(LinEqMethod.GAUSS_SEIDEL);
            } else if (string.equals("Backwards Gauss-Seidel")) {
                this.setLinEqMethod(LinEqMethod.BACKWARDS_GAUSS_SEIDEL);
            } else if (string.equals("JOR")) {
                this.setLinEqMethod(LinEqMethod.JOR);
            } else if (string.equals("SOR")) {
                this.setLinEqMethod(LinEqMethod.SOR);
            } else if (string.equals("Backwards SOR")) {
                this.setLinEqMethod(LinEqMethod.BACKWARDS_SOR);
            } else {
                throw new PrismNotSupportedException("Explicit engine does not support linear equation solution method \"" + string + "\"");
            }
            string = this.settings.getString("prism.mdpSolnMethod");
            if (string.equals("Value iteration")) {
                this.setMDPSolnMethod(MDPSolnMethod.VALUE_ITERATION);
            } else if (string.equals("Gauss-Seidel")) {
                this.setMDPSolnMethod(MDPSolnMethod.GAUSS_SEIDEL);
            } else if (string.equals("Policy iteration")) {
                this.setMDPSolnMethod(MDPSolnMethod.POLICY_ITERATION);
            } else if (string.equals("Modified policy iteration")) {
                this.setMDPSolnMethod(MDPSolnMethod.MODIFIED_POLICY_ITERATION);
            } else if (string.equals("Linear programming")) {
                this.setMDPSolnMethod(MDPSolnMethod.LINEAR_PROGRAMMING);
            } else {
                throw new PrismNotSupportedException("Explicit engine does not support MDP solution method \"" + string + "\"");
            }
            string = this.settings.getString("prism.termCrit");
            if (string.equals("Absolute")) {
                this.setTermCrit(TermCrit.ABSOLUTE);
            } else if (string.equals("Relative")) {
                this.setTermCrit(TermCrit.RELATIVE);
            } else {
                throw new PrismNotSupportedException("Unknown termination criterion \"" + string + "\"");
            }
            this.setTermCritParam(this.settings.getDouble("prism.termCritParam"));
            this.setMaxIters(this.settings.getInteger("prism.maxIters"));
            this.setPrecomp(this.settings.getBoolean("prism.precomputation"));
            this.setProb0(this.settings.getBoolean("prism.prob0"));
            this.setProb1(this.settings.getBoolean("prism.prob1"));
            this.setPreRel(this.settings.getBoolean("prism.preRel"));
            if (this.settings.getBoolean("prism.fairness")) {
                throw new PrismNotSupportedException("The explicit engine does not support model checking MDPs under fairness");
            }
            string = this.settings.getString("prism.exportAdv");
            if (!string.equals("None")) {
                this.setExportAdv(true);
            }
            this.setExportAdvFilename(this.settings.getString("prism.exportAdvFilename"));
        }
    }

    public void inheritSettings(ProbModelChecker probModelChecker) {
        super.inheritSettings(probModelChecker);
        this.setLinEqMethod(probModelChecker.getLinEqMethod());
        this.setMDPSolnMethod(probModelChecker.getMDPSolnMethod());
        this.setTermCrit(probModelChecker.getTermCrit());
        this.setTermCritParam(probModelChecker.getTermCritParam());
        this.setMaxIters(probModelChecker.getMaxIters());
        this.setPrecomp(probModelChecker.getPrecomp());
        this.setProb0(probModelChecker.getProb0());
        this.setProb1(probModelChecker.getProb1());
        this.setValIterDir(probModelChecker.getValIterDir());
        this.setSolnMethod(probModelChecker.getSolnMethod());
        this.setErrorOnNonConverge(probModelChecker.geterrorOnNonConverge());
    }

    @Override
    public void printSettings() {
        super.printSettings();
        this.mainLog.print("linEqMethod = " + (Object)((Object)this.linEqMethod) + " ");
        this.mainLog.print("mdpSolnMethod = " + (Object)((Object)this.mdpSolnMethod) + " ");
        this.mainLog.print("termCrit = " + (Object)((Object)this.termCrit) + " ");
        this.mainLog.print("termCritParam = " + this.termCritParam + " ");
        this.mainLog.print("maxIters = " + this.maxIters + " ");
        this.mainLog.print("precomp = " + this.precomp + " ");
        this.mainLog.print("prob0 = " + this.prob0 + " ");
        this.mainLog.print("prob1 = " + this.prob1 + " ");
        this.mainLog.print("valIterDir = " + (Object)((Object)this.valIterDir) + " ");
        this.mainLog.print("solnMethod = " + (Object)((Object)this.solnMethod) + " ");
        this.mainLog.print("errorOnNonConverge = " + this.errorOnNonConverge + " ");
    }

    @Override
    public void setVerbosity(int n) {
        this.verbosity = n;
    }

    public void setLinEqMethod(LinEqMethod linEqMethod) {
        this.linEqMethod = linEqMethod;
    }

    public void setMDPSolnMethod(MDPSolnMethod mDPSolnMethod) {
        this.mdpSolnMethod = mDPSolnMethod;
    }

    public void setTermCrit(TermCrit termCrit) {
        this.termCrit = termCrit;
    }

    public void setTermCritParam(double d) {
        this.termCritParam = d;
    }

    public void setMaxIters(int n) {
        this.maxIters = n;
    }

    public void setPrecomp(boolean bl) {
        this.precomp = bl;
    }

    public void setProb0(boolean bl) {
        this.prob0 = bl;
    }

    public void setProb1(boolean bl) {
        this.prob1 = bl;
    }

    public void setPreRel(boolean bl) {
        this.preRel = bl;
    }

    public void setValIterDir(ValIterDir valIterDir) {
        this.valIterDir = valIterDir;
    }

    public void setSolnMethod(SolnMethod solnMethod) {
        this.solnMethod = solnMethod;
    }

    public void setErrorOnNonConverge(boolean bl) {
        this.errorOnNonConverge = bl;
    }

    public void setExportAdv(boolean bl) {
        this.exportAdv = bl;
    }

    public void setExportAdvFilename(String string) {
        this.exportAdvFilename = string;
    }

    @Override
    public int getVerbosity() {
        return this.verbosity;
    }

    public LinEqMethod getLinEqMethod() {
        return this.linEqMethod;
    }

    public MDPSolnMethod getMDPSolnMethod() {
        return this.mdpSolnMethod;
    }

    public TermCrit getTermCrit() {
        return this.termCrit;
    }

    public double getTermCritParam() {
        return this.termCritParam;
    }

    public int getMaxIters() {
        return this.maxIters;
    }

    public boolean getPrecomp() {
        return this.precomp;
    }

    public boolean getProb0() {
        return this.prob0;
    }

    public boolean getProb1() {
        return this.prob1;
    }

    public boolean getPreRel() {
        return this.preRel;
    }

    public ValIterDir getValIterDir() {
        return this.valIterDir;
    }

    public SolnMethod getSolnMethod() {
        return this.solnMethod;
    }

    public boolean geterrorOnNonConverge() {
        return this.errorOnNonConverge;
    }

    @Override
    public StateValues checkExpression(Model model, Expression expression, BitSet bitSet) throws PrismException {
        StateValues stateValues = expression instanceof ExpressionProb ? this.checkExpressionProb(model, (ExpressionProb)expression, bitSet) : (expression instanceof ExpressionReward ? this.checkExpressionReward(model, (ExpressionReward)expression) : (expression instanceof ExpressionSS ? this.checkExpressionSteadyState(model, (ExpressionSS)expression) : (expression instanceof ExpressionStrategy ? this.checkExpressionStrategy(model, (ExpressionStrategy)expression, bitSet) : super.checkExpression(model, expression, bitSet))));
        return stateValues;
    }

    protected StateValues checkExpressionStrategy(Model model, ExpressionStrategy expressionStrategy, BitSet bitSet) throws PrismException {
        if (!expressionStrategy.isThereExists()) {
            throw new PrismNotSupportedException("The " + expressionStrategy.getOperatorString() + " operator is not yet supported");
        }
        if (!(this instanceof MDPModelChecker)) {
            throw new PrismNotSupportedException("The " + expressionStrategy.getOperatorString() + " operator is only supported for MDPs currently");
        }
        Coalition coalition = expressionStrategy.getCoalition();
        Expression expression = expressionStrategy.getExpression();
        while (Expression.isParenth(expression)) {
            expression = ((ExpressionUnaryOp)expression).getOperand();
        }
        if (expression instanceof ExpressionProb) {
            return this.checkExpressionProb(model, (ExpressionProb)expression, false, coalition, bitSet);
        }
        if (expression instanceof ExpressionReward) {
            return this.checkExpressionReward(model, (ExpressionReward)expression, false, coalition);
        }
        throw new PrismException("Unexpected operators in " + expressionStrategy.getOperatorString() + " operator");
    }

    protected StateValues checkExpressionProb(Model model, ExpressionProb expressionProb, BitSet bitSet) throws PrismException {
        return this.checkExpressionProb(model, expressionProb, true, null, bitSet);
    }

    protected StateValues checkExpressionProb(Model model, ExpressionProb expressionProb, boolean bl, Coalition coalition, BitSet bitSet) throws PrismException {
        OpRelOpBound opRelOpBound = expressionProb.getRelopBoundInfo(this.constantValues);
        MinMax minMax = opRelOpBound.getMinMax(model.getModelType());
        StateValues stateValues = this.checkProbPathFormula(model, expressionProb.getExpression(), minMax, bitSet);
        if (this.getVerbosity() > 5) {
            this.mainLog.print("\nProbabilities (non-zero only) for all states:\n");
            stateValues.print(this.mainLog);
        }
        if (opRelOpBound.isNumeric()) {
            return stateValues;
        }
        BitSet bitSet2 = stateValues.getBitSetFromInterval(opRelOpBound.getRelOp(), opRelOpBound.getBound());
        stateValues.clear();
        return StateValues.createFromBitSet(bitSet2, model);
    }

    protected StateValues checkProbPathFormula(Model model, Expression expression, MinMax minMax, BitSet bitSet) throws PrismException {
        boolean bl = expression.isSimplePathFormula();
        if (bl && this.settings.getBoolean("prism.pathViaAutomata") && LTLModelChecker.isSupportedLTLFormula(model.getModelType(), expression)) {
            bl = false;
        }
        if (bl) {
            return this.checkProbPathFormulaSimple(model, expression, minMax, bitSet);
        }
        return this.checkProbPathFormulaLTL(model, expression, false, minMax, bitSet);
    }

    protected StateValues checkProbPathFormulaSimple(Model model, Expression expression, MinMax minMax, BitSet bitSet) throws PrismException {
        boolean bl = false;
        StateValues stateValues = null;
        if ((expression = Expression.convertSimplePathFormulaToCanonicalForm(expression)) instanceof ExpressionUnaryOp && ((ExpressionUnaryOp)expression).getOperator() == 1) {
            bl = true;
            minMax = minMax.negate();
            expression = ((ExpressionUnaryOp)expression).getOperand();
        }
        if (expression instanceof ExpressionTemporal) {
            ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
            if (expressionTemporal.getOperator() == 1) {
                stateValues = this.checkProbNext(model, expressionTemporal, minMax, bitSet);
            } else if (expressionTemporal.getOperator() == 2) {
                stateValues = expressionTemporal.hasBounds() ? this.checkProbBoundedUntil(model, expressionTemporal, minMax, bitSet) : this.checkProbUntil(model, expressionTemporal, minMax, bitSet);
            }
        }
        if (stateValues == null) {
            throw new PrismException("Unrecognised path operator in P operator");
        }
        if (bl) {
            stateValues.timesConstant(-1.0);
            stateValues.plusConstant(1.0);
        }
        return stateValues;
    }

    protected StateValues checkProbNext(Model model, ExpressionTemporal expressionTemporal, MinMax minMax, BitSet bitSet) throws PrismException {
        BitSet bitSet2 = this.checkExpression(model, expressionTemporal.getOperand2(), null).getBitSet();
        ModelCheckerResult modelCheckerResult = null;
        switch (model.getModelType()) {
            case CTMC: {
                modelCheckerResult = ((CTMCModelChecker)this).computeNextProbs((CTMC)model, bitSet2);
                break;
            }
            case DTMC: {
                modelCheckerResult = ((DTMCModelChecker)this).computeNextProbs((DTMC)model, bitSet2);
                break;
            }
            case MDP: {
                modelCheckerResult = ((MDPModelChecker)this).computeNextProbs((MDP)model, bitSet2, minMax.isMin());
                break;
            }
            case STPG: {
                modelCheckerResult = ((STPGModelChecker)this).computeNextProbs((STPG)model, bitSet2, minMax.isMin1(), minMax.isMin2());
                break;
            }
            default: {
                throw new PrismNotSupportedException("Cannot model check " + expressionTemporal + " for " + (Object)((Object)model.getModelType()) + "s");
            }
        }
        return StateValues.createFromDoubleArray(modelCheckerResult.soln, model);
    }

    protected StateValues checkProbBoundedUntil(Model model, ExpressionTemporal expressionTemporal, MinMax minMax, BitSet bitSet) throws PrismException {
        Object object;
        IntegerBound integerBound = IntegerBound.fromExpressionTemporal(expressionTemporal, this.constantValues, true);
        BitSet bitSet2 = this.checkExpression(model, expressionTemporal.getOperand1(), null).getBitSet();
        BitSet bitSet3 = this.checkExpression(model, expressionTemporal.getOperand2(), null).getBitSet();
        Integer n = integerBound.hasLowerBound() ? integerBound.getLowestInteger() : Integer.valueOf(0);
        Integer n2 = null;
        if (integerBound.hasUpperBound()) {
            n2 = integerBound.getHighestInteger() - n;
        }
        StateValues stateValues = null;
        if (n2 == null) {
            object = null;
            switch (model.getModelType()) {
                case DTMC: {
                    object = ((DTMCModelChecker)this).computeUntilProbs((DTMC)model, bitSet2, bitSet3);
                    break;
                }
                case MDP: {
                    object = ((MDPModelChecker)this).computeUntilProbs((MDP)model, bitSet2, bitSet3, minMax.isMin());
                    break;
                }
                case STPG: {
                    object = ((STPGModelChecker)this).computeUntilProbs((STPG)model, bitSet2, bitSet3, minMax.isMin1(), minMax.isMin2());
                    break;
                }
                default: {
                    throw new PrismException("Cannot model check " + expressionTemporal + " for " + (Object)((Object)model.getModelType()) + "s");
                }
            }
            stateValues = StateValues.createFromDoubleArray(object.soln, model);
        } else if (n2 == 0) {
            stateValues = StateValues.createFromBitSetAsDoubles(bitSet3, model);
        } else {
            object = null;
            switch (model.getModelType()) {
                case DTMC: {
                    object = ((DTMCModelChecker)this).computeBoundedUntilProbs((DTMC)model, bitSet2, bitSet3, n2);
                    break;
                }
                case MDP: {
                    object = ((MDPModelChecker)this).computeBoundedUntilProbs((MDP)model, bitSet2, bitSet3, n2, minMax.isMin());
                    break;
                }
                case STPG: {
                    object = ((STPGModelChecker)this).computeBoundedUntilProbs((STPG)model, bitSet2, bitSet3, n2, minMax.isMin1(), minMax.isMin2());
                    break;
                }
                default: {
                    throw new PrismNotSupportedException("Cannot model check " + expressionTemporal + " for " + (Object)((Object)model.getModelType()) + "s");
                }
            }
            stateValues = StateValues.createFromDoubleArray(object.soln, model);
        }
        if (n > 0) {
            object = stateValues.getDoubleArray();
            block15: for (int i = 0; i < n; ++i) {
                switch (model.getModelType()) {
                    case DTMC: {
                        object = ((DTMCModelChecker)this).computeRestrictedNext((DTMC)model, bitSet2, (double[])object);
                        continue block15;
                    }
                    case MDP: {
                        object = ((MDPModelChecker)this).computeRestrictedNext((MDP)model, bitSet2, (double[])object, minMax.isMin());
                        continue block15;
                    }
                    case STPG: {
                        throw new PrismNotSupportedException("Lower bounds not yet supported for STPGModelChecker");
                    }
                    default: {
                        throw new PrismNotSupportedException("Cannot model check " + expressionTemporal + " for " + (Object)((Object)model.getModelType()) + "s");
                    }
                }
            }
            stateValues = StateValues.createFromDoubleArray(object, model);
        }
        return stateValues;
    }

    protected StateValues checkProbUntil(Model model, ExpressionTemporal expressionTemporal, MinMax minMax, BitSet bitSet) throws PrismException {
        BitSet bitSet2 = this.checkExpression(model, expressionTemporal.getOperand1(), null).getBitSet();
        BitSet bitSet3 = this.checkExpression(model, expressionTemporal.getOperand2(), null).getBitSet();
        ModelCheckerResult modelCheckerResult = null;
        switch (model.getModelType()) {
            case CTMC: {
                modelCheckerResult = ((CTMCModelChecker)this).computeUntilProbs((CTMC)model, bitSet2, bitSet3);
                break;
            }
            case DTMC: {
                modelCheckerResult = ((DTMCModelChecker)this).computeUntilProbs((DTMC)model, bitSet2, bitSet3);
                break;
            }
            case MDP: {
                modelCheckerResult = ((MDPModelChecker)this).computeUntilProbs((MDP)model, bitSet2, bitSet3, minMax.isMin());
                this.result.setStrategy(modelCheckerResult.strat);
                break;
            }
            case STPG: {
                modelCheckerResult = ((STPGModelChecker)this).computeUntilProbs((STPG)model, bitSet2, bitSet3, minMax.isMin1(), minMax.isMin2());
                break;
            }
            default: {
                throw new PrismNotSupportedException("Cannot model check " + expressionTemporal + " for " + (Object)((Object)model.getModelType()) + "s");
            }
        }
        return StateValues.createFromDoubleArray(modelCheckerResult.soln, model);
    }

    protected StateValues checkProbPathFormulaLTL(Model model, Expression expression, boolean bl, MinMax minMax, BitSet bitSet) throws PrismException {
        throw new PrismNotSupportedException("Computation not implemented yet");
    }

    protected StateValues checkExpressionReward(Model model, ExpressionReward expressionReward) throws PrismException {
        return this.checkExpressionReward(model, expressionReward, true, null);
    }

    protected StateValues checkExpressionReward(Model model, ExpressionReward expressionReward, boolean bl, Coalition coalition) throws PrismException {
        OpRelOpBound opRelOpBound = expressionReward.getRelopBoundInfo(this.constantValues);
        MinMax minMax = opRelOpBound.getMinMax(model.getModelType());
        RewardStruct rewardStruct = expressionReward.getRewardStructByIndexObject(this.modulesFile, this.constantValues);
        this.mainLog.println("Building reward structure...");
        Rewards rewards = this.constructRewards(model, rewardStruct);
        StateValues stateValues = this.checkRewardFormula(model, rewards, expressionReward.getExpression(), minMax);
        if (this.getVerbosity() > 5) {
            this.mainLog.print("\nRewards (non-zero only) for all states:\n");
            stateValues.print(this.mainLog);
        }
        if (opRelOpBound.isNumeric()) {
            return stateValues;
        }
        BitSet bitSet = stateValues.getBitSetFromInterval(opRelOpBound.getRelOp(), opRelOpBound.getBound());
        stateValues.clear();
        return StateValues.createFromBitSet(bitSet, model);
    }

    protected Rewards constructRewards(Model model, RewardStruct rewardStruct) throws PrismException {
        Rewards rewards;
        ConstructRewards constructRewards = new ConstructRewards(this.mainLog);
        switch (model.getModelType()) {
            case CTMC: 
            case DTMC: {
                rewards = constructRewards.buildMCRewardStructure((DTMC)model, rewardStruct, this.constantValues);
                break;
            }
            case MDP: {
                rewards = constructRewards.buildMDPRewardStructure((MDP)model, rewardStruct, this.constantValues);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Cannot build rewards for " + (Object)((Object)model.getModelType()) + "s");
            }
        }
        return rewards;
    }

    protected StateValues checkRewardFormula(Model model, Rewards rewards, Expression expression, MinMax minMax) throws PrismException {
        StateValues stateValues = null;
        if (expression instanceof ExpressionTemporal) {
            ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
            switch (expressionTemporal.getOperator()) {
                case 13: {
                    stateValues = this.checkRewardReach(model, rewards, expressionTemporal, minMax);
                    break;
                }
                case 12: {
                    stateValues = this.checkRewardInstantaneous(model, rewards, expressionTemporal, minMax);
                    break;
                }
                case 11: {
                    if (expressionTemporal.hasBounds()) {
                        stateValues = this.checkRewardCumulative(model, rewards, expressionTemporal, minMax);
                        break;
                    }
                    stateValues = this.checkRewardTotal(model, rewards, expressionTemporal, minMax);
                    break;
                }
                default: {
                    throw new PrismNotSupportedException("Explicit engine does not yet handle the " + expressionTemporal.getOperatorSymbol() + " reward operator");
                }
            }
        }
        if (stateValues == null) {
            throw new PrismException("Unrecognised operator in R operator");
        }
        return stateValues;
    }

    protected StateValues checkRewardReach(Model model, Rewards rewards, ExpressionTemporal expressionTemporal, MinMax minMax) throws PrismException {
        BitSet bitSet = this.checkExpression(model, expressionTemporal.getOperand2(), null).getBitSet();
        ModelCheckerResult modelCheckerResult = null;
        switch (model.getModelType()) {
            case DTMC: {
                modelCheckerResult = ((DTMCModelChecker)this).computeReachRewards((DTMC)model, (MCRewards)rewards, bitSet);
                break;
            }
            case CTMC: {
                modelCheckerResult = ((CTMCModelChecker)this).computeReachRewards((CTMC)model, (MCRewards)rewards, bitSet);
                break;
            }
            case MDP: {
                modelCheckerResult = ((MDPModelChecker)this).computeReachRewards((MDP)model, (MDPRewards)rewards, bitSet, minMax.isMin());
                this.result.setStrategy(modelCheckerResult.strat);
                break;
            }
            case STPG: {
                modelCheckerResult = ((STPGModelChecker)this).computeReachRewards((STPG)model, (STPGRewards)rewards, bitSet, minMax.isMin1(), minMax.isMin2());
                break;
            }
            default: {
                throw new PrismNotSupportedException("Explicit engine does not yet handle the " + expressionTemporal.getOperatorSymbol() + " reward operator for " + (Object)((Object)model.getModelType()) + "s");
            }
        }
        return StateValues.createFromDoubleArray(modelCheckerResult.soln, model);
    }

    protected StateValues checkRewardInstantaneous(Model model, Rewards rewards, ExpressionTemporal expressionTemporal, MinMax minMax) throws PrismException {
        double d = expressionTemporal.getUpperBound().evaluateDouble(this.constantValues);
        ModelCheckerResult modelCheckerResult = null;
        switch (model.getModelType()) {
            case DTMC: {
                modelCheckerResult = ((DTMCModelChecker)this).computeInstantaneousRewards((DTMC)model, (MCRewards)rewards, d);
                break;
            }
            case CTMC: {
                modelCheckerResult = ((CTMCModelChecker)this).computeInstantaneousRewards((CTMC)model, (MCRewards)rewards, d);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Explicit engine does not yet handle the " + expressionTemporal.getOperatorSymbol() + " reward operator for " + (Object)((Object)model.getModelType()) + "s");
            }
        }
        return StateValues.createFromDoubleArray(modelCheckerResult.soln, model);
    }

    protected StateValues checkRewardCumulative(Model model, Rewards rewards, ExpressionTemporal expressionTemporal, MinMax minMax) throws PrismException {
        int n = -1;
        double d = -1.0;
        if (expressionTemporal.getUpperBound() == null) {
            throw new PrismNotSupportedException("This is not a cumulative reward operator");
        }
        if (model.getModelType().continuousTime()) {
            d = expressionTemporal.getUpperBound().evaluateDouble(this.constantValues);
            if (d < 0.0) {
                throw new PrismException("Invalid time bound " + d + " in cumulative reward formula");
            }
        } else {
            n = expressionTemporal.getUpperBound().evaluateInt(this.constantValues);
            if (n < 0) {
                throw new PrismException("Invalid time bound " + n + " in cumulative reward formula");
            }
        }
        if (n == 0 || d == 0.0) {
            return new StateValues((Type)TypeDouble.getInstance(), model.getNumStates(), new Double(0.0));
        }
        ModelCheckerResult modelCheckerResult = null;
        switch (model.getModelType()) {
            case DTMC: {
                modelCheckerResult = ((DTMCModelChecker)this).computeCumulativeRewards((DTMC)model, (MCRewards)rewards, n);
                break;
            }
            case CTMC: {
                modelCheckerResult = ((CTMCModelChecker)this).computeCumulativeRewards((CTMC)model, (MCRewards)rewards, d);
                break;
            }
            case MDP: {
                modelCheckerResult = ((MDPModelChecker)this).computeCumulativeRewards((MDP)model, (MDPRewards)rewards, n, minMax.isMin());
                this.result.setStrategy(modelCheckerResult.strat);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Explicit engine does not yet handle the " + expressionTemporal.getOperatorSymbol() + " reward operator for " + (Object)((Object)model.getModelType()) + "s");
            }
        }
        return StateValues.createFromDoubleArray(modelCheckerResult.soln, model);
    }

    protected StateValues checkRewardTotal(Model model, Rewards rewards, ExpressionTemporal expressionTemporal, MinMax minMax) throws PrismException {
        if (expressionTemporal.getUpperBound() != null) {
            throw new PrismException("This is not a total reward operator");
        }
        ModelCheckerResult modelCheckerResult = null;
        switch (model.getModelType()) {
            case DTMC: {
                modelCheckerResult = ((DTMCModelChecker)this).computeTotalRewards((DTMC)model, (MCRewards)rewards);
                break;
            }
            case CTMC: {
                break;
            }
            case MDP: {
                break;
            }
            default: {
                throw new PrismNotSupportedException("Explicit engine does not yet handle the " + expressionTemporal.getOperatorSymbol() + " reward operator for " + (Object)((Object)model.getModelType()) + "s");
            }
        }
        return StateValues.createFromDoubleArray(modelCheckerResult.soln, model);
    }

    protected StateValues checkExpressionSteadyState(Model model, ExpressionSS expressionSS) throws PrismException {
        OpRelOpBound opRelOpBound = expressionSS.getRelopBoundInfo(this.constantValues);
        MinMax minMax = opRelOpBound.getMinMax(model.getModelType());
        StateValues stateValues = this.checkSteadyStateFormula(model, expressionSS.getExpression(), minMax);
        if (this.getVerbosity() > 5) {
            this.mainLog.print("\nProbabilities (non-zero only) for all states:\n");
            stateValues.print(this.mainLog);
        }
        if (opRelOpBound.isNumeric()) {
            return stateValues;
        }
        BitSet bitSet = stateValues.getBitSetFromInterval(opRelOpBound.getRelOp(), opRelOpBound.getBound());
        stateValues.clear();
        return StateValues.createFromBitSet(bitSet, model);
    }

    protected StateValues checkSteadyStateFormula(Model model, Expression expression, MinMax minMax) throws PrismException {
        BitSet bitSet = this.checkExpression(model, expression, null).getBitSet();
        ModelCheckerResult modelCheckerResult = null;
        switch (model.getModelType()) {
            case DTMC: {
                double[] dArray = Utils.bitsetToDoubleArray(bitSet, model.getNumStates());
                modelCheckerResult = ((DTMCModelChecker)this).computeSteadyStateBackwardsProbs((DTMC)model, dArray);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Explicit engine does not yet handle the S operator for " + (Object)((Object)model.getModelType()) + "s");
            }
        }
        return StateValues.createFromDoubleArray(modelCheckerResult.soln, model);
    }

    public static enum SolnMethod {
        VALUE_ITERATION,
        GAUSS_SEIDEL,
        POLICY_ITERATION,
        MODIFIED_POLICY_ITERATION,
        LINEAR_PROGRAMMING;

    }

    public static enum ValIterDir {
        BELOW,
        ABOVE;

    }

    public static enum TermCrit {
        ABSOLUTE,
        RELATIVE;

    }

    public static enum MDPSolnMethod {
        VALUE_ITERATION,
        GAUSS_SEIDEL,
        POLICY_ITERATION,
        MODIFIED_POLICY_ITERATION,
        LINEAR_PROGRAMMING;


        public String fullName() {
            switch (this) {
                case VALUE_ITERATION: {
                    return "Value iteration";
                }
                case GAUSS_SEIDEL: {
                    return "Gauss-Seidel";
                }
                case POLICY_ITERATION: {
                    return "Policy iteration";
                }
                case MODIFIED_POLICY_ITERATION: {
                    return "Modified policy iteration";
                }
                case LINEAR_PROGRAMMING: {
                    return "Linear programming";
                }
            }
            return this.toString();
        }
    }

    public static enum LinEqMethod {
        POWER,
        JACOBI,
        GAUSS_SEIDEL,
        BACKWARDS_GAUSS_SEIDEL,
        JOR,
        SOR,
        BACKWARDS_SOR;


        public String fullName() {
            switch (this) {
                case POWER: {
                    return "Power method";
                }
                case JACOBI: {
                    return "Jacobi";
                }
                case GAUSS_SEIDEL: {
                    return "Gauss-Seidel";
                }
                case BACKWARDS_GAUSS_SEIDEL: {
                    return "Backwards Gauss-Seidel";
                }
                case JOR: {
                    return "JOR";
                }
                case SOR: {
                    return "SOR";
                }
                case BACKWARDS_SOR: {
                    return "Backwards SOR";
                }
            }
            return this.toString();
        }
    }
}

