/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.CTMC;
import explicit.CTMCModelChecker;
import explicit.CTMDPModelChecker;
import explicit.ConstructModel;
import explicit.DTMC;
import explicit.DTMCModelChecker;
import explicit.DTMCSimple;
import explicit.MDPModelChecker;
import explicit.Model;
import explicit.ProbModelChecker;
import explicit.STPGModelChecker;
import explicit.StateValues;
import java.io.File;
import java.io.FileNotFoundException;
import parser.ast.Expression;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.type.Type;
import parser.type.TypeBool;
import prism.ModelType;
import prism.Prism;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLangException;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import prism.PrismSettings;
import prism.Result;
import simulator.SimulatorEngine;

public class PrismExplicit
extends PrismComponent {
    public PrismExplicit(PrismLog prismLog, PrismSettings prismSettings) {
        this.mainLog = prismLog;
        this.settings = prismSettings;
    }

    public Model buildModel(ModulesFile modulesFile, SimulatorEngine simulatorEngine) throws PrismException {
        if (modulesFile.getModelType() == ModelType.PTA) {
            throw new PrismNotSupportedException("You cannot build a PTA model explicitly, only perform model checking");
        }
        this.mainLog.print("\nBuilding model...\n");
        ConstructModel constructModel = new ConstructModel(this, simulatorEngine);
        long l = System.currentTimeMillis();
        Model model = constructModel.constructModel(modulesFile, false, true);
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nTime for model construction: " + (double)l / 1000.0 + " seconds.");
        return model;
    }

    public void exportTransToFile(Model model, boolean bl, int n, File file) throws FileNotFoundException, PrismException {
        if (!bl) {
            this.mainLog.printWarning("Cannot export unordered transition matrix with the explicit engine; using ordered.");
            bl = true;
        }
        this.mainLog.print("\nExporting transition matrix ");
        switch (n) {
            case 1: {
                this.mainLog.print("in plain text format ");
                break;
            }
            case 2: {
                this.mainLog.print("in Matlab format ");
                break;
            }
            case 3: {
                this.mainLog.print("in Dot format ");
                break;
            }
            case 4: {
                this.mainLog.print("in MRMC format ");
                break;
            }
            case 5: {
                this.mainLog.print("in rows format ");
                break;
            }
            case 6: {
                this.mainLog.print("in Dot format (with states) ");
            }
        }
        if (file != null) {
            this.mainLog.println("to file \"" + file + "\"...");
        } else {
            this.mainLog.println("below:");
        }
        PrismLog prismLog = this.getPrismLogForFile(file);
        switch (n) {
            case 1: {
                model.exportToPrismExplicitTra(prismLog);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                throw new PrismNotSupportedException("Export not yet supported");
            }
        }
    }

    public void exportStatesToFile(ModulesFile modulesFile, Model model, int n, File file) throws FileNotFoundException {
        PrismLog prismLog;
        if (n == 4) {
            n = 1;
        }
        if (n == 5) {
            n = 1;
        }
        this.mainLog.print("\nExporting list of reachable states ");
        switch (n) {
            case 1: {
                this.mainLog.print("in plain text format ");
                break;
            }
            case 2: {
                this.mainLog.print("in Matlab format ");
            }
        }
        if (file != null) {
            this.mainLog.println("to file \"" + file + "\"...");
        } else {
            this.mainLog.println("below:");
        }
        if (file != null) {
            prismLog = new PrismFileLog(file.getPath());
            if (!prismLog.ready()) {
                throw new FileNotFoundException();
            }
        } else {
            prismLog = this.mainLog;
        }
        if (n == 2) {
            prismLog.print("% ");
        }
        prismLog.print("(");
        for (int i = 0; i < modulesFile.getNumVars(); ++i) {
            prismLog.print(modulesFile.getVarName(i));
            if (i >= modulesFile.getNumVars() - 1) continue;
            prismLog.print(",");
        }
        prismLog.println(")");
        if (n == 2) {
            prismLog.println("states=[");
        }
        StateValues stateValues = null;
        try {
            stateValues = new StateValues((Type)TypeBool.getInstance(), new Boolean(true), model);
        }
        catch (PrismLangException prismLangException) {
            // empty catch block
        }
        if (n != 2) {
            stateValues.print(prismLog);
        } else {
            stateValues.print(prismLog, true, true, true, true);
        }
        if (n == 2) {
            prismLog.println("];");
        }
        if (file != null) {
            prismLog.close();
        }
    }

    public Result modelCheck(Model model, ModulesFile modulesFile, PropertiesFile propertiesFile, Expression expression) throws PrismException, PrismLangException {
        ProbModelChecker probModelChecker = null;
        Result result = null;
        expression.checkValid(model.getModelType());
        switch (model.getModelType()) {
            case DTMC: {
                probModelChecker = new DTMCModelChecker(this);
                break;
            }
            case MDP: {
                probModelChecker = new MDPModelChecker(this);
                break;
            }
            case CTMC: {
                probModelChecker = new CTMCModelChecker(this);
                break;
            }
            case CTMDP: {
                probModelChecker = new CTMDPModelChecker(this);
                break;
            }
            case STPG: {
                probModelChecker = new STPGModelChecker(this);
                break;
            }
            default: {
                throw new PrismException("Unknown model type " + (Object)((Object)model.getModelType()));
            }
        }
        probModelChecker.setModulesFileAndPropertiesFile(modulesFile, propertiesFile);
        result = probModelChecker.check(model, expression);
        return result;
    }

    public void doSteadyState(Model model) throws PrismException {
        this.doSteadyState(model, 1, null);
    }

    public void doSteadyState(Model model, int n, File file) throws PrismException {
        PrismLog prismLog;
        long l = 0L;
        StateValues stateValues = null;
        if (model.getModelType() != ModelType.CTMC && model.getModelType() != ModelType.DTMC) {
            throw new PrismNotSupportedException("Steady-state probabilities only computed for DTMCs/CTMCs");
        }
        if (n == 4) {
            n = 1;
        }
        if (n == 5) {
            n = 1;
        }
        this.mainLog.println("\nComputing steady-state probabilities...");
        l = System.currentTimeMillis();
        stateValues = this.computeSteadyStateProbabilities(model);
        l = System.currentTimeMillis() - l;
        this.mainLog.print("\nPrinting steady-state probabilities ");
        switch (n) {
            case 1: {
                this.mainLog.print("in plain text format ");
                break;
            }
            case 2: {
                this.mainLog.print("in Matlab format ");
            }
        }
        if (file != null) {
            this.mainLog.println("to file \"" + file + "\"...");
        } else {
            this.mainLog.println("below:");
        }
        if (file != null) {
            prismLog = new PrismFileLog(file.getPath());
            if (!prismLog.ready()) {
                throw new PrismException("Could not open file \"" + file + "\" for output");
            }
        } else {
            prismLog = this.mainLog;
        }
        stateValues.print(prismLog, file == null, n == 2, file == null, true);
        this.mainLog.println("\nTime for steady-state probability computation: " + (double)l / 1000.0 + " seconds.");
        stateValues.clear();
        if (file != null) {
            prismLog.close();
        }
    }

    public StateValues computeSteadyStateProbabilities(Model model) throws PrismException {
        if (model.getModelType() != ModelType.DTMC) {
            if (model.getModelType() == ModelType.CTMC) {
                throw new PrismNotSupportedException("Not implemented yet");
            }
            throw new PrismNotSupportedException("Steady-state probabilities only computed for DTMCs/CTMCs");
        }
        DTMCModelChecker dTMCModelChecker = new DTMCModelChecker(this);
        StateValues stateValues = dTMCModelChecker.doSteadyState((DTMC)model);
        return stateValues;
    }

    public void doTransient(Model model, double d) throws PrismException {
        this.doTransient(model, d, 1, null, null);
    }

    public void doTransient(Model model, double d, int n, File file, File file2) throws PrismException {
        PrismLog prismLog;
        long l = 0L;
        StateValues stateValues = null;
        if (d < 0.0) {
            throw new PrismException("Cannot compute transient probabilities for negative time value");
        }
        if (n == 4) {
            n = 1;
        }
        if (n == 5) {
            n = 1;
        }
        l = System.currentTimeMillis();
        if (model.getModelType() == ModelType.DTMC) {
            throw new PrismNotSupportedException("Not implemented yet");
        }
        if (model.getModelType() != ModelType.CTMC) {
            throw new PrismNotSupportedException("Transient probabilities only computed for DTMCs/CTMCs");
        }
        this.mainLog.println("\nComputing transient probabilities (time = " + d + ")...");
        CTMCModelChecker cTMCModelChecker = new CTMCModelChecker(this);
        stateValues = cTMCModelChecker.doTransient((CTMC)model, d, file2);
        l = System.currentTimeMillis() - l;
        this.mainLog.print("\nPrinting transient probabilities ");
        switch (n) {
            case 1: {
                this.mainLog.print("in plain text format ");
                break;
            }
            case 2: {
                this.mainLog.print("in Matlab format ");
            }
        }
        if (file != null) {
            this.mainLog.println("to file \"" + file + "\"...");
        } else {
            this.mainLog.println("below:");
        }
        if (file != null) {
            prismLog = new PrismFileLog(file.getPath());
            if (!prismLog.ready()) {
                throw new PrismException("Could not open file \"" + file + "\" for output");
            }
        } else {
            prismLog = this.mainLog;
        }
        stateValues.print(prismLog, file == null, n == 2, file == null, file == null);
        this.mainLog.println("\nTime for transient probability computation: " + (double)l / 1000.0 + " seconds.");
        stateValues.clear();
        if (file != null) {
            prismLog.close();
        }
    }

    private PrismLog getPrismLogForFile(File file) throws PrismException {
        PrismLog prismLog;
        if (file != null) {
            prismLog = new PrismFileLog(file.getPath());
            if (!prismLog.ready()) {
                throw new PrismException("Could not open file \"" + file + "\" for output");
            }
        } else {
            prismLog = this.mainLog;
        }
        return prismLog;
    }

    public static void main(String[] stringArray) {
        PrismExplicit.modelCheckFromPrismFile(stringArray);
    }

    private static void modelCheckFromPrismFile(String[] stringArray) {
        try {
            PrismFileLog prismFileLog = new PrismFileLog("stdout");
            Prism prism = new Prism(prismFileLog, prismFileLog);
            ModulesFile modulesFile = prism.parseModelFile(new File(stringArray[0]));
            modulesFile.setUndefinedConstants(null);
            PropertiesFile propertiesFile = prism.parsePropertiesFile(modulesFile, new File(stringArray[1]));
            propertiesFile.setUndefinedConstants(null);
            PrismExplicit prismExplicit = new PrismExplicit(prism.getMainLog(), prism.getSettings());
            Model model = prismExplicit.buildModel(modulesFile, prism.getSimulator());
            prismExplicit.modelCheck(model, modulesFile, propertiesFile, propertiesFile.getProperty(0));
        }
        catch (PrismException prismException) {
            System.out.println(prismException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException);
        }
    }

    private static void modelCheckViaExplicitFiles(String[] stringArray) {
        try {
            PrismFileLog prismFileLog = new PrismFileLog("stdout");
            Prism prism = new Prism(prismFileLog, prismFileLog);
            prism.initialise();
            prism.setDoProbChecks(false);
            ModulesFile modulesFile = prism.parseModelFile(new File(stringArray[0]));
            PropertiesFile propertiesFile = prism.parsePropertiesFile(modulesFile, new File(stringArray[1]));
            prism.loadPRISMModel(modulesFile);
            prism.exportTransToFile(true, 1, new File("tmp.tra"));
            prism.exportLabelsToFile(null, 1, new File("tmp.lab"));
            DTMCSimple dTMCSimple = new DTMCSimple();
            dTMCSimple.buildFromPrismExplicit("tmp.tra");
            PrismExplicit prismExplicit = new PrismExplicit(prism.getMainLog(), prism.getSettings());
            prismExplicit.modelCheck(dTMCSimple, null, propertiesFile, propertiesFile.getProperty(0));
        }
        catch (PrismException prismException) {
            System.out.println(prismException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException);
        }
    }
}

