/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import acceptance.AcceptanceReach;
import acceptance.AcceptanceType;
import explicit.DTMCFromMDPMemorylessAdversary;
import explicit.DTMCModelChecker;
import explicit.LTLModelChecker;
import explicit.MDP;
import explicit.MDPSimple;
import explicit.MinMax;
import explicit.Model;
import explicit.ModelCheckerResult;
import explicit.NondetModel;
import explicit.ProbModelChecker;
import explicit.StateValues;
import explicit.Utils;
import explicit.rewards.MCRewardsFromMDPRewards;
import explicit.rewards.MDPRewards;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import parser.VarList;
import parser.ast.Declaration;
import parser.ast.DeclarationIntUnbounded;
import parser.ast.Expression;
import prism.PrismComponent;
import prism.PrismDevNullLog;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;
import prism.PrismUtils;
import strat.MDStrategyArray;

public class MDPModelChecker
extends ProbModelChecker {
    public MDPModelChecker(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    @Override
    protected StateValues checkProbPathFormulaLTL(Model model, Expression expression, boolean bl, MinMax minMax, BitSet bitSet) throws PrismException {
        Object object;
        if (minMax.isMin()) {
            expression = Expression.Not(Expression.Parenth(expression.deepCopy()));
        }
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this);
        AcceptanceType[] acceptanceTypeArray = new AcceptanceType[]{AcceptanceType.RABIN, AcceptanceType.GENERALIZED_RABIN, AcceptanceType.REACH};
        LTLModelChecker.LTLProduct<MDP> lTLProduct = lTLModelChecker.constructProductMDP(this, (MDP)model, expression, bitSet, acceptanceTypeArray);
        if (this.getExportProductTrans()) {
            this.mainLog.println("\nExporting product transition matrix to file \"" + this.getExportProductTransFilename() + "\"...");
            ((MDP)lTLProduct.getProductModel()).exportToPrismExplicitTra(this.getExportProductTransFilename());
        }
        if (this.getExportProductStates()) {
            this.mainLog.println("\nExporting product state space to file \"" + this.getExportProductStatesFilename() + "\"...");
            object = new PrismFileLog(this.getExportProductStatesFilename());
            VarList varList = (VarList)this.modulesFile.createVarList().clone();
            String string = "_da";
            while (varList.getIndex(string) != -1) {
                string = "_" + string;
            }
            varList.addVar(0, new Declaration(string, new DeclarationIntUnbounded()), 1, null);
            ((MDP)lTLProduct.getProductModel()).exportStates(1, varList, (PrismLog)object);
            ((PrismFileLog)object).close();
        }
        if (lTLProduct.getAcceptance() instanceof AcceptanceReach) {
            this.mainLog.println("\nSkipping accepting MEC computation since acceptance is defined via goal states...");
            object = ((AcceptanceReach)lTLProduct.getAcceptance()).getGoalStates();
        } else {
            this.mainLog.println("\nFinding accepting MECs...");
            object = lTLModelChecker.findAcceptingECStates((NondetModel)lTLProduct.getProductModel(), lTLProduct.getAcceptance());
        }
        this.mainLog.println("\nComputing reachability probabilities...");
        MDPModelChecker mDPModelChecker = new MDPModelChecker(this);
        mDPModelChecker.inheritSettings(this);
        StateValues stateValues = StateValues.createFromDoubleArray(mDPModelChecker.computeReachProbs((MDP)((MDP)lTLProduct.getProductModel()), (BitSet)object, (boolean)false).soln, lTLProduct.getProductModel());
        if (minMax.isMin()) {
            stateValues.timesConstant(-1.0);
            stateValues.plusConstant(1.0);
        }
        StateValues stateValues2 = lTLProduct.projectToOriginalModel(stateValues);
        stateValues.clear();
        return stateValues2;
    }

    public ModelCheckerResult computeNextProbs(MDP mDP, BitSet bitSet, boolean bl) throws PrismException {
        ModelCheckerResult modelCheckerResult = null;
        long l = System.currentTimeMillis();
        int n = mDP.getNumStates();
        double[] dArray = Utils.bitsetToDoubleArray(bitSet, n);
        double[] dArray2 = new double[n];
        mDP.mvMultMinMax(dArray, bl, dArray2, null, false, null);
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray2;
        modelCheckerResult.numIters = 1;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public double[] computeRestrictedNext(MDP mDP, BitSet bitSet, double[] dArray, boolean bl) {
        int n = mDP.getNumStates();
        double[] dArray2 = new double[n];
        mDP.mvMultMinMax(dArray, bl, dArray2, bitSet, false, null);
        return dArray2;
    }

    public ModelCheckerResult computeReachProbs(MDP mDP, BitSet bitSet, boolean bl) throws PrismException {
        return this.computeReachProbs(mDP, null, bitSet, bl, null, null);
    }

    public ModelCheckerResult computeUntilProbs(MDP mDP, BitSet bitSet, BitSet bitSet2, boolean bl) throws PrismException {
        return this.computeReachProbs(mDP, bitSet, bitSet2, bl, null, null);
    }

    public ModelCheckerResult computeReachProbs(MDP mDP, BitSet bitSet, BitSet bitSet2, boolean bl, double[] dArray, BitSet bitSet3) throws PrismException {
        long l;
        long l2;
        Object object;
        long l3;
        int[] nArray;
        ModelCheckerResult modelCheckerResult;
        block26: {
            BitSet bitSet4;
            int n;
            block25: {
                int n2;
                modelCheckerResult = null;
                nArray = null;
                ProbModelChecker.MDPSolnMethod mDPSolnMethod = this.mdpSolnMethod;
                if (mDPSolnMethod == ProbModelChecker.MDPSolnMethod.LINEAR_PROGRAMMING) {
                    mDPSolnMethod = ProbModelChecker.MDPSolnMethod.GAUSS_SEIDEL;
                    this.mainLog.printWarning("Switching to MDP solution method \"" + mDPSolnMethod.fullName() + "\"");
                }
                if (mDPSolnMethod == ProbModelChecker.MDPSolnMethod.VALUE_ITERATION && this.valIterDir == ProbModelChecker.ValIterDir.ABOVE) {
                    if (!this.precomp || !this.prob0) {
                        throw new PrismException("Precomputation (Prob0) must be enabled for value iteration from above");
                    }
                    if (!bl) {
                        throw new PrismException("Value iteration from above only works for minimum probabilities");
                    }
                }
                if ((mDPSolnMethod == ProbModelChecker.MDPSolnMethod.POLICY_ITERATION || mDPSolnMethod == ProbModelChecker.MDPSolnMethod.MODIFIED_POLICY_ITERATION) && bitSet3 != null) {
                    throw new PrismException("Policy iteration methods cannot be passed 'known' values for some states");
                }
                l3 = System.currentTimeMillis();
                this.mainLog.println("\nStarting probabilistic reachability (" + (bl ? "min" : "max") + ")...");
                mDP.checkForDeadlocks(bitSet2);
                n = mDP.getNumStates();
                BitSet bitSet5 = bitSet2;
                if (dArray != null && bitSet3 != null) {
                    bitSet2 = new BitSet(n);
                    for (n2 = 0; n2 < n; ++n2) {
                        bitSet2.set(n2, bitSet5.get(n2) || bitSet3.get(n2) && dArray[n2] == 1.0);
                    }
                }
                if (this.getExportTarget()) {
                    object = new BitSet(n);
                    for (n2 = 0; n2 < n; ++n2) {
                        ((BitSet)object).set(n2, mDP.isInitialState(n2));
                    }
                    List<BitSet> list = Arrays.asList(object, bitSet2);
                    List<String> list2 = Arrays.asList("init", "target");
                    this.mainLog.println("\nExporting target states info to file \"" + this.getExportTargetFilename() + "\"...");
                    this.exportLabels(mDP, list, list2, 1, new PrismFileLog(this.getExportTargetFilename()));
                }
                if (this.genStrat || this.exportAdv) {
                    nArray = new int[n];
                    for (n2 = 0; n2 < n; ++n2) {
                        nArray[n2] = bitSet2.get(n2) ? -2 : -1;
                    }
                }
                l2 = System.currentTimeMillis();
                BitSet bitSet6 = this.precomp && this.prob0 ? this.prob0(mDP, bitSet, bitSet2, bl, nArray) : new BitSet();
                l2 = System.currentTimeMillis() - l2;
                l = System.currentTimeMillis();
                bitSet4 = this.precomp && this.prob1 ? this.prob1(mDP, bitSet, bitSet2, bl, nArray) : (BitSet)bitSet2.clone();
                l = System.currentTimeMillis() - l;
                int n3 = bitSet4.cardinality();
                int n4 = bitSet6.cardinality();
                this.mainLog.println("target=" + bitSet2.cardinality() + ", yes=" + n3 + ", no=" + n4 + ", maybe=" + (n - (n3 + n4)));
                if (this.genStrat || this.exportAdv) {
                    if (bl) {
                        n2 = bitSet4.nextSetBit(0);
                        while (n2 >= 0) {
                            if (!bitSet2.get(n2)) {
                                nArray[n2] = -2;
                            }
                            n2 = bitSet4.nextSetBit(n2 + 1);
                        }
                    } else {
                        n2 = bitSet6.nextSetBit(0);
                        while (n2 >= 0) {
                            nArray[n2] = -2;
                            n2 = bitSet6.nextSetBit(n2 + 1);
                        }
                    }
                }
                if (n3 + n4 >= n) break block25;
                switch (mDPSolnMethod) {
                    case VALUE_ITERATION: {
                        modelCheckerResult = this.computeReachProbsValIter(mDP, bitSet6, bitSet4, bl, dArray, bitSet3, nArray);
                        break block26;
                    }
                    case GAUSS_SEIDEL: {
                        modelCheckerResult = this.computeReachProbsGaussSeidel(mDP, bitSet6, bitSet4, bl, dArray, bitSet3, nArray);
                        break block26;
                    }
                    case POLICY_ITERATION: {
                        modelCheckerResult = this.computeReachProbsPolIter(mDP, bitSet6, bitSet4, bl, nArray);
                        break block26;
                    }
                    case MODIFIED_POLICY_ITERATION: {
                        modelCheckerResult = this.computeReachProbsModPolIter(mDP, bitSet6, bitSet4, bl, nArray);
                        break block26;
                    }
                    default: {
                        throw new PrismException("Unknown MDP solution method " + mDPSolnMethod.fullName());
                    }
                }
            }
            modelCheckerResult = new ModelCheckerResult();
            modelCheckerResult.soln = Utils.bitsetToDoubleArray(bitSet4, n);
        }
        l3 = System.currentTimeMillis() - l3;
        this.mainLog.println("Probabilistic reachability took " + (double)l3 / 1000.0 + " seconds.");
        if (this.genStrat) {
            modelCheckerResult.strat = new MDStrategyArray(mDP, nArray);
        }
        if (this.exportAdv) {
            this.restrictStrategyToReachableStates(mDP, nArray);
            object = new PrismFileLog(this.exportAdvFilename);
            new DTMCFromMDPMemorylessAdversary(mDP, nArray).exportToPrismExplicitTra((PrismLog)object);
            ((PrismLog)object).close();
        }
        modelCheckerResult.timeTaken = (double)l3 / 1000.0;
        modelCheckerResult.timeProb0 = (double)l2 / 1000.0;
        modelCheckerResult.timePre = (double)(l2 + l) / 1000.0;
        return modelCheckerResult;
    }

    public BitSet prob0(MDP mDP, BitSet bitSet, BitSet bitSet2, boolean bl, int[] nArray) {
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting Prob0 (" + (bl ? "min" : "max") + ")...");
        if (bitSet2.cardinality() == 0) {
            BitSet bitSet3 = new BitSet(mDP.getNumStates());
            bitSet3.set(0, mDP.getNumStates());
            return bitSet3;
        }
        int n = mDP.getNumStates();
        BitSet bitSet4 = new BitSet(n);
        BitSet bitSet5 = new BitSet(n);
        BitSet bitSet6 = new BitSet();
        bitSet6.set(0, n);
        bitSet6.andNot(bitSet2);
        if (bitSet != null) {
            bitSet6.and(bitSet);
        }
        int n2 = 0;
        boolean bl2 = false;
        bitSet4.or(bitSet2);
        bitSet5.or(bitSet2);
        while (!bl2) {
            ++n2;
            mDP.prob0step(bitSet6, bitSet4, bl, bitSet5);
            bl2 = bitSet5.equals(bitSet4);
            bitSet4.clear();
            bitSet4.or(bitSet5);
        }
        bitSet4.flip(0, n);
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Prob0 (" + (bl ? "min" : "max") + ")");
        this.mainLog.println(" took " + n2 + " iterations and " + (double)l / 1000.0 + " seconds.");
        if (nArray != null) {
            int n3 = bitSet4.nextSetBit(0);
            while (n3 >= 0) {
                int n4 = mDP.getNumChoices(n3);
                for (int i = 0; i < n4; ++i) {
                    if (!mDP.allSuccessorsInSet(n3, i, bitSet4)) continue;
                    nArray[n3] = i;
                }
                n3 = bitSet4.nextSetBit(n3 + 1);
            }
        }
        return bitSet4;
    }

    public BitSet prob1(MDP mDP, BitSet bitSet, BitSet bitSet2, boolean bl, int[] nArray) {
        boolean bl2;
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting Prob1 (" + (bl ? "min" : "max") + ")...");
        if (bitSet2.cardinality() == 0) {
            return new BitSet(mDP.getNumStates());
        }
        int n = mDP.getNumStates();
        BitSet bitSet3 = new BitSet(n);
        BitSet bitSet4 = new BitSet(n);
        BitSet bitSet5 = new BitSet(n);
        BitSet bitSet6 = new BitSet();
        bitSet6.set(0, n);
        bitSet6.andNot(bitSet2);
        if (bitSet != null) {
            bitSet6.and(bitSet);
        }
        int n2 = 0;
        boolean bl3 = false;
        bitSet3.set(0, n);
        while (!bl3) {
            bl2 = false;
            bitSet4.clear();
            bitSet4.or(bitSet2);
            bitSet5.clear();
            bitSet5.or(bitSet2);
            while (!bl2) {
                ++n2;
                if (bl) {
                    mDP.prob1Astep(bitSet6, bitSet3, bitSet4, bitSet5);
                } else {
                    mDP.prob1Estep(bitSet6, bitSet3, bitSet4, bitSet5, null);
                }
                bl2 = bitSet5.equals(bitSet4);
                bitSet4.clear();
                bitSet4.or(bitSet5);
            }
            bl3 = bitSet4.equals(bitSet3);
            bitSet3.clear();
            bitSet3.or(bitSet4);
        }
        bitSet6.and(bitSet3);
        if (!bl && nArray != null) {
            bl2 = false;
            bitSet4.clear();
            bitSet4.or(bitSet2);
            bitSet5.clear();
            bitSet5.or(bitSet2);
            while (!bl2) {
                mDP.prob1Estep(bitSet6, bitSet3, bitSet4, bitSet5, nArray);
                bl2 = bitSet5.equals(bitSet4);
                bitSet4.clear();
                bitSet4.or(bitSet5);
            }
            bl3 = bitSet4.equals(bitSet3);
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Prob1 (" + (bl ? "min" : "max") + ")");
        this.mainLog.println(" took " + n2 + " iterations and " + (double)l / 1000.0 + " seconds.");
        return bitSet3;
    }

    protected ModelCheckerResult computeReachProbsValIter(MDP mDP, BitSet bitSet, BitSet bitSet2, boolean bl, double[] dArray, BitSet bitSet3, int[] nArray) throws PrismException {
        int n;
        int n2;
        double d;
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting value iteration (" + (bl ? "min" : "max") + ")...");
        int n3 = mDP.getNumStates();
        double[] dArray2 = new double[n3];
        double[] dArray3 = dArray == null ? new double[n3] : dArray;
        double d2 = d = this.valIterDir == ProbModelChecker.ValIterDir.BELOW ? 0.0 : 1.0;
        if (dArray != null) {
            if (bitSet3 != null) {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray3[n2] = bitSet3.get(n2) ? dArray[n2] : (bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : dArray[n2]));
                    dArray2[n2] = dArray3[n2];
                }
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray3[n2] = bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : dArray[n2]);
                    dArray2[n2] = dArray3[n2];
                }
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray3[n2] = bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : d);
                dArray2[n2] = dArray3[n2];
            }
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n3);
        bitSet4.andNot(bitSet2);
        bitSet4.andNot(bitSet);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        boolean bl2 = false;
        for (n = 0; !bl2 && n < this.maxIters; ++n) {
            mDP.mvMultMinMax(dArray2, bl, dArray3, bitSet4, false, nArray);
            bl2 = PrismUtils.doublesAreClose(dArray2, dArray3, this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
            double[] dArray4 = dArray2;
            dArray2 = dArray3;
            dArray3 = dArray4;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Value iteration (" + (bl ? "min" : "max") + ")");
        this.mainLog.println(" took " + n + " iterations and " + (double)l / 1000.0 + " seconds.");
        if (!bl2 && this.errorOnNonConverge) {
            String string = "Iterative method did not converge within " + n + " iterations.";
            string = string + "\nConsider using a different numerical method or increasing the maximum number of iterations";
            throw new PrismException(string);
        }
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray2;
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    protected ModelCheckerResult computeReachProbsGaussSeidel(MDP mDP, BitSet bitSet, BitSet bitSet2, boolean bl, double[] dArray, BitSet bitSet3, int[] nArray) throws PrismException {
        int n;
        int n2;
        double d;
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting Gauss-Seidel (" + (bl ? "min" : "max") + ")...");
        int n3 = mDP.getNumStates();
        double[] dArray2 = dArray == null ? new double[n3] : dArray;
        double d2 = d = this.valIterDir == ProbModelChecker.ValIterDir.BELOW ? 0.0 : 1.0;
        if (dArray != null) {
            if (bitSet3 != null) {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray2[n2] = bitSet3.get(n2) ? dArray[n2] : (bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : dArray[n2]));
                }
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray2[n2] = bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : dArray[n2]);
                }
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray2[n2] = bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : d);
            }
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n3);
        bitSet4.andNot(bitSet2);
        bitSet4.andNot(bitSet);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        boolean bl2 = false;
        for (n = 0; !bl2 && n < this.maxIters; ++n) {
            double d3 = mDP.mvMultGSMinMax(dArray2, bl, bitSet4, false, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE, nArray);
            bl2 = d3 < this.termCritParam;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Gauss-Seidel");
        this.mainLog.println(" took " + n + " iterations and " + (double)l / 1000.0 + " seconds.");
        if (!bl2 && this.errorOnNonConverge) {
            String string = "Iterative method did not converge within " + n + " iterations.";
            string = string + "\nConsider using a different numerical method or increasing the maximum number of iterations";
            throw new PrismException(string);
        }
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray2;
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    protected ModelCheckerResult computeReachProbsPolIter(MDP mDP, BitSet bitSet, BitSet bitSet2, boolean bl, int[] nArray) throws PrismException {
        ModelCheckerResult modelCheckerResult;
        int n;
        boolean bl2 = true;
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting policy iteration (" + (bl ? "min" : "max") + ")...");
        DTMCModelChecker dTMCModelChecker = new DTMCModelChecker(this);
        dTMCModelChecker.inheritSettings(this);
        dTMCModelChecker.setLog(new PrismDevNullLog());
        int n2 = mDP.getNumStates();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray2[n] = bitSet2.get(n) ? 1.0 : 0.0;
            dArray[n] = dArray2[n];
        }
        if (nArray == null) {
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = 0;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                if (bitSet.get(n) || bitSet2.get(n)) continue;
                nArray[n] = 0;
            }
        }
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = false;
        while (!bl3) {
            ++n4;
            DTMCFromMDPMemorylessAdversary dTMCFromMDPMemorylessAdversary = new DTMCFromMDPMemorylessAdversary(mDP, nArray);
            modelCheckerResult = dTMCModelChecker.computeReachProbsGaussSeidel(dTMCFromMDPMemorylessAdversary, bitSet, bitSet2, (double[])(bl2 ? dArray : null), null);
            dArray = modelCheckerResult.soln;
            n3 += modelCheckerResult.numIters;
            mDP.mvMultMinMax(dArray, bl, dArray2, null, false, null);
            bl3 = true;
            for (n = 0; n < n2; ++n) {
                if (bitSet.get(n) || bitSet2.get(n) || PrismUtils.doublesAreClose(dArray[n], dArray2[n], this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE)) continue;
                bl3 = false;
                List<Integer> list = mDP.mvMultMinMaxSingleChoices(n, dArray, bl, dArray2[n]);
                if (list.contains(nArray[n])) continue;
                nArray[n] = list.get(0);
            }
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Policy iteration");
        this.mainLog.println(" took " + n4 + " cycles (" + n3 + " iterations in total) and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray;
        modelCheckerResult.numIters = n3;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    protected ModelCheckerResult computeReachProbsModPolIter(MDP mDP, BitSet bitSet, BitSet bitSet2, boolean bl, int[] nArray) throws PrismException {
        ModelCheckerResult modelCheckerResult;
        int n;
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting modified policy iteration (" + (bl ? "min" : "max") + ")...");
        DTMCModelChecker dTMCModelChecker = new DTMCModelChecker(this);
        dTMCModelChecker.inheritSettings(this);
        dTMCModelChecker.setLog(new PrismDevNullLog());
        dTMCModelChecker.setMaxIters(100);
        dTMCModelChecker.setErrorOnNonConverge(false);
        int n2 = mDP.getNumStates();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray2[n] = bitSet2.get(n) ? 1.0 : 0.0;
            dArray[n] = dArray2[n];
        }
        if (nArray == null) {
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = 0;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                if (bitSet.get(n) || bitSet2.get(n)) continue;
                nArray[n] = 0;
            }
        }
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        while (!bl2) {
            ++n4;
            DTMCFromMDPMemorylessAdversary dTMCFromMDPMemorylessAdversary = new DTMCFromMDPMemorylessAdversary(mDP, nArray);
            modelCheckerResult = dTMCModelChecker.computeReachProbsGaussSeidel(dTMCFromMDPMemorylessAdversary, bitSet, bitSet2, dArray, null);
            dArray = modelCheckerResult.soln;
            n3 += modelCheckerResult.numIters;
            mDP.mvMultMinMax(dArray, bl, dArray2, null, false, null);
            bl2 = true;
            for (n = 0; n < n2; ++n) {
                if (bitSet.get(n) || bitSet2.get(n) || PrismUtils.doublesAreClose(dArray[n], dArray2[n], this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE)) continue;
                bl2 = false;
                List<Integer> list = mDP.mvMultMinMaxSingleChoices(n, dArray, bl, dArray2[n]);
                nArray[n] = list.get(0);
            }
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Modified policy iteration");
        this.mainLog.println(" took " + n4 + " cycles (" + n3 + " iterations in total) and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray;
        modelCheckerResult.numIters = n3;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public List<Integer> probReachStrategy(MDP mDP, int n, BitSet bitSet, boolean bl, double[] dArray) throws PrismException {
        double d = mDP.mvMultMinMaxSingle(n, dArray, bl, null);
        return mDP.mvMultMinMaxSingleChoices(n, dArray, bl, d);
    }

    public ModelCheckerResult computeBoundedReachProbs(MDP mDP, BitSet bitSet, int n, boolean bl) throws PrismException {
        return this.computeBoundedReachProbs(mDP, null, bitSet, n, bl, null, null);
    }

    public ModelCheckerResult computeBoundedUntilProbs(MDP mDP, BitSet bitSet, BitSet bitSet2, int n, boolean bl) throws PrismException {
        return this.computeBoundedReachProbs(mDP, bitSet, bitSet2, n, bl, null, null);
    }

    public ModelCheckerResult computeBoundedReachProbs(MDP mDP, BitSet bitSet, BitSet bitSet2, int n, boolean bl, double[] dArray, double[] dArray2) throws PrismException {
        int n2;
        double[] dArray3;
        ModelCheckerResult modelCheckerResult = null;
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting bounded probabilistic reachability (" + (bl ? "min" : "max") + ")...");
        int n3 = mDP.getNumStates();
        double[] dArray4 = new double[n3];
        double[] dArray5 = dArray3 = dArray == null ? new double[n3] : dArray;
        if (dArray != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray3[n2] = bitSet2.get(n2) ? 1.0 : dArray[n2];
                dArray4[n2] = dArray3[n2];
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray3[n2] = bitSet2.get(n2) ? 1.0 : 0.0;
                dArray4[n2] = dArray3[n2];
            }
        }
        if (dArray2 != null) {
            dArray2[0] = Utils.minMaxOverArraySubset(dArray3, mDP.getInitialStates(), true);
        }
        BitSet bitSet3 = new BitSet();
        bitSet3.set(0, n3);
        bitSet3.andNot(bitSet2);
        if (bitSet != null) {
            bitSet3.and(bitSet);
        }
        int n4 = 0;
        while (n4 < n) {
            ++n4;
            mDP.mvMultMinMax(dArray4, bl, dArray3, bitSet3, false, null);
            if (dArray2 != null) {
                dArray2[n4] = Utils.minMaxOverArraySubset(dArray3, mDP.getInitialStates(), true);
            }
            double[] dArray6 = dArray4;
            dArray4 = dArray3;
            dArray3 = dArray6;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Bounded probabilistic reachability (" + (bl ? "min" : "max") + ")");
        this.mainLog.println(" took " + n4 + " iterations and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray4;
        modelCheckerResult.lastSoln = dArray3;
        modelCheckerResult.numIters = n4;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = 0.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeCumulativeRewards(MDP mDP, MDPRewards mDPRewards, int n, boolean bl) throws PrismException {
        int n2;
        ModelCheckerResult modelCheckerResult = null;
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting expected cumulative reward (" + (bl ? "min" : "max") + ")...");
        int n3 = mDP.getNumStates();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray2[i] = 0.0;
            dArray[i] = 0.0;
        }
        for (n2 = 0; n2 < n; ++n2) {
            int[] nArray = new int[n3];
            mDP.mvMultRewMinMax(dArray, mDPRewards, bl, dArray2, null, false, nArray);
            double[] dArray3 = dArray;
            dArray = dArray2;
            dArray2 = dArray3;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Expected cumulative reward (" + (bl ? "min" : "max") + ")");
        this.mainLog.println(" took " + n2 + " iterations and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray;
        modelCheckerResult.numIters = n2;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeReachRewards(MDP mDP, MDPRewards mDPRewards, BitSet bitSet, boolean bl) throws PrismException {
        return this.computeReachRewards(mDP, mDPRewards, bitSet, bl, null, null);
    }

    public ModelCheckerResult computeReachRewards(MDP mDP, MDPRewards mDPRewards, BitSet bitSet, boolean bl, double[] dArray, BitSet bitSet2) throws PrismException {
        int n;
        Object object;
        ModelCheckerResult modelCheckerResult = null;
        int[] nArray = null;
        ProbModelChecker.MDPSolnMethod mDPSolnMethod = this.mdpSolnMethod;
        if (mDPSolnMethod != ProbModelChecker.MDPSolnMethod.VALUE_ITERATION && mDPSolnMethod != ProbModelChecker.MDPSolnMethod.GAUSS_SEIDEL && mDPSolnMethod != ProbModelChecker.MDPSolnMethod.POLICY_ITERATION) {
            mDPSolnMethod = ProbModelChecker.MDPSolnMethod.GAUSS_SEIDEL;
            this.mainLog.printWarning("Switching to MDP solution method \"" + mDPSolnMethod.fullName() + "\"");
        }
        if (mDPSolnMethod == ProbModelChecker.MDPSolnMethod.POLICY_ITERATION && bitSet2 != null) {
            throw new PrismException("Policy iteration methods cannot be passed 'known' values for some states");
        }
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting expected reachability (" + (bl ? "min" : "max") + ")...");
        mDP.checkForDeadlocks(bitSet);
        int n2 = mDP.getNumStates();
        if (dArray != null && bitSet2 != null) {
            object = new BitSet(n2);
            for (n = 0; n < n2; ++n) {
                ((BitSet)object).set(n, bitSet.get(n) || bitSet2.get(n) && dArray[n] == 0.0);
            }
            bitSet = object;
        }
        if (this.genStrat || this.exportAdv || mDPSolnMethod == ProbModelChecker.MDPSolnMethod.POLICY_ITERATION) {
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = bitSet.get(n) ? -2 : -1;
            }
        }
        long l2 = System.currentTimeMillis();
        BitSet bitSet3 = this.prob1(mDP, null, bitSet, !bl, nArray);
        bitSet3.flip(0, n2);
        l2 = System.currentTimeMillis() - l2;
        int n3 = bitSet.cardinality();
        int n4 = bitSet3.cardinality();
        this.mainLog.println("target=" + n3 + ", inf=" + n4 + ", rest=" + (n2 - (n3 + n4)));
        if (this.genStrat || this.exportAdv || mDPSolnMethod == ProbModelChecker.MDPSolnMethod.POLICY_ITERATION) {
            if (bl) {
                n = bitSet3.nextSetBit(0);
                while (n >= 0) {
                    nArray[n] = -2;
                    n = bitSet3.nextSetBit(n + 1);
                }
            } else {
                n = bitSet3.nextSetBit(0);
                while (n >= 0) {
                    int n5 = mDP.getNumChoices(n);
                    for (int i = 0; i < n5; ++i) {
                        if (!mDP.allSuccessorsInSet(n, i, bitSet3)) continue;
                        nArray[n] = i;
                    }
                    n = bitSet3.nextSetBit(n + 1);
                }
            }
        }
        switch (mDPSolnMethod) {
            case VALUE_ITERATION: {
                modelCheckerResult = this.computeReachRewardsValIter(mDP, mDPRewards, bitSet, bitSet3, bl, dArray, bitSet2, nArray);
                break;
            }
            case GAUSS_SEIDEL: {
                modelCheckerResult = this.computeReachRewardsGaussSeidel(mDP, mDPRewards, bitSet, bitSet3, bl, dArray, bitSet2, nArray);
                break;
            }
            case POLICY_ITERATION: {
                modelCheckerResult = this.computeReachRewardsPolIter(mDP, mDPRewards, bitSet, bitSet3, bl, nArray);
                break;
            }
            default: {
                throw new PrismException("Unknown MDP solution method " + mDPSolnMethod.fullName());
            }
        }
        if (this.genStrat) {
            modelCheckerResult.strat = new MDStrategyArray(mDP, nArray);
        }
        if (this.exportAdv) {
            this.restrictStrategyToReachableStates(mDP, nArray);
            object = new PrismFileLog(this.exportAdvFilename);
            new DTMCFromMDPMemorylessAdversary(mDP, nArray).exportToPrismExplicitTra((PrismLog)object);
            ((PrismLog)object).close();
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Expected reachability took " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = (double)l2 / 1000.0;
        return modelCheckerResult;
    }

    protected ModelCheckerResult computeReachRewardsValIter(MDP mDP, MDPRewards mDPRewards, BitSet bitSet, BitSet bitSet2, boolean bl, double[] dArray, BitSet bitSet3, int[] nArray) throws PrismException {
        int n;
        int n2;
        double[] dArray2;
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting value iteration (" + (bl ? "min" : "max") + ")...");
        int n3 = mDP.getNumStates();
        double[] dArray3 = new double[n3];
        double[] dArray4 = dArray2 = dArray == null ? new double[n3] : dArray;
        if (dArray != null) {
            if (bitSet3 != null) {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray2[n2] = bitSet3.get(n2) ? dArray[n2] : (bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : dArray[n2]));
                    dArray3[n2] = dArray2[n2];
                }
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray2[n2] = bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : dArray[n2]);
                    dArray3[n2] = dArray2[n2];
                }
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray2[n2] = bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : 0.0);
                dArray3[n2] = dArray2[n2];
            }
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n3);
        bitSet4.andNot(bitSet);
        bitSet4.andNot(bitSet2);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        boolean bl2 = false;
        for (n = 0; !bl2 && n < this.maxIters; ++n) {
            mDP.mvMultRewMinMax(dArray3, mDPRewards, bl, dArray2, bitSet4, false, nArray);
            bl2 = PrismUtils.doublesAreClose(dArray3, dArray2, this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
            double[] dArray5 = dArray3;
            dArray3 = dArray2;
            dArray2 = dArray5;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Value iteration (" + (bl ? "min" : "max") + ")");
        this.mainLog.println(" took " + n + " iterations and " + (double)l / 1000.0 + " seconds.");
        if (!bl2 && this.errorOnNonConverge) {
            String string = "Iterative method did not converge within " + n + " iterations.";
            string = string + "\nConsider using a different numerical method or increasing the maximum number of iterations";
            throw new PrismException(string);
        }
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray3;
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    protected ModelCheckerResult computeReachRewardsGaussSeidel(MDP mDP, MDPRewards mDPRewards, BitSet bitSet, BitSet bitSet2, boolean bl, double[] dArray, BitSet bitSet3, int[] nArray) throws PrismException {
        int n;
        int n2;
        double[] dArray2;
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting Gauss-Seidel (" + (bl ? "min" : "max") + ")...");
        int n3 = mDP.getNumStates();
        double[] dArray3 = dArray2 = dArray == null ? new double[n3] : dArray;
        if (dArray != null) {
            if (bitSet3 != null) {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray2[n2] = bitSet3.get(n2) ? dArray[n2] : (bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : dArray[n2]));
                }
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray2[n2] = bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : dArray[n2]);
                }
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray2[n2] = bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : 0.0);
            }
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n3);
        bitSet4.andNot(bitSet);
        bitSet4.andNot(bitSet2);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        boolean bl2 = false;
        for (n = 0; !bl2 && n < this.maxIters; ++n) {
            double d = mDP.mvMultRewGSMinMax(dArray2, mDPRewards, bl, bitSet4, false, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE, nArray);
            bl2 = d < this.termCritParam;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Gauss-Seidel (" + (bl ? "min" : "max") + ")");
        this.mainLog.println(" took " + n + " iterations and " + (double)l / 1000.0 + " seconds.");
        if (!bl2 && this.errorOnNonConverge) {
            String string = "Iterative method did not converge within " + n + " iterations.";
            string = string + "\nConsider using a different numerical method or increasing the maximum number of iterations";
            throw new PrismException(string);
        }
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray2;
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    protected ModelCheckerResult computeReachRewardsPolIter(MDP mDP, MDPRewards mDPRewards, BitSet bitSet, BitSet bitSet2, boolean bl, int[] nArray) throws PrismException {
        ModelCheckerResult modelCheckerResult;
        int n;
        boolean bl2 = true;
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting policy iteration (" + (bl ? "min" : "max") + ")...");
        DTMCModelChecker dTMCModelChecker = new DTMCModelChecker(this);
        dTMCModelChecker.inheritSettings(this);
        dTMCModelChecker.setLog(new PrismDevNullLog());
        int n2 = mDP.getNumStates();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray2[n] = bitSet.get(n) ? 0.0 : (bitSet2.get(n) ? Double.POSITIVE_INFINITY : 0.0);
            dArray[n] = dArray2[n];
        }
        if (nArray == null) {
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = 0;
            }
        }
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = false;
        while (!bl3 && n4 < this.maxIters) {
            ++n4;
            DTMCFromMDPMemorylessAdversary dTMCFromMDPMemorylessAdversary = new DTMCFromMDPMemorylessAdversary(mDP, nArray);
            MCRewardsFromMDPRewards mCRewardsFromMDPRewards = new MCRewardsFromMDPRewards(mDPRewards, nArray);
            modelCheckerResult = dTMCModelChecker.computeReachRewardsValIter(dTMCFromMDPMemorylessAdversary, mCRewardsFromMDPRewards, bitSet, bitSet2, (double[])(bl2 ? dArray : null), null);
            dArray = modelCheckerResult.soln;
            n3 += modelCheckerResult.numIters;
            mDP.mvMultRewMinMax(dArray, mDPRewards, bl, dArray2, null, false, null);
            bl3 = true;
            for (n = 0; n < n2; ++n) {
                if (bitSet.get(n) || bitSet2.get(n) || PrismUtils.doublesAreClose(dArray[n], dArray2[n], this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE)) continue;
                bl3 = false;
                List<Integer> list = mDP.mvMultRewMinMaxSingleChoices(n, dArray, mDPRewards, bl, dArray2[n]);
                if (list.contains(nArray[n])) continue;
                nArray[n] = list.get(0);
            }
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Policy iteration");
        this.mainLog.println(" took " + n4 + " cycles (" + n3 + " iterations in total) and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray;
        modelCheckerResult.numIters = n3;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public List<Integer> expReachStrategy(MDP mDP, MDPRewards mDPRewards, int n, BitSet bitSet, boolean bl, double[] dArray) throws PrismException {
        double d = mDP.mvMultRewMinMaxSingle(n, dArray, mDPRewards, bl, null);
        return mDP.mvMultRewMinMaxSingleChoices(n, dArray, mDPRewards, bl, d);
    }

    public void restrictStrategyToReachableStates(MDP mDP, int[] nArray) {
        int n2;
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        for (int n2 : mDP.getInitialStates()) {
            bitSet.set(n2);
            bitSet2.set(n2);
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            n2 = bitSet2.nextSetBit(0);
            while (n2 >= 0) {
                bitSet2.set(n2, false);
                if (nArray[n2] >= 0) {
                    Iterator<Map.Entry<Integer, Double>> iterator = mDP.getTransitionsIterator(n2, nArray[n2]);
                    while (iterator.hasNext()) {
                        Map.Entry<Integer, Double> entry = iterator.next();
                        int n3 = entry.getKey();
                        if (bitSet.get(n3)) continue;
                        bl = true;
                        bitSet.set(n3);
                        bitSet2.set(n3);
                    }
                }
                n2 = bitSet2.nextSetBit(n2 + 1);
            }
        }
        n2 = mDP.getNumStates();
        int n4 = bitSet.nextClearBit(0);
        while (n4 < n2) {
            nArray[n4] = -3;
            n4 = bitSet.nextClearBit(n4 + 1);
        }
    }

    public static void main(String[] stringArray) {
        boolean bl = true;
        try {
            MDPModelChecker mDPModelChecker = new MDPModelChecker(null);
            MDPSimple mDPSimple = new MDPSimple();
            mDPSimple.buildFromPrismExplicit(stringArray[0]);
            Map<String, BitSet> map = mDPModelChecker.loadLabelsFile(stringArray[1]);
            BitSet bitSet = map.get("init");
            BitSet bitSet2 = map.get(stringArray[2]);
            if (bitSet2 == null) {
                throw new PrismException("Unknown label \"" + stringArray[2] + "\"");
            }
            for (int i = 3; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-min")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-max")) {
                    bl = false;
                    continue;
                }
                if (!stringArray[i].equals("-nopre")) continue;
                mDPModelChecker.setPrecomp(false);
            }
            ModelCheckerResult modelCheckerResult = mDPModelChecker.computeReachProbs(mDPSimple, bitSet2, bl);
            System.out.println(modelCheckerResult.soln[bitSet.nextSetBit(0)]);
        }
        catch (PrismException prismException) {
            System.out.println(prismException);
        }
    }
}

