/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.StateStorage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class IndexedSet<T>
implements StateStorage<T> {
    protected Map<T, Integer> set;
    protected int indexOfLastAdd = -1;

    public IndexedSet() {
        this(false);
    }

    public IndexedSet(boolean bl) {
        this.set = bl ? new TreeMap() : new HashMap();
    }

    public IndexedSet(Comparator<T> comparator) {
        this.set = new TreeMap<T, Integer>(comparator);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public boolean add(T t) {
        Integer n = this.set.get(t);
        if (n != null) {
            this.indexOfLastAdd = n;
            return false;
        }
        this.indexOfLastAdd = this.set.size();
        this.set.put(t, this.set.size());
        return true;
    }

    @Override
    public boolean contains(T t) {
        return this.set.get(t) != null;
    }

    @Override
    public int getIndexOfLastAdd() {
        return this.indexOfLastAdd;
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public Set<Map.Entry<T, Integer>> getEntrySet() {
        return this.set.entrySet();
    }

    @Override
    public ArrayList<T> toArrayList() {
        ArrayList arrayList = new ArrayList(this.set.size());
        this.toArrayList(arrayList);
        return arrayList;
    }

    @Override
    public void toArrayList(ArrayList<T> arrayList) {
        int n = this.set.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(null);
        }
        for (Map.Entry<T, Integer> entry : this.set.entrySet()) {
            arrayList.set(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public ArrayList<T> toPermutedArrayList(int[] nArray) {
        ArrayList arrayList = new ArrayList(this.set.size());
        this.toPermutedArrayList(nArray, arrayList);
        return arrayList;
    }

    @Override
    public void toPermutedArrayList(int[] nArray, ArrayList<T> arrayList) {
        int n = this.set.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(null);
        }
        for (Map.Entry<T, Integer> entry : this.set.entrySet()) {
            arrayList.set(nArray[entry.getValue()], entry.getKey());
        }
    }

    @Override
    public int[] buildSortingPermutation() {
        int n = this.set.size();
        int[] nArray = new int[n];
        int n2 = 0;
        for (Map.Entry<T, Integer> entry : this.set.entrySet()) {
            nArray[entry.getValue().intValue()] = n2++;
        }
        return nArray;
    }

    public String toString() {
        return this.set.toString();
    }

    @Override
    public int get(T t) {
        return this.set.get(t);
    }
}

