/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import prism.PrismUtils;

public class Distribution
implements Iterable<Map.Entry<Integer, Double>> {
    private HashMap<Integer, Double> map;

    public Distribution() {
        this.clear();
    }

    public Distribution(Distribution distribution) {
        this();
        for (Map.Entry<Integer, Double> entry : distribution) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public Distribution(Distribution distribution, int[] nArray) {
        this();
        for (Map.Entry<Integer, Double> entry : distribution) {
            this.add(nArray[entry.getKey()], entry.getValue());
        }
    }

    public void clear() {
        this.map = new HashMap();
    }

    public boolean add(int n, double d) {
        Double d2 = this.map.get(n);
        if (d2 == null) {
            this.map.put(n, d);
            return false;
        }
        this.set(n, d2 + d);
        return true;
    }

    public void set(int n, double d) {
        if (d == 0.0) {
            this.map.remove(n);
        } else {
            this.map.put(n, d);
        }
    }

    public double get(int n) {
        Double d = this.map.get(n);
        return d == null ? 0.0 : d;
    }

    public boolean contains(int n) {
        return this.map.get(n) != null;
    }

    public boolean isSubsetOf(BitSet bitSet) {
        for (Map.Entry<Integer, Double> entry : this) {
            if (bitSet.get(entry.getKey())) continue;
            return false;
        }
        return true;
    }

    public boolean containsOneOf(BitSet bitSet) {
        for (Map.Entry<Integer, Double> entry : this) {
            if (!bitSet.get(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    public Set<Integer> getSupport() {
        return this.map.keySet();
    }

    @Override
    public Iterator<Map.Entry<Integer, Double>> iterator() {
        return this.map.entrySet().iterator();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public double sum() {
        double d = 0.0;
        for (Map.Entry<Integer, Double> entry : this) {
            d += entry.getValue().doubleValue();
        }
        return d;
    }

    public double sumAllBut(int n) {
        double d = 0.0;
        for (Map.Entry<Integer, Double> entry : this) {
            if (entry.getKey() == n) continue;
            d += entry.getValue().doubleValue();
        }
        return d;
    }

    public Distribution map(int[] nArray) {
        Distribution distribution = new Distribution();
        for (Map.Entry<Integer, Double> entry : this) {
            distribution.add(nArray[entry.getKey()], entry.getValue());
        }
        return distribution;
    }

    public boolean equals(Object object) {
        Distribution distribution = (Distribution)object;
        if (distribution.size() != this.size()) {
            return false;
        }
        for (Map.Entry<Integer, Double> entry : this) {
            Double d = entry.getValue();
            Double d2 = distribution.map.get(entry.getKey());
            if (d2 != null && PrismUtils.doublesAreClose(d, d2, 1.0E-12, false)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }
}

