/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.CTMCSimple;
import explicit.DTMCExplicit;
import explicit.Distribution;
import explicit.rewards.MCRewards;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import parser.State;
import parser.Values;
import prism.ModelType;
import prism.PrismException;
import prism.PrismNotSupportedException;

public class DTMCUniformisedSimple
extends DTMCExplicit {
    protected CTMCSimple ctmc;
    protected double q;
    protected int numExtraTransitions;

    public DTMCUniformisedSimple(CTMCSimple cTMCSimple, double d) {
        this.ctmc = cTMCSimple;
        this.numStates = cTMCSimple.getNumStates();
        this.q = d;
        this.numExtraTransitions = 0;
        for (int i = 0; i < this.numStates; ++i) {
            if (cTMCSimple.getTransitions(i).get(i) != 0.0 || !(cTMCSimple.getTransitions(i).sumAllBut(i) < d)) continue;
            ++this.numExtraTransitions;
        }
    }

    public DTMCUniformisedSimple(CTMCSimple cTMCSimple) {
        this(cTMCSimple, cTMCSimple.getDefaultUniformisationRate());
    }

    @Override
    public void buildFromPrismExplicit(String string) throws PrismException {
        throw new PrismNotSupportedException("Not supported");
    }

    @Override
    public ModelType getModelType() {
        return ModelType.DTMC;
    }

    @Override
    public int getNumStates() {
        return this.ctmc.getNumStates();
    }

    @Override
    public int getNumInitialStates() {
        return this.ctmc.getNumInitialStates();
    }

    @Override
    public Iterable<Integer> getInitialStates() {
        return this.ctmc.getInitialStates();
    }

    @Override
    public int getFirstInitialState() {
        return this.ctmc.getFirstInitialState();
    }

    @Override
    public boolean isInitialState(int n) {
        return this.ctmc.isInitialState(n);
    }

    @Override
    public boolean isDeadlockState(int n) {
        return this.ctmc.isDeadlockState(n);
    }

    @Override
    public List<State> getStatesList() {
        return this.ctmc.getStatesList();
    }

    @Override
    public Values getConstantValues() {
        return this.ctmc.getConstantValues();
    }

    @Override
    public int getNumTransitions() {
        return this.ctmc.getNumTransitions() + this.numExtraTransitions;
    }

    @Override
    public Iterator<Integer> getSuccessorsIterator(int n) {
        throw new Error("Not yet supported");
    }

    @Override
    public boolean isSuccessor(int n, int n2) {
        throw new Error("Not yet supported");
    }

    @Override
    public boolean allSuccessorsInSet(int n, BitSet bitSet) {
        throw new Error("Not yet supported");
    }

    @Override
    public boolean someSuccessorsInSet(int n, BitSet bitSet) {
        throw new Error("Not yet supported");
    }

    public int getNumChoices(int n) {
        return 1;
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
    }

    @Override
    public void checkForDeadlocks() throws PrismException {
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
    }

    @Override
    public String infoString() {
        String string = "";
        string = string + this.getNumStates() + " states (" + this.getNumInitialStates() + " initial)";
        string = string + ", " + this.getNumTransitions() + " transitions (incl. " + this.numExtraTransitions + " self-loops)";
        return string;
    }

    @Override
    public String infoStringTable() {
        String string = "";
        string = string + "States:      " + this.getNumStates() + " (" + this.getNumInitialStates() + " initial)\n";
        string = string + "Transitions: " + this.getNumTransitions() + "\n";
        return string;
    }

    @Override
    public int getNumTransitions(int n) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public Iterator<Map.Entry<Integer, Double>> getTransitionsIterator(int n) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public void prob0step(BitSet bitSet, BitSet bitSet2, BitSet bitSet3) {
        throw new Error("Not yet supported");
    }

    @Override
    public void prob1step(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4) {
        throw new Error("Not yet supported");
    }

    @Override
    public double mvMultSingle(int n, double[] dArray) {
        Distribution distribution = this.ctmc.getTransitions(n);
        double d = 0.0;
        double d2 = 0.0;
        for (Map.Entry<Integer, Double> entry : distribution) {
            int n2 = entry.getKey();
            double d3 = entry.getValue();
            if (n2 == n) continue;
            d2 += d3;
            d += d3 / this.q * dArray[n2];
        }
        if (d2 < this.q) {
            d += (1.0 - d2 / this.q) * dArray[n];
        }
        return d;
    }

    @Override
    public double mvMultJacSingle(int n, double[] dArray) {
        Distribution distribution = this.ctmc.getTransitions(n);
        double d = 0.0;
        double d2 = 0.0;
        for (Map.Entry<Integer, Double> entry : distribution) {
            int n2 = entry.getKey();
            double d3 = entry.getValue();
            if (n2 == n) continue;
            d2 += d3;
            d += d3 / this.q * dArray[n2];
        }
        return d /= d2 / this.q;
    }

    @Override
    public double mvMultRewSingle(int n, double[] dArray, MCRewards mCRewards) {
        throw new Error("Not yet supported");
    }

    @Override
    public void vmMult(double[] dArray, double[] dArray2) {
        int n;
        for (n = 0; n < this.numStates; ++n) {
            dArray2[n] = 0.0;
        }
        for (int i = 0; i < this.numStates; ++i) {
            Distribution distribution = this.ctmc.getTransitions(i);
            double d = 0.0;
            for (Map.Entry<Integer, Double> entry : distribution) {
                n = entry.getKey();
                double d2 = entry.getValue();
                if (n == i) continue;
                d += d2;
                int n2 = n;
                dArray2[n2] = dArray2[n2] + d2 / this.q * dArray[i];
            }
            int n3 = i;
            dArray2[n3] = dArray2[n3] + (1.0 - d / this.q) * dArray[i];
        }
    }

    public String toString() {
        String string = "";
        string = string + "ctmc: " + this.ctmc;
        string = ", q: " + this.q;
        return string;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof DTMCUniformisedSimple)) {
            return false;
        }
        DTMCUniformisedSimple dTMCUniformisedSimple = (DTMCUniformisedSimple)object;
        if (!this.ctmc.equals(dTMCUniformisedSimple.ctmc)) {
            return false;
        }
        if (this.q != dTMCUniformisedSimple.q) {
            return false;
        }
        return this.numExtraTransitions == dTMCUniformisedSimple.numExtraTransitions;
    }
}

