/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableStateSet;
import explicit.DTMCExplicit;
import explicit.Distribution;
import explicit.ModelSimple;
import explicit.rewards.MCRewards;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import prism.PrismException;

public class DTMCSimple
extends DTMCExplicit
implements ModelSimple {
    protected List<Distribution> trans;
    protected int numTransitions;

    public DTMCSimple() {
        this.initialise(0);
    }

    public DTMCSimple(int n) {
        this.initialise(n);
    }

    public DTMCSimple(DTMCSimple dTMCSimple) {
        this(dTMCSimple.numStates);
        this.copyFrom(dTMCSimple);
        for (int i = 0; i < this.numStates; ++i) {
            this.trans.set(i, new Distribution(dTMCSimple.trans.get(i)));
        }
        this.numTransitions = dTMCSimple.numTransitions;
    }

    public DTMCSimple(DTMCSimple dTMCSimple, int[] nArray) {
        this(dTMCSimple.numStates);
        this.copyFrom(dTMCSimple, nArray);
        for (int i = 0; i < this.numStates; ++i) {
            this.trans.set(nArray[i], new Distribution(dTMCSimple.trans.get(i), nArray));
        }
        this.numTransitions = dTMCSimple.numTransitions;
    }

    @Override
    public void initialise(int n) {
        super.initialise(n);
        this.trans = new ArrayList<Distribution>(n);
        for (int i = 0; i < n; ++i) {
            this.trans.add(new Distribution());
        }
    }

    @Override
    public void clearState(int n) {
        if (n >= this.numStates || n < 0) {
            return;
        }
        this.numTransitions -= this.trans.get(n).size();
        this.trans.get(n).clear();
    }

    @Override
    public int addState() {
        this.addStates(1);
        return this.numStates - 1;
    }

    @Override
    public void addStates(int n) {
        for (int i = 0; i < n; ++i) {
            this.trans.add(new Distribution());
            ++this.numStates;
        }
    }

    @Override
    public void buildFromPrismExplicit(String string) throws PrismException {
        int n = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
            String string2 = bufferedReader.readLine();
            n = 1;
            if (string2 == null) {
                bufferedReader.close();
                throw new PrismException("Missing first line of .tra file");
            }
            String[] stringArray = string2.split(" ");
            int n2 = Integer.parseInt(stringArray[0]);
            this.initialise(n2);
            string2 = bufferedReader.readLine();
            ++n;
            while (string2 != null) {
                if ((string2 = string2.trim()).length() > 0) {
                    stringArray = string2.split(" ");
                    int n3 = Integer.parseInt(stringArray[0]);
                    int n4 = Integer.parseInt(stringArray[1]);
                    double d = Double.parseDouble(stringArray[2]);
                    this.setProbability(n3, n4, d);
                }
                string2 = bufferedReader.readLine();
                ++n;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            System.exit(1);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Problem in .tra file (line " + n + ") for " + (Object)((Object)this.getModelType()));
        }
        this.initialStates.add(0);
    }

    public void setProbability(int n, int n2, double d) {
        Distribution distribution = this.trans.get(n);
        if (distribution.get(n2) != 0.0) {
            --this.numTransitions;
        }
        if (d != 0.0) {
            ++this.numTransitions;
        }
        distribution.set(n2, d);
    }

    public void addToProbability(int n, int n2, double d) {
        if (!this.trans.get(n).add(n2, d) && d != 0.0) {
            ++this.numTransitions;
        }
    }

    @Override
    public int getNumTransitions() {
        return this.numTransitions;
    }

    @Override
    public Iterator<Integer> getSuccessorsIterator(int n) {
        return this.trans.get(n).getSupport().iterator();
    }

    @Override
    public boolean isSuccessor(int n, int n2) {
        return this.trans.get(n).contains(n2);
    }

    @Override
    public boolean allSuccessorsInSet(int n, BitSet bitSet) {
        return this.trans.get(n).isSubsetOf(bitSet);
    }

    @Override
    public boolean someSuccessorsInSet(int n, BitSet bitSet) {
        return this.trans.get(n).containsOneOf(bitSet);
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
        for (int i = 0; i < this.numStates; ++i) {
            if (!this.trans.get(i).isEmpty()) continue;
            this.addDeadlockState(i);
            if (!bl) continue;
            this.setProbability(i, i, 1.0);
        }
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
        for (int i = 0; i < this.numStates; ++i) {
            if (!this.trans.get(i).isEmpty() || bitSet != null && bitSet.get(i)) continue;
            throw new PrismException("DTMC has a deadlock in state " + i);
        }
    }

    @Override
    public int getNumTransitions(int n) {
        return this.trans.get(n).size();
    }

    @Override
    public Iterator<Map.Entry<Integer, Double>> getTransitionsIterator(int n) {
        return this.trans.get(n).iterator();
    }

    @Override
    public void prob0step(BitSet bitSet, BitSet bitSet2, BitSet bitSet3) {
        for (int n : new IterableStateSet(bitSet, this.numStates)) {
            Distribution distribution = this.trans.get(n);
            bitSet3.set(n, distribution.containsOneOf(bitSet2));
        }
    }

    @Override
    public void prob1step(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4) {
        Iterator<Integer> iterator = new IterableStateSet(bitSet, this.numStates).iterator();
        while (iterator.hasNext()) {
            int n;
            Distribution distribution = this.trans.get(n = iterator.next().intValue());
            bitSet4.set(n, distribution.containsOneOf(bitSet3) && distribution.isSubsetOf(bitSet2));
        }
    }

    @Override
    public double mvMultSingle(int n, double[] dArray) {
        Distribution distribution = this.trans.get(n);
        double d = 0.0;
        for (Map.Entry<Integer, Double> entry : distribution) {
            int n2 = entry.getKey();
            double d2 = entry.getValue();
            d += d2 * dArray[n2];
        }
        return d;
    }

    @Override
    public double mvMultJacSingle(int n, double[] dArray) {
        Distribution distribution = this.trans.get(n);
        double d = 1.0;
        double d2 = 0.0;
        for (Map.Entry<Integer, Double> entry : distribution) {
            int n2 = entry.getKey();
            double d3 = entry.getValue();
            if (n2 != n) {
                d2 += d3 * dArray[n2];
                continue;
            }
            d -= d3;
        }
        if (d > 0.0) {
            d2 /= d;
        }
        return d2;
    }

    @Override
    public double mvMultRewSingle(int n, double[] dArray, MCRewards mCRewards) {
        Distribution distribution = this.trans.get(n);
        double d = mCRewards.getStateReward(n);
        for (Map.Entry<Integer, Double> entry : distribution) {
            int n2 = entry.getKey();
            double d2 = entry.getValue();
            d += d2 * dArray[n2];
        }
        return d;
    }

    @Override
    public void vmMult(double[] dArray, double[] dArray2) {
        int n;
        for (n = 0; n < this.numStates; ++n) {
            dArray2[n] = 0.0;
        }
        for (int i = 0; i < this.numStates; ++i) {
            Distribution distribution = this.trans.get(i);
            for (Map.Entry<Integer, Double> entry : distribution) {
                n = entry.getKey();
                double d = entry.getValue();
                int n2 = n;
                dArray2[n2] = dArray2[n2] + d * dArray[i];
            }
        }
    }

    public Distribution getTransitions(int n) {
        return this.trans.get(n);
    }

    public String toString() {
        String string = "";
        boolean bl = true;
        string = "trans: [ ";
        for (int i = 0; i < this.numStates; ++i) {
            if (bl) {
                bl = false;
            } else {
                string = string + ", ";
            }
            string = string + i + ": " + this.trans.get(i);
        }
        string = string + " ]";
        return string;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof DTMCSimple)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DTMCSimple dTMCSimple = (DTMCSimple)object;
        if (!this.trans.equals(dTMCSimple.trans)) {
            return false;
        }
        return this.numTransitions == dTMCSimple.numTransitions;
    }
}

