/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import acceptance.AcceptanceReach;
import acceptance.AcceptanceType;
import explicit.DTMC;
import explicit.DTMCSimple;
import explicit.LTLModelChecker;
import explicit.MinMax;
import explicit.Model;
import explicit.ModelCheckerResult;
import explicit.PredecessorRelation;
import explicit.ProbModelChecker;
import explicit.SCCComputer;
import explicit.StateValues;
import explicit.Utils;
import explicit.rewards.MCRewards;
import java.io.File;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import parser.VarList;
import parser.ast.Declaration;
import parser.ast.DeclarationIntUnbounded;
import parser.ast.Expression;
import parser.type.Type;
import parser.type.TypeDouble;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import prism.PrismUtils;

public class DTMCModelChecker
extends ProbModelChecker {
    public DTMCModelChecker(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    @Override
    protected StateValues checkProbPathFormulaLTL(Model model, Expression expression, boolean bl, MinMax minMax, BitSet bitSet) throws PrismException {
        Object object;
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this);
        AcceptanceType[] acceptanceTypeArray = new AcceptanceType[]{AcceptanceType.RABIN, AcceptanceType.REACH, AcceptanceType.GENERIC};
        LTLModelChecker.LTLProduct<DTMC> lTLProduct = lTLModelChecker.constructProductMC(this, (DTMC)model, expression, bitSet, acceptanceTypeArray);
        if (this.getExportProductTrans()) {
            this.mainLog.println("\nExporting product transition matrix to file \"" + this.getExportProductTransFilename() + "\"...");
            ((DTMC)lTLProduct.getProductModel()).exportToPrismExplicitTra(this.getExportProductTransFilename());
        }
        if (this.getExportProductStates()) {
            this.mainLog.println("\nExporting product state space to file \"" + this.getExportProductStatesFilename() + "\"...");
            object = new PrismFileLog(this.getExportProductStatesFilename());
            VarList varList = (VarList)this.modulesFile.createVarList().clone();
            String string = "_da";
            while (varList.getIndex(string) != -1) {
                string = "_" + string;
            }
            varList.addVar(0, new Declaration(string, new DeclarationIntUnbounded()), 1, null);
            ((DTMC)lTLProduct.getProductModel()).exportStates(1, varList, (PrismLog)object);
            ((PrismFileLog)object).close();
        }
        if (lTLProduct.getAcceptance() instanceof AcceptanceReach) {
            this.mainLog.println("\nSkipping BSCC computation since acceptance is defined via goal states...");
            object = ((AcceptanceReach)lTLProduct.getAcceptance()).getGoalStates();
        } else {
            this.mainLog.println("\nFinding accepting BSCCs...");
            object = lTLModelChecker.findAcceptingBSCCs((Model)lTLProduct.getProductModel(), lTLProduct.getAcceptance());
        }
        this.mainLog.println("\nComputing reachability probabilities...");
        DTMCModelChecker dTMCModelChecker = new DTMCModelChecker(this);
        dTMCModelChecker.inheritSettings(this);
        StateValues stateValues = StateValues.createFromDoubleArray(dTMCModelChecker.computeReachProbs((DTMC)((DTMC)lTLProduct.getProductModel()), (BitSet)object).soln, lTLProduct.getProductModel());
        StateValues stateValues2 = lTLProduct.projectToOriginalModel(stateValues);
        stateValues.clear();
        return stateValues2;
    }

    public ModelCheckerResult computeInstantaneousRewards(DTMC dTMC, MCRewards mCRewards, double d) throws PrismException {
        int n;
        ModelCheckerResult modelCheckerResult = null;
        int n2 = (int)d;
        int n3 = dTMC.getNumStates();
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting backwards instantaneous rewards computation...");
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray[i] = mCRewards.getStateReward(i);
        }
        for (n = 0; n < n2; ++n) {
            dTMC.mvMult(dArray, dArray2, null, false);
            double[] dArray3 = dArray;
            dArray = dArray2;
            dArray2 = dArray3;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Backwards transient instantaneous rewards computation");
        this.mainLog.println(" took " + n + " iters and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray;
        modelCheckerResult.lastSoln = dArray2;
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = 0.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeCumulativeRewards(DTMC dTMC, MCRewards mCRewards, double d) throws PrismException {
        int n;
        ModelCheckerResult modelCheckerResult = null;
        int n2 = (int)d;
        int n3 = dTMC.getNumStates();
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting backwards cumulative rewards computation...");
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (n = 0; n < n2; ++n) {
            dTMC.mvMult(dArray, dArray2, null, false);
            for (int i = 0; i < n3; ++i) {
                int n4 = i;
                dArray2[n4] = dArray2[n4] + mCRewards.getStateReward(i);
            }
            double[] dArray3 = dArray;
            dArray = dArray2;
            dArray2 = dArray3;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Backwards cumulative rewards computation");
        this.mainLog.println(" took " + n + " iters and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray;
        modelCheckerResult.lastSoln = dArray2;
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = 0.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeTotalRewards(DTMC dTMC, MCRewards mCRewards) throws PrismException {
        ModelCheckerResult modelCheckerResult = null;
        int n = 0;
        if (this.linEqMethod != ProbModelChecker.LinEqMethod.POWER) {
            this.linEqMethod = ProbModelChecker.LinEqMethod.POWER;
            this.mainLog.printWarning("Switching to linear equation solution method \"" + this.linEqMethod.fullName() + "\"");
        }
        int n2 = dTMC.getNumStates();
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting total reward computation...");
        SCCComputer sCCComputer = SCCComputer.createSCCComputer(this, dTMC);
        sCCComputer.computeBSCCs();
        List<BitSet> list = sCCComputer.getBSCCs();
        n = list.size();
        BitSet bitSet = new BitSet();
        block3: for (int i = 0; i < n; ++i) {
            BitSet bitSet2 = list.get(i);
            int n3 = bitSet2.nextSetBit(0);
            while (n3 >= 0) {
                if (mCRewards.getStateReward(n3) > 0.0) {
                    bitSet.or(bitSet2);
                    continue block3;
                }
                n3 = bitSet2.nextSetBit(n3 + 1);
            }
        }
        this.mainLog.print("States in non-zero reward BSCCs: " + bitSet.cardinality());
        BitSet bitSet3 = this.prob0(dTMC, null, bitSet);
        bitSet3.flip(0, n2);
        int n4 = bitSet3.cardinality();
        this.mainLog.println(", inf=" + n4 + ", maybe=" + (n2 - n4));
        switch (this.linEqMethod) {
            case POWER: {
                modelCheckerResult = this.computeReachRewardsValIter(dTMC, mCRewards, new BitSet(), bitSet3, null, null);
                break;
            }
            default: {
                throw new PrismException("Unknown linear equation solution method " + this.linEqMethod.fullName());
            }
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Total reward computation");
        this.mainLog.println(" took " + (double)l / 1000.0 + " seconds.");
        return modelCheckerResult;
    }

    public StateValues doSteadyState(DTMC dTMC) throws PrismException {
        return this.doSteadyState(dTMC, (StateValues)null);
    }

    public StateValues doSteadyState(DTMC dTMC, File file) throws PrismException {
        StateValues stateValues = this.readDistributionFromFile(file, dTMC);
        return this.doSteadyState(dTMC, stateValues);
    }

    public StateValues doSteadyState(DTMC dTMC, StateValues stateValues) throws PrismException {
        StateValues stateValues2 = stateValues == null ? this.buildInitialDistribution(dTMC) : stateValues;
        ModelCheckerResult modelCheckerResult = this.computeSteadyStateProbs(dTMC, stateValues2.getDoubleArray());
        return StateValues.createFromDoubleArray(modelCheckerResult.soln, dTMC);
    }

    public StateValues doTransient(DTMC dTMC, int n, double[] dArray) throws PrismException {
        throw new PrismNotSupportedException("Not implemented yet");
    }

    public StateValues readDistributionFromFile(File file, Model model) throws PrismException {
        StateValues stateValues = null;
        if (file != null) {
            this.mainLog.println("\nImporting probability distribution from file \"" + file + "\"...");
            stateValues = new StateValues((Type)TypeDouble.getInstance(), model);
            stateValues.readFromFile(file);
        }
        return stateValues;
    }

    public StateValues buildInitialDistribution(Model model) throws PrismException {
        StateValues stateValues = null;
        stateValues = new StateValues((Type)TypeDouble.getInstance(), model);
        double d = 1.0 / (double)model.getNumInitialStates();
        for (int n : model.getInitialStates()) {
            stateValues.setDoubleValue(n, d);
        }
        return stateValues;
    }

    public ModelCheckerResult computeNextProbs(DTMC dTMC, BitSet bitSet) throws PrismException {
        ModelCheckerResult modelCheckerResult = null;
        long l = System.currentTimeMillis();
        int n = dTMC.getNumStates();
        double[] dArray = Utils.bitsetToDoubleArray(bitSet, n);
        double[] dArray2 = new double[n];
        dTMC.mvMult(dArray, dArray2, null, false);
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray2;
        modelCheckerResult.numIters = 1;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    protected double[] computeRestrictedNext(DTMC dTMC, BitSet bitSet, double[] dArray) {
        int n = dTMC.getNumStates();
        double[] dArray2 = new double[n];
        dTMC.mvMult(dArray, dArray2, bitSet, false);
        return dArray2;
    }

    public ModelCheckerResult computeReachProbs(DTMC dTMC, BitSet bitSet) throws PrismException {
        return this.computeReachProbs(dTMC, null, bitSet, null, null);
    }

    public ModelCheckerResult computeUntilProbs(DTMC dTMC, BitSet bitSet, BitSet bitSet2) throws PrismException {
        return this.computeReachProbs(dTMC, bitSet, bitSet2, null, null);
    }

    public ModelCheckerResult computeReachProbs(DTMC dTMC, BitSet bitSet, BitSet bitSet2, double[] dArray, BitSet bitSet3) throws PrismException {
        int n;
        BitSet bitSet4;
        ModelCheckerResult modelCheckerResult = null;
        PredecessorRelation predecessorRelation = null;
        ProbModelChecker.LinEqMethod linEqMethod = this.linEqMethod;
        if (linEqMethod != ProbModelChecker.LinEqMethod.POWER && linEqMethod != ProbModelChecker.LinEqMethod.GAUSS_SEIDEL) {
            linEqMethod = ProbModelChecker.LinEqMethod.GAUSS_SEIDEL;
            this.mainLog.printWarning("Switching to linear equation solution method \"" + linEqMethod.fullName() + "\"");
        }
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting probabilistic reachability...");
        dTMC.checkForDeadlocks(bitSet2);
        int n2 = dTMC.getNumStates();
        if (dArray != null && bitSet3 != null) {
            bitSet4 = new BitSet(n2);
            for (n = 0; n < n2; ++n) {
                bitSet4.set(n, bitSet2.get(n) || bitSet3.get(n) && dArray[n] == 1.0);
            }
            bitSet2 = bitSet4;
        }
        if (this.getExportTarget()) {
            bitSet4 = new BitSet(n2);
            for (n = 0; n < n2; ++n) {
                bitSet4.set(n, dTMC.isInitialState(n));
            }
            List<BitSet> list = Arrays.asList(bitSet4, bitSet2);
            List<String> list2 = Arrays.asList("init", "target");
            this.mainLog.println("\nExporting target states info to file \"" + this.getExportTargetFilename() + "\"...");
            this.exportLabels(dTMC, list, list2, 1, new PrismFileLog(this.getExportTargetFilename()));
        }
        if (this.precomp && (this.prob0 || this.prob1) && this.preRel) {
            predecessorRelation = dTMC.getPredecessorRelation(this, true);
        }
        long l2 = System.currentTimeMillis();
        BitSet bitSet5 = this.precomp && this.prob0 ? (this.preRel ? this.prob0(dTMC, bitSet, bitSet2, predecessorRelation) : this.prob0(dTMC, bitSet, bitSet2)) : new BitSet();
        l2 = System.currentTimeMillis() - l2;
        long l3 = System.currentTimeMillis();
        BitSet bitSet6 = this.precomp && this.prob1 ? (this.preRel ? this.prob1(dTMC, bitSet, bitSet2, predecessorRelation) : this.prob1(dTMC, bitSet, bitSet2)) : (BitSet)bitSet2.clone();
        l3 = System.currentTimeMillis() - l3;
        int n3 = bitSet6.cardinality();
        int n4 = bitSet5.cardinality();
        this.mainLog.println("target=" + bitSet2.cardinality() + ", yes=" + n3 + ", no=" + n4 + ", maybe=" + (n2 - (n3 + n4)));
        switch (linEqMethod) {
            case POWER: {
                modelCheckerResult = this.computeReachProbsValIter(dTMC, bitSet5, bitSet6, dArray, bitSet3);
                break;
            }
            case GAUSS_SEIDEL: {
                modelCheckerResult = this.computeReachProbsGaussSeidel(dTMC, bitSet5, bitSet6, dArray, bitSet3);
                break;
            }
            default: {
                throw new PrismException("Unknown linear equation solution method " + linEqMethod.fullName());
            }
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Probabilistic reachability took " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timeProb0 = (double)l2 / 1000.0;
        modelCheckerResult.timePre = (double)(l2 + l3) / 1000.0;
        return modelCheckerResult;
    }

    public BitSet prob0(DTMC dTMC, BitSet bitSet, BitSet bitSet2, PredecessorRelation predecessorRelation) {
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting Prob0...");
        if (bitSet2.isEmpty()) {
            BitSet bitSet3 = new BitSet(dTMC.getNumStates());
            bitSet3.set(0, dTMC.getNumStates());
            return bitSet3;
        }
        BitSet bitSet4 = predecessorRelation.calculatePreStar(bitSet, bitSet2, bitSet2);
        BitSet bitSet5 = new BitSet();
        bitSet5.set(0, dTMC.getNumStates(), true);
        bitSet5.andNot(bitSet4);
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Prob0");
        this.mainLog.println(" took " + (double)l / 1000.0 + " seconds.");
        return bitSet5;
    }

    public BitSet prob0(DTMC dTMC, BitSet bitSet, BitSet bitSet2) {
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting Prob0...");
        if (bitSet2.cardinality() == 0) {
            BitSet bitSet3 = new BitSet(dTMC.getNumStates());
            bitSet3.set(0, dTMC.getNumStates());
            return bitSet3;
        }
        int n = dTMC.getNumStates();
        BitSet bitSet4 = new BitSet(n);
        BitSet bitSet5 = new BitSet(n);
        BitSet bitSet6 = new BitSet();
        bitSet6.set(0, n);
        bitSet6.andNot(bitSet2);
        if (bitSet != null) {
            bitSet6.and(bitSet);
        }
        int n2 = 0;
        boolean bl = false;
        bitSet4.or(bitSet2);
        bitSet5.or(bitSet2);
        while (!bl) {
            ++n2;
            dTMC.prob0step(bitSet6, bitSet4, bitSet5);
            bl = bitSet5.equals(bitSet4);
            bitSet4.clear();
            bitSet4.or(bitSet5);
        }
        bitSet4.flip(0, n);
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Prob0");
        this.mainLog.println(" took " + n2 + " iterations and " + (double)l / 1000.0 + " seconds.");
        return bitSet4;
    }

    public BitSet prob1(DTMC dTMC, BitSet bitSet, BitSet bitSet2, PredecessorRelation predecessorRelation) {
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting Prob1...");
        if (bitSet2.isEmpty()) {
            return new BitSet();
        }
        BitSet bitSet3 = new BitSet();
        if (bitSet != null) {
            bitSet3.set(0, dTMC.getNumStates(), true);
            bitSet3.andNot(bitSet);
        }
        bitSet3.or(bitSet2);
        BitSet bitSet4 = predecessorRelation.calculatePreStar(null, bitSet2, bitSet3);
        BitSet bitSet5 = new BitSet();
        bitSet5.set(0, dTMC.getNumStates(), true);
        bitSet5.andNot(bitSet4);
        BitSet bitSet6 = predecessorRelation.calculatePreStar(null, bitSet5, bitSet3);
        BitSet bitSet7 = new BitSet();
        bitSet7.set(0, dTMC.getNumStates(), true);
        bitSet7.andNot(bitSet6);
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Prob1");
        this.mainLog.println(" took " + (double)l / 1000.0 + " seconds.");
        return bitSet7;
    }

    public BitSet prob1(DTMC dTMC, BitSet bitSet, BitSet bitSet2) {
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting Prob1...");
        if (bitSet2.cardinality() == 0) {
            return new BitSet(dTMC.getNumStates());
        }
        int n = dTMC.getNumStates();
        BitSet bitSet3 = new BitSet(n);
        BitSet bitSet4 = new BitSet(n);
        BitSet bitSet5 = new BitSet(n);
        BitSet bitSet6 = new BitSet();
        bitSet6.set(0, n);
        bitSet6.andNot(bitSet2);
        if (bitSet != null) {
            bitSet6.and(bitSet);
        }
        int n2 = 0;
        boolean bl = false;
        bitSet3.set(0, n);
        while (!bl) {
            boolean bl2 = false;
            bitSet4.clear();
            bitSet4.or(bitSet2);
            bitSet5.clear();
            bitSet5.or(bitSet2);
            while (!bl2) {
                ++n2;
                dTMC.prob1step(bitSet6, bitSet3, bitSet4, bitSet5);
                bl2 = bitSet5.equals(bitSet4);
                bitSet4.clear();
                bitSet4.or(bitSet5);
            }
            bl = bitSet4.equals(bitSet3);
            bitSet3.clear();
            bitSet3.or(bitSet4);
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Prob1");
        this.mainLog.println(" took " + n2 + " iterations and " + (double)l / 1000.0 + " seconds.");
        return bitSet3;
    }

    protected ModelCheckerResult computeReachProbsValIter(DTMC dTMC, BitSet bitSet, BitSet bitSet2, double[] dArray, BitSet bitSet3) throws PrismException {
        int n;
        int n2;
        double d;
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting value iteration...");
        int n3 = dTMC.getNumStates();
        double[] dArray2 = new double[n3];
        double[] dArray3 = dArray == null ? new double[n3] : dArray;
        double d2 = d = this.valIterDir == ProbModelChecker.ValIterDir.BELOW ? 0.0 : 1.0;
        if (dArray != null) {
            if (bitSet3 != null) {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray3[n2] = bitSet3.get(n2) ? dArray[n2] : (bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : dArray[n2]));
                    dArray2[n2] = dArray3[n2];
                }
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray3[n2] = bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : dArray[n2]);
                    dArray2[n2] = dArray3[n2];
                }
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray3[n2] = bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : d);
                dArray2[n2] = dArray3[n2];
            }
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n3);
        bitSet4.andNot(bitSet2);
        bitSet4.andNot(bitSet);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        boolean bl = false;
        for (n = 0; !bl && n < this.maxIters; ++n) {
            dTMC.mvMult(dArray2, dArray3, bitSet4, false);
            bl = PrismUtils.doublesAreClose(dArray2, dArray3, this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
            double[] dArray4 = dArray2;
            dArray2 = dArray3;
            dArray3 = dArray4;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Value iteration");
        this.mainLog.println(" took " + n + " iterations and " + (double)l / 1000.0 + " seconds.");
        if (!bl && this.errorOnNonConverge) {
            String string = "Iterative method did not converge within " + n + " iterations.";
            string = string + "\nConsider using a different numerical method or increasing the maximum number of iterations";
            throw new PrismException(string);
        }
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray2;
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    protected ModelCheckerResult computeReachProbsGaussSeidel(DTMC dTMC, BitSet bitSet, BitSet bitSet2, double[] dArray, BitSet bitSet3) throws PrismException {
        int n;
        int n2;
        double d;
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting Gauss-Seidel...");
        int n3 = dTMC.getNumStates();
        double[] dArray2 = dArray == null ? new double[n3] : dArray;
        double d2 = d = this.valIterDir == ProbModelChecker.ValIterDir.BELOW ? 0.0 : 1.0;
        if (dArray != null) {
            if (bitSet3 != null) {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray2[n2] = bitSet3.get(n2) ? dArray[n2] : (bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : dArray[n2]));
                }
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray2[n2] = bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : dArray[n2]);
                }
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray2[n2] = bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : d);
            }
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n3);
        bitSet4.andNot(bitSet2);
        bitSet4.andNot(bitSet);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        boolean bl = false;
        for (n = 0; !bl && n < this.maxIters; ++n) {
            double d3 = dTMC.mvMultGS(dArray2, bitSet4, false, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
            bl = d3 < this.termCritParam;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Gauss-Seidel");
        this.mainLog.println(" took " + n + " iterations and " + (double)l / 1000.0 + " seconds.");
        if (!bl && this.errorOnNonConverge) {
            String string = "Iterative method did not converge within " + n + " iterations.";
            string = string + "\nConsider using a different numerical method or increasing the maximum number of iterations";
            throw new PrismException(string);
        }
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray2;
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeBoundedReachProbs(DTMC dTMC, BitSet bitSet, int n) throws PrismException {
        return this.computeBoundedReachProbs(dTMC, null, bitSet, n, null, null);
    }

    public ModelCheckerResult computeBoundedUntilProbs(DTMC dTMC, BitSet bitSet, BitSet bitSet2, int n) throws PrismException {
        return this.computeBoundedReachProbs(dTMC, bitSet, bitSet2, n, null, null);
    }

    public ModelCheckerResult computeBoundedReachProbs(DTMC dTMC, BitSet bitSet, BitSet bitSet2, int n, double[] dArray, double[] dArray2) throws PrismException {
        int n2;
        double[] dArray3;
        ModelCheckerResult modelCheckerResult = null;
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting bounded probabilistic reachability...");
        int n3 = dTMC.getNumStates();
        double[] dArray4 = new double[n3];
        double[] dArray5 = dArray3 = dArray == null ? new double[n3] : dArray;
        if (dArray != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray3[n2] = bitSet2.get(n2) ? 1.0 : dArray[n2];
                dArray4[n2] = dArray3[n2];
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray3[n2] = bitSet2.get(n2) ? 1.0 : 0.0;
                dArray4[n2] = dArray3[n2];
            }
        }
        if (dArray2 != null) {
            dArray2[0] = Utils.minMaxOverArraySubset(dArray3, dTMC.getInitialStates(), true);
        }
        BitSet bitSet3 = new BitSet();
        bitSet3.set(0, n3);
        bitSet3.andNot(bitSet2);
        if (bitSet != null) {
            bitSet3.and(bitSet);
        }
        int n4 = 0;
        while (n4 < n) {
            ++n4;
            dTMC.mvMult(dArray4, dArray3, bitSet3, false);
            if (dArray2 != null) {
                dArray2[n4] = Utils.minMaxOverArraySubset(dArray3, dTMC.getInitialStates(), true);
            }
            double[] dArray6 = dArray4;
            dArray4 = dArray3;
            dArray3 = dArray6;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Bounded probabilistic reachability");
        this.mainLog.println(" took " + n4 + " iterations and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray4;
        modelCheckerResult.lastSoln = dArray3;
        modelCheckerResult.numIters = n4;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = 0.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeReachRewards(DTMC dTMC, MCRewards mCRewards, BitSet bitSet) throws PrismException {
        return this.computeReachRewards(dTMC, mCRewards, bitSet, null, null);
    }

    public ModelCheckerResult computeReachRewards(DTMC dTMC, MCRewards mCRewards, BitSet bitSet, double[] dArray, BitSet bitSet2) throws PrismException {
        ModelCheckerResult modelCheckerResult = null;
        ProbModelChecker.LinEqMethod linEqMethod = this.linEqMethod;
        if (linEqMethod != ProbModelChecker.LinEqMethod.POWER) {
            linEqMethod = ProbModelChecker.LinEqMethod.POWER;
            this.mainLog.printWarning("Switching to linear equation solution method \"" + linEqMethod.fullName() + "\"");
        }
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting expected reachability...");
        dTMC.checkForDeadlocks(bitSet);
        int n = dTMC.getNumStates();
        if (dArray != null && bitSet2 != null) {
            BitSet bitSet3 = new BitSet(n);
            for (int i = 0; i < n; ++i) {
                bitSet3.set(i, bitSet.get(i) || bitSet2.get(i) && dArray[i] == 0.0);
            }
            bitSet = bitSet3;
        }
        long l2 = System.currentTimeMillis();
        BitSet bitSet4 = this.prob1(dTMC, null, bitSet);
        bitSet4.flip(0, n);
        l2 = System.currentTimeMillis() - l2;
        int n2 = bitSet.cardinality();
        int n3 = bitSet4.cardinality();
        this.mainLog.println("target=" + n2 + ", inf=" + n3 + ", rest=" + (n - (n2 + n3)));
        switch (linEqMethod) {
            case POWER: {
                modelCheckerResult = this.computeReachRewardsValIter(dTMC, mCRewards, bitSet, bitSet4, dArray, bitSet2);
                break;
            }
            default: {
                throw new PrismException("Unknown linear equation solution method " + linEqMethod.fullName());
            }
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Expected reachability took " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = (double)l2 / 1000.0;
        return modelCheckerResult;
    }

    protected ModelCheckerResult computeReachRewardsValIter(DTMC dTMC, MCRewards mCRewards, BitSet bitSet, BitSet bitSet2, double[] dArray, BitSet bitSet3) throws PrismException {
        int n;
        int n2;
        double[] dArray2;
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting value iteration...");
        int n3 = dTMC.getNumStates();
        double[] dArray3 = new double[n3];
        double[] dArray4 = dArray2 = dArray == null ? new double[n3] : dArray;
        if (dArray != null) {
            if (bitSet3 != null) {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray2[n2] = bitSet3.get(n2) ? dArray[n2] : (bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : dArray[n2]));
                    dArray3[n2] = dArray2[n2];
                }
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray2[n2] = bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : dArray[n2]);
                    dArray3[n2] = dArray2[n2];
                }
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray2[n2] = bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : 0.0);
                dArray3[n2] = dArray2[n2];
            }
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n3);
        bitSet4.andNot(bitSet);
        bitSet4.andNot(bitSet2);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        boolean bl = false;
        for (n = 0; !bl && n < this.maxIters; ++n) {
            dTMC.mvMultRew(dArray3, mCRewards, dArray2, bitSet4, false);
            bl = PrismUtils.doublesAreClose(dArray3, dArray2, this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
            double[] dArray5 = dArray3;
            dArray3 = dArray2;
            dArray2 = dArray5;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Value iteration");
        this.mainLog.println(" took " + n + " iterations and " + (double)l / 1000.0 + " seconds.");
        if (!bl && this.errorOnNonConverge) {
            String string = "Iterative method did not converge within " + n + " iterations.";
            string = string + "\nConsider using a different numerical method or increasing the maximum number of iterations";
            throw new PrismException(string);
        }
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray3;
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeSteadyStateProbs(DTMC dTMC, double[] dArray) throws PrismException {
        int n;
        int n2 = 0;
        long l = System.currentTimeMillis();
        int n3 = dTMC.getNumStates();
        double[] dArray2 = new double[n3];
        SCCComputer sCCComputer = SCCComputer.createSCCComputer(this, dTMC);
        sCCComputer.computeBSCCs();
        List<BitSet> list = sCCComputer.getBSCCs();
        BitSet bitSet = sCCComputer.getNotInBSCCs();
        n2 = list.size();
        BitSet bitSet2 = new BitSet();
        for (n = 0; n < n3; ++n) {
            if (dArray[n] != 0.0) continue;
            bitSet2.set(n);
        }
        int n4 = -1;
        for (n = 0; n < n2; ++n) {
            if (list.get(n).intersects(bitSet2)) continue;
            n4 = n;
            break;
        }
        if (n4 != -1) {
            this.mainLog.println("\nInitial states all in one BSCC (so no reachability probabilities computed)");
            BitSet bitSet3 = list.get(n4);
            this.computeSteadyStateProbsForBSCC(dTMC, bitSet3, dArray2);
        } else {
            int n5;
            BitSet bitSet4;
            double[] dArray3 = new double[n2];
            for (n = 0; n < n2; ++n) {
                this.mainLog.println("\nComputing probability of reaching BSCC " + (n + 1));
                bitSet4 = list.get(n);
                double[] dArray4 = this.computeUntilProbs((DTMC)dTMC, (BitSet)bitSet, (BitSet)bitSet4).soln;
                dArray3[n] = 0.0;
                for (n5 = 0; n5 < n3; ++n5) {
                    int n6 = n;
                    dArray3[n6] = dArray3[n6] + dArray[n5] * dArray4[n5];
                }
                this.mainLog.print("\nProbability of reaching BSCC " + (n + 1) + ": " + dArray3[n] + "\n");
            }
            for (n = 0; n < n2; ++n) {
                this.mainLog.println("\nComputing steady-state probabilities for BSCC " + (n + 1));
                bitSet4 = list.get(n);
                this.computeSteadyStateProbsForBSCC(dTMC, bitSet4, dArray2);
                n5 = bitSet4.nextSetBit(0);
                while (n5 >= 0) {
                    int n7 = n5;
                    dArray2[n7] = dArray2[n7] * dArray3[n];
                    n5 = bitSet4.nextSetBit(n5 + 1);
                }
            }
        }
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray2;
        l = System.currentTimeMillis() - l;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeSteadyStateBackwardsProbs(DTMC dTMC, double[] dArray) throws PrismException {
        int n;
        BitSet bitSet;
        int n2;
        int n3 = 0;
        long l = System.currentTimeMillis();
        int n4 = dTMC.getNumStates();
        SCCComputer sCCComputer = SCCComputer.createSCCComputer(this, dTMC);
        sCCComputer.computeBSCCs();
        List<BitSet> list = sCCComputer.getBSCCs();
        BitSet bitSet2 = sCCComputer.getNotInBSCCs();
        n3 = list.size();
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n4];
        for (n2 = 0; n2 < n3; ++n2) {
            this.mainLog.println("\nComputing steady state probabilities for BSCC " + (n2 + 1));
            bitSet = list.get(n2);
            this.computeSteadyStateProbsForBSCC(dTMC, bitSet, dArray3);
            dArray2[n2] = 0.0;
            if (dArray == null) {
                n = bitSet.nextSetBit(0);
                while (n >= 0) {
                    int n5 = n2;
                    dArray2[n5] = dArray2[n5] + dArray3[n];
                    n = bitSet.nextSetBit(n + 1);
                }
            } else {
                n = bitSet.nextSetBit(0);
                while (n >= 0) {
                    int n6 = n2;
                    dArray2[n6] = dArray2[n6] + dArray[n] * dArray3[n];
                    n = bitSet.nextSetBit(n + 1);
                }
            }
            this.mainLog.print("\nValue for BSCC " + (n2 + 1) + ": " + dArray2[n2] + "\n");
        }
        double[] dArray4 = new double[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            dArray4[n2] = 0.0;
        }
        if (bitSet2.isEmpty()) {
            this.mainLog.println("\nAll states are in BSCCs (so no reachability probabilities computed)");
            for (n2 = 0; n2 < n3; ++n2) {
                bitSet = list.get(n2);
                n = bitSet.nextSetBit(0);
                while (n >= 0) {
                    int n7 = n;
                    dArray4[n7] = dArray4[n7] + dArray2[n2];
                    n = bitSet.nextSetBit(n + 1);
                }
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                if (dArray2[n2] == 0.0) continue;
                this.mainLog.println("\nComputing probabilities of reaching BSCC " + (n2 + 1));
                bitSet = list.get(n2);
                double[] dArray5 = this.computeUntilProbs((DTMC)dTMC, (BitSet)bitSet2, (BitSet)bitSet).soln;
                for (n = 0; n < n4; ++n) {
                    int n8 = n;
                    dArray4[n8] = dArray4[n8] + dArray5[n] * dArray2[n2];
                }
            }
        }
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray4;
        l = System.currentTimeMillis() - l;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeSteadyStateProbsForBSCC(DTMC dTMC, BitSet bitSet, double[] dArray) throws PrismException {
        int n;
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting value iteration...");
        int n2 = dTMC.getNumStates();
        double[] dArray2 = dArray == null ? new double[n2] : dArray;
        double[] dArray3 = new double[n2];
        double d = 1.0 / (double)bitSet.cardinality();
        int n3 = bitSet.nextSetBit(0);
        while (n3 >= 0) {
            dArray2[n3] = dArray3[n3] = d;
            n3 = bitSet.nextSetBit(n3 + 1);
        }
        boolean bl = false;
        for (n = 0; !bl && n < this.maxIters; ++n) {
            dTMC.vmMult(dArray2, dArray3);
            bl = PrismUtils.doublesAreClose(dArray2, dArray3, this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
            double[] dArray4 = dArray2;
            dArray2 = dArray3;
            dArray3 = dArray4;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Value iteration");
        this.mainLog.println(" took " + n + " iterations and " + (double)l / 1000.0 + " seconds.");
        if (!bl && this.errorOnNonConverge) {
            String string = "Iterative method did not converge within " + n + " iterations.";
            string = string + "\nConsider using a different numerical method or increasing the maximum number of iterations";
            throw new PrismException(string);
        }
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray2;
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeTransientProbs(DTMC dTMC, int n, double[] dArray) throws PrismException {
        throw new PrismNotSupportedException("Not implemented yet");
    }

    public static void main(String[] stringArray) {
        try {
            int n = 2;
            if (n == 1) {
                DTMCModelChecker dTMCModelChecker = new DTMCModelChecker(null);
                DTMCSimple dTMCSimple = new DTMCSimple();
                dTMCSimple.buildFromPrismExplicit(stringArray[0]);
                Map<String, BitSet> map = dTMCModelChecker.loadLabelsFile(stringArray[1]);
                BitSet bitSet = map.get(stringArray[2]);
                if (bitSet == null) {
                    throw new PrismException("Unknown label \"" + stringArray[2] + "\"");
                }
                for (int i = 3; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals("-nopre")) continue;
                    dTMCModelChecker.setPrecomp(false);
                }
                ModelCheckerResult modelCheckerResult = dTMCModelChecker.computeReachProbs(dTMCSimple, bitSet);
                System.out.println(modelCheckerResult.soln[0]);
            } else {
                DTMCModelChecker dTMCModelChecker = new DTMCModelChecker(null);
                DTMCSimple dTMCSimple = new DTMCSimple(6);
                dTMCSimple.setProbability(0, 1, 0.1);
                dTMCSimple.setProbability(0, 2, 0.9);
                dTMCSimple.setProbability(1, 0, 0.4);
                dTMCSimple.setProbability(1, 3, 0.6);
                dTMCSimple.setProbability(2, 2, 0.1);
                dTMCSimple.setProbability(2, 3, 0.1);
                dTMCSimple.setProbability(2, 4, 0.5);
                dTMCSimple.setProbability(2, 5, 0.3);
                dTMCSimple.setProbability(3, 3, 1.0);
                dTMCSimple.setProbability(4, 4, 1.0);
                dTMCSimple.setProbability(5, 5, 0.3);
                dTMCSimple.setProbability(5, 4, 0.7);
                System.out.println(dTMCSimple);
                BitSet bitSet = new BitSet();
                bitSet.set(4);
                BitSet bitSet2 = new BitSet();
                bitSet2.set(1);
                bitSet2.flip(0, 6);
                System.out.println(bitSet);
                System.out.println(bitSet2);
                ModelCheckerResult modelCheckerResult = dTMCModelChecker.computeUntilProbs(dTMCSimple, bitSet2, bitSet);
                System.out.println(modelCheckerResult.soln[0]);
            }
        }
        catch (PrismException prismException) {
            System.out.println(prismException);
        }
    }
}

