/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableStateSet;
import explicit.CTMCSimple;
import explicit.DTMCExplicit;
import explicit.Distribution;
import explicit.rewards.MCRewards;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import parser.State;
import parser.Values;
import prism.ModelType;
import prism.PrismException;
import prism.PrismNotSupportedException;

public class DTMCEmbeddedSimple
extends DTMCExplicit {
    protected CTMCSimple ctmc;
    protected double[] exitRates;
    protected int numExtraTransitions;

    public DTMCEmbeddedSimple(CTMCSimple cTMCSimple) {
        this.ctmc = cTMCSimple;
        this.numStates = cTMCSimple.getNumStates();
        this.exitRates = new double[this.numStates];
        this.numExtraTransitions = 0;
        for (int i = 0; i < this.numStates; ++i) {
            this.exitRates[i] = cTMCSimple.getTransitions(i).sum();
            if (this.exitRates[i] != 0.0) continue;
            ++this.numExtraTransitions;
        }
    }

    @Override
    public void buildFromPrismExplicit(String string) throws PrismException {
        throw new PrismNotSupportedException("Not supported");
    }

    @Override
    public ModelType getModelType() {
        return ModelType.DTMC;
    }

    @Override
    public int getNumStates() {
        return this.ctmc.getNumStates();
    }

    @Override
    public int getNumInitialStates() {
        return this.ctmc.getNumInitialStates();
    }

    @Override
    public Iterable<Integer> getInitialStates() {
        return this.ctmc.getInitialStates();
    }

    @Override
    public int getFirstInitialState() {
        return this.ctmc.getFirstInitialState();
    }

    @Override
    public boolean isInitialState(int n) {
        return this.ctmc.isInitialState(n);
    }

    @Override
    public boolean isDeadlockState(int n) {
        return this.ctmc.isDeadlockState(n);
    }

    @Override
    public List<State> getStatesList() {
        return this.ctmc.getStatesList();
    }

    @Override
    public Values getConstantValues() {
        return this.ctmc.getConstantValues();
    }

    @Override
    public int getNumTransitions() {
        return this.ctmc.getNumTransitions() + this.numExtraTransitions;
    }

    @Override
    public Iterator<Integer> getSuccessorsIterator(int n) {
        if (this.exitRates[n] == 0.0) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(1);
            arrayList.add(n);
            return arrayList.iterator();
        }
        return this.ctmc.getSuccessorsIterator(n);
    }

    @Override
    public boolean isSuccessor(int n, int n2) {
        return this.exitRates[n] == 0.0 ? n == n2 : this.ctmc.isSuccessor(n, n2);
    }

    @Override
    public boolean allSuccessorsInSet(int n, BitSet bitSet) {
        return this.exitRates[n] == 0.0 ? bitSet.get(n) : this.ctmc.allSuccessorsInSet(n, bitSet);
    }

    @Override
    public boolean someSuccessorsInSet(int n, BitSet bitSet) {
        return this.exitRates[n] == 0.0 ? bitSet.get(n) : this.ctmc.someSuccessorsInSet(n, bitSet);
    }

    public int getNumChoices(int n) {
        return 1;
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
    }

    @Override
    public void checkForDeadlocks() throws PrismException {
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
    }

    @Override
    public String infoString() {
        String string = "";
        string = string + this.numStates + " states (" + this.getNumInitialStates() + " initial)";
        string = string + ", " + this.getNumTransitions() + " transitions (incl. " + this.numExtraTransitions + " self-loops)";
        return string;
    }

    @Override
    public String infoStringTable() {
        String string = "";
        string = string + "States:      " + this.numStates + " (" + this.getNumInitialStates() + " initial)\n";
        string = string + "Transitions: " + this.getNumTransitions() + "\n";
        return string;
    }

    @Override
    public int getNumTransitions(int n) {
        if (this.exitRates[n] == 0.0) {
            return 1;
        }
        return this.ctmc.getNumTransitions(n);
    }

    @Override
    public Iterator<Map.Entry<Integer, Double>> getTransitionsIterator(int n) {
        if (this.exitRates[n] == 0.0) {
            TreeMap<Integer, Double> treeMap = new TreeMap<Integer, Double>();
            treeMap.put(n, 1.0);
            return treeMap.entrySet().iterator();
        }
        final Iterator<Map.Entry<Integer, Double>> iterator = this.ctmc.getTransitionsIterator(n);
        final double d = this.exitRates[n];
        return new Iterator<Map.Entry<Integer, Double>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Map.Entry<Integer, Double> next() {
                final Map.Entry entry = (Map.Entry)iterator.next();
                return new Map.Entry<Integer, Double>(){

                    @Override
                    public Integer getKey() {
                        return (Integer)entry.getKey();
                    }

                    @Override
                    public Double getValue() {
                        return (Double)entry.getValue() / d;
                    }

                    @Override
                    public Double setValue(Double d) {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void prob0step(BitSet bitSet, BitSet bitSet2, BitSet bitSet3) {
        for (int n : new IterableStateSet(bitSet, this.numStates)) {
            bitSet3.set(n, this.someSuccessorsInSet(n, bitSet2));
        }
    }

    @Override
    public void prob1step(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4) {
        Iterator<Integer> iterator = new IterableStateSet(bitSet, this.numStates).iterator();
        while (iterator.hasNext()) {
            int n;
            bitSet4.set(n, this.someSuccessorsInSet(n = iterator.next().intValue(), bitSet3) && this.allSuccessorsInSet(n, bitSet2));
        }
    }

    @Override
    public double mvMultSingle(int n, double[] dArray) {
        Distribution distribution = this.ctmc.getTransitions(n);
        double d = 0.0;
        double d2 = this.exitRates[n];
        if (d2 == 0.0) {
            d += dArray[n];
        } else {
            for (Map.Entry<Integer, Double> entry : distribution) {
                int n2 = entry.getKey();
                double d3 = entry.getValue();
                d += d3 * dArray[n2];
            }
            d /= d2;
        }
        return d;
    }

    @Override
    public double mvMultJacSingle(int n, double[] dArray) {
        Distribution distribution = this.ctmc.getTransitions(n);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.exitRates[n];
        if (d3 == 0.0) {
            return 0.0;
        }
        for (Map.Entry<Integer, Double> entry : distribution) {
            int n2 = entry.getKey();
            double d4 = entry.getValue();
            if (n2 != n) {
                d += d4 * dArray[n2];
                continue;
            }
            d2 = d4;
        }
        return d /= d3 - d2;
    }

    @Override
    public double mvMultRewSingle(int n, double[] dArray, MCRewards mCRewards) {
        Distribution distribution = this.ctmc.getTransitions(n);
        double d = this.exitRates[n];
        double d2 = 0.0;
        if (d == 0.0) {
            d2 += dArray[n];
        } else {
            for (Map.Entry<Integer, Double> entry : distribution) {
                int n2 = entry.getKey();
                double d3 = entry.getValue();
                d2 += d3 * dArray[n2];
            }
            d2 /= d;
        }
        return d2 += mCRewards.getStateReward(n);
    }

    public double mvMultRewJacSingle(int n, double[] dArray, MCRewards mCRewards) {
        Distribution distribution = this.ctmc.getTransitions(n);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.exitRates[n];
        if (d3 == 0.0) {
            return mCRewards.getStateReward(n);
        }
        d = d3 * mCRewards.getStateReward(n);
        for (Map.Entry<Integer, Double> entry : distribution) {
            int n2 = entry.getKey();
            double d4 = entry.getValue();
            if (n2 != n) {
                d += d4 * dArray[n2];
                continue;
            }
            d2 = d4;
        }
        return d /= d3 - d2;
    }

    @Override
    public void vmMult(double[] dArray, double[] dArray2) {
        int n;
        for (n = 0; n < this.numStates; ++n) {
            dArray2[n] = 0.0;
        }
        for (int i = 0; i < this.numStates; ++i) {
            Distribution distribution = this.ctmc.getTransitions(i);
            double d = this.exitRates[i];
            if (d == 0.0) {
                int n2 = i;
                dArray2[n2] = dArray2[n2] + dArray[i];
                continue;
            }
            for (Map.Entry<Integer, Double> entry : distribution) {
                n = entry.getKey();
                double d2 = entry.getValue();
                int n3 = n;
                dArray2[n3] = dArray2[n3] + d2 / d * dArray[i];
            }
        }
    }

    public String toString() {
        String string = "";
        string = string + "ctmc: " + this.ctmc;
        boolean bl = true;
        string = ", exitRates: [ ";
        int n = this.getNumStates();
        for (int i = 0; i < n; ++i) {
            if (bl) {
                bl = false;
            } else {
                string = string + ", ";
            }
            string = string + i + ": " + this.exitRates[i];
        }
        string = string + " ]";
        return string;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof DTMCEmbeddedSimple)) {
            return false;
        }
        DTMCEmbeddedSimple dTMCEmbeddedSimple = (DTMCEmbeddedSimple)object;
        if (!this.ctmc.equals(dTMCEmbeddedSimple.ctmc)) {
            return false;
        }
        if (!this.exitRates.equals(dTMCEmbeddedSimple.exitRates)) {
            return false;
        }
        return this.numExtraTransitions == dTMCEmbeddedSimple.numExtraTransitions;
    }
}

