/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.CTMCSimple;
import explicit.CTMDPSimple;
import explicit.DTMCSimple;
import explicit.Distribution;
import explicit.IndexedSet;
import explicit.MDPSimple;
import explicit.MDPSparse;
import explicit.Model;
import explicit.ModelExplicit;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.List;
import parser.State;
import parser.Values;
import parser.VarList;
import parser.ast.Expression;
import parser.ast.ModulesFile;
import prism.ModelType;
import prism.Prism;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismNotSupportedException;
import prism.PrismPrintStreamLog;
import prism.ProgressDisplay;
import prism.UndefinedConstants;
import simulator.SimulatorEngine;

public class ConstructModel
extends PrismComponent {
    protected SimulatorEngine engine;
    protected boolean findDeadlocks = true;
    protected boolean fixDeadlocks = true;
    protected List<State> statesList;

    public ConstructModel(PrismComponent prismComponent, SimulatorEngine simulatorEngine) throws PrismException {
        super(prismComponent);
        this.engine = simulatorEngine;
    }

    public List<State> getStatesList() {
        return this.statesList;
    }

    public void setFixDeadlocks(boolean bl) {
        this.fixDeadlocks = bl;
    }

    public List<State> computeReachableStates(ModulesFile modulesFile) throws PrismException {
        this.constructModel(modulesFile, true, false);
        return this.statesList;
    }

    public Model constructModel(ModulesFile modulesFile) throws PrismException {
        return this.constructModel(modulesFile, false, true);
    }

    public Model constructModel(ModulesFile modulesFile, boolean bl, boolean bl2) throws PrismException {
        return this.constructModel(modulesFile, bl, bl2, true);
    }

    /*
     * WARNING - void declaration
     */
    public Model constructModel(ModulesFile modulesFile, boolean bl, boolean bl2, boolean bl3) throws PrismException {
        State state;
        ModelExplicit modelExplicit = null;
        DTMCSimple dTMCSimple = null;
        CTMCSimple cTMCSimple = null;
        MDPSimple mDPSimple = null;
        CTMDPSimple cTMDPSimple = null;
        ModelExplicit modelExplicit2 = null;
        Distribution distribution = null;
        ModelType modelType = modulesFile.getModelType();
        VarList varList = modulesFile.createVarList();
        if (varList.containsUnboundedVariables()) {
            this.mainLog.printWarning("Model contains one or more unbounded variables: model construction may not terminate");
        }
        this.mainLog.print("\nComputing reachable states...");
        this.mainLog.flush();
        ProgressDisplay progressDisplay = new ProgressDisplay(this.mainLog);
        progressDisplay.start();
        long l = System.currentTimeMillis();
        this.engine.createNewOnTheFlyPath(modulesFile);
        if (!bl) {
            switch (modelType) {
                case DTMC: {
                    dTMCSimple = new DTMCSimple();
                    modelExplicit = dTMCSimple;
                    break;
                }
                case CTMC: {
                    cTMCSimple = new CTMCSimple();
                    modelExplicit = cTMCSimple;
                    break;
                }
                case MDP: {
                    mDPSimple = new MDPSimple();
                    modelExplicit = mDPSimple;
                    break;
                }
                case CTMDP: {
                    cTMDPSimple = new CTMDPSimple();
                    modelExplicit = cTMDPSimple;
                    break;
                }
                case STPG: 
                case SMG: 
                case PTA: {
                    throw new PrismNotSupportedException("Model construction not supported for " + (Object)((Object)modelType) + "s");
                }
            }
        }
        IndexedSet<State> indexedSet = new IndexedSet<State>(true);
        LinkedList<State> linkedList = new LinkedList<State>();
        if (modulesFile.getInitialStates() == null) {
            state = modulesFile.getDefaultInitialState();
            linkedList.add(state);
        } else {
            Expression expression = modulesFile.getInitialStates();
            List<State> object2 = varList.getAllStates();
            for (State state2 : object2) {
                if (!expression.evaluateBoolean(modulesFile.getConstantValues(), state2)) continue;
                linkedList.add(state2);
            }
        }
        for (State state3 : linkedList) {
            indexedSet.add(state3);
            if (bl) continue;
            modelExplicit.addState();
            modelExplicit.addInitialState(modelExplicit.getNumStates() - 1);
        }
        int n = -1;
        while (!linkedList.isEmpty()) {
            state = (State)linkedList.removeFirst();
            ++n;
            this.engine.initialisePath(state);
            int n2 = this.engine.getNumChoices();
            for (int i = 0; i < n2; ++i) {
                if (!bl && modelType.nondeterministic()) {
                    distribution = new Distribution();
                }
                int n3 = this.engine.getNumTransitions(i);
                block24: for (int j = 0; j < n3; ++j) {
                    State state4 = this.engine.computeTransitionTarget(i, j);
                    if (indexedSet.add(state4)) {
                        linkedList.add(state4);
                        if (!bl) {
                            modelExplicit.addState();
                        }
                    }
                    int n4 = indexedSet.getIndexOfLastAdd();
                    if (bl) continue;
                    switch (modelType) {
                        case DTMC: {
                            dTMCSimple.addToProbability(n, n4, this.engine.getTransitionProbability(i, j));
                            continue block24;
                        }
                        case CTMC: {
                            cTMCSimple.addToProbability(n, n4, this.engine.getTransitionProbability(i, j));
                            continue block24;
                        }
                        case MDP: 
                        case CTMDP: {
                            distribution.add(n4, this.engine.getTransitionProbability(i, j));
                            continue block24;
                        }
                        case STPG: 
                        case SMG: 
                        case PTA: {
                            throw new PrismNotSupportedException("Model construction not supported for " + (Object)((Object)modelType) + "s");
                        }
                    }
                }
                if (bl) continue;
                if (modelType == ModelType.MDP) {
                    if (bl3) {
                        mDPSimple.addActionLabelledChoice(n, distribution, this.engine.getTransitionAction(i, 0));
                        continue;
                    }
                    mDPSimple.addChoice(n, distribution);
                    continue;
                }
                if (modelType != ModelType.CTMDP) continue;
                if (bl3) {
                    cTMDPSimple.addActionLabelledChoice(n, distribution, this.engine.getTransitionAction(i, 0));
                    continue;
                }
                cTMDPSimple.addChoice(n, distribution);
            }
            progressDisplay.updateIfReady(n + 1);
        }
        progressDisplay.update(n + 1);
        progressDisplay.end(" states");
        this.mainLog.print("Reachable states exploration" + (bl ? "" : " and model construction"));
        this.mainLog.println(" done in " + (double)(System.currentTimeMillis() - l) / 1000.0 + " secs.");
        if (!bl && this.findDeadlocks) {
            modelExplicit.findDeadlocks(this.fixDeadlocks);
        }
        boolean bl4 = true;
        Object var28_24 = null;
        if (bl4) {
            this.mainLog.println("Sorting reachable states list...");
            int[] nArray = indexedSet.buildSortingPermutation();
            this.statesList = indexedSet.toPermutedArrayList(nArray);
        } else {
            this.statesList = indexedSet.toArrayList();
        }
        indexedSet.clear();
        indexedSet = null;
        if (!bl) {
            switch (modelType) {
                case DTMC: {
                    void var28_26;
                    modelExplicit2 = bl4 ? new DTMCSimple(dTMCSimple, (int[])var28_26) : dTMCSimple;
                    break;
                }
                case CTMC: {
                    void var28_26;
                    modelExplicit2 = bl4 ? new CTMCSimple(cTMCSimple, (int[])var28_26) : cTMCSimple;
                    break;
                }
                case MDP: {
                    void var28_26;
                    if (bl2) {
                        modelExplicit2 = bl4 ? new MDPSparse(mDPSimple, true, (int[])var28_26) : new MDPSparse(mDPSimple);
                        break;
                    }
                    modelExplicit2 = bl4 ? new MDPSimple(mDPSimple, (int[])var28_26) : mDPSimple;
                    break;
                }
                case CTMDP: {
                    void var28_26;
                    modelExplicit2 = bl4 ? new CTMDPSimple(cTMDPSimple, (int[])var28_26) : mDPSimple;
                    break;
                }
                case STPG: 
                case SMG: 
                case PTA: {
                    throw new PrismNotSupportedException("Model construction not supported for " + (Object)((Object)modelType) + "s");
                }
            }
            modelExplicit2.setStatesList(this.statesList);
            modelExplicit2.setConstantValues(new Values(modulesFile.getConstantValues()));
        }
        Object var28_27 = null;
        return modelExplicit2;
    }

    public static void main(String[] stringArray) {
        try {
            PrismPrintStreamLog prismPrintStreamLog = new PrismPrintStreamLog(System.out);
            Prism prism = new Prism(prismPrintStreamLog, prismPrintStreamLog);
            ModulesFile modulesFile = prism.parseModelFile(new File(stringArray[0]));
            UndefinedConstants undefinedConstants = new UndefinedConstants(modulesFile, null);
            if (stringArray.length > 2) {
                undefinedConstants.defineUsingConstSwitch(stringArray[2]);
            }
            modulesFile.setUndefinedConstants(undefinedConstants.getMFConstantValues());
            ConstructModel constructModel = new ConstructModel(prism, prism.getSimulator());
            Model model = constructModel.constructModel(modulesFile);
            model.exportToPrismExplicitTra(stringArray[1]);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error: " + fileNotFoundException.getMessage());
            System.exit(1);
        }
        catch (PrismException prismException) {
            System.out.println("Error: " + prismException.getMessage());
            System.exit(1);
        }
    }
}

