/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.CTMDP;
import explicit.CTMDPSimple;
import explicit.FoxGlynn;
import explicit.MDPModelChecker;
import explicit.MDPSimple;
import explicit.MinMax;
import explicit.Model;
import explicit.ModelCheckerResult;
import explicit.StateValues;
import java.util.BitSet;
import java.util.Map;
import parser.ast.ExpressionTemporal;
import prism.PrismComponent;
import prism.PrismException;

public class CTMDPModelChecker
extends MDPModelChecker {
    public CTMDPModelChecker(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    @Override
    protected StateValues checkProbBoundedUntil(Model model, ExpressionTemporal expressionTemporal, MinMax minMax, BitSet bitSet) throws PrismException {
        StateValues stateValues = null;
        ModelCheckerResult modelCheckerResult = null;
        double d = expressionTemporal.getUpperBound().evaluateDouble(this.constantValues);
        if (d < 0.0 || d == 0.0 && expressionTemporal.upperBoundIsStrict()) {
            String string = (expressionTemporal.upperBoundIsStrict() ? "<" : "<=") + d;
            throw new PrismException("Invalid upper bound " + string + " in time-bounded until formula");
        }
        BitSet bitSet2 = this.checkExpression(model, expressionTemporal.getOperand1(), null).getBitSet();
        BitSet bitSet3 = this.checkExpression(model, expressionTemporal.getOperand2(), null).getBitSet();
        if (d == 0.0) {
            stateValues = StateValues.createFromBitSetAsDoubles(bitSet3, model);
        } else {
            modelCheckerResult = this.computeBoundedUntilProbs((CTMDP)model, bitSet2, bitSet3, d, minMax.isMin());
            stateValues = StateValues.createFromDoubleArray(modelCheckerResult.soln, model);
        }
        return stateValues;
    }

    public ModelCheckerResult computeBoundedUntilProbs(CTMDP cTMDP, BitSet bitSet, BitSet bitSet2, double d, boolean bl) throws PrismException {
        return this.computeBoundedReachProbs(cTMDP, bitSet, bitSet2, d, bl, null, null);
    }

    public ModelCheckerResult computeBoundedReachProbs(CTMDP cTMDP, BitSet bitSet, BitSet bitSet2, double d, boolean bl, double[] dArray, double[] dArray2) throws PrismException {
        if (!cTMDP.isLocallyUniform()) {
            throw new PrismException("Can't compute bounded reachability probabilities for non-locally uniform CTMDP");
        }
        double d2 = 0.001;
        double d3 = cTMDP.getMaxExitRate();
        int n = (int)Math.ceil(d3 * d * d3 * d / (2.0 * d2));
        double d4 = d / (double)n;
        this.mainLog.println("q = " + d3 + ", k = " + n + ", tau = " + d4);
        MDPSimple mDPSimple = cTMDP.buildDiscretisedMDP(d4);
        this.mainLog.println(mDPSimple);
        MDPModelChecker mDPModelChecker = new MDPModelChecker(this);
        mDPModelChecker.inheritSettings(this);
        ModelCheckerResult modelCheckerResult = mDPModelChecker.computeBoundedUntilProbs(mDPSimple, null, bitSet2, n, bl);
        return modelCheckerResult;
    }

    public ModelCheckerResult computeBoundedReachProbsOld(CTMDP cTMDP, BitSet bitSet, BitSet bitSet2, double d, boolean bl, double[] dArray, double[] dArray2) throws PrismException {
        int n;
        int n2;
        ModelCheckerResult modelCheckerResult = null;
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting time-bounded probabilistic reachability...");
        int n3 = cTMDP.getNumStates();
        double d2 = 99.0;
        double d3 = d2 * d;
        this.mainLog.println("\nUniformisation: q.t = " + d2 + " x " + d + " = " + d3);
        FoxGlynn foxGlynn = new FoxGlynn(d3, 1.0E-300, 1.0E300, this.termCritParam / 8.0);
        int n4 = foxGlynn.getLeftTruncationPoint();
        int n5 = foxGlynn.getRightTruncationPoint();
        if (n5 < 0) {
            throw new PrismException("Overflow in Fox-Glynn computation (time bound too big?)");
        }
        double[] dArray3 = foxGlynn.getWeights();
        double d4 = foxGlynn.getTotalWeight();
        for (n2 = n4; n2 <= n5; ++n2) {
            int n6 = n2 - n4;
            dArray3[n6] = dArray3[n6] / d4;
        }
        this.mainLog.println("Fox-Glynn: left = " + n4 + ", right = " + n5);
        double[] dArray4 = new double[n3];
        double[] dArray5 = dArray == null ? new double[n3] : dArray;
        double[] dArray6 = new double[n3];
        if (dArray != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray5[n2] = bitSet2.get(n2) ? 1.0 : dArray[n2];
                dArray4[n2] = dArray5[n2];
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray5[n2] = bitSet2.get(n2) ? 1.0 : 0.0;
                dArray4[n2] = dArray5[n2];
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray6[n2] = 0.0;
        }
        if (n4 == 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                int n7 = n2;
                dArray6[n7] = dArray6[n7] + dArray3[0] * dArray4[n2];
            }
        }
        for (n = 1; n <= n5; ++n) {
            cTMDP.mvMultMinMax(dArray4, bl, dArray5, bitSet2, true, null);
            n2 = 0;
            while (n2 < n3) {
                int n8 = n2++;
                dArray5[n8] = dArray5[n8] / d2;
            }
            double[] dArray7 = dArray4;
            dArray4 = dArray5;
            dArray5 = dArray7;
            if (n < n4) continue;
            for (n2 = 0; n2 < n3; ++n2) {
                int n9 = n2;
                dArray6[n9] = dArray6[n9] + dArray3[n - n4] * dArray4[n2];
            }
        }
        this.mainLog.println(dArray6);
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Time-bounded probabilistic reachability (" + (bl ? "min" : "max") + ")");
        this.mainLog.println(" took " + n + " iters and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray6;
        modelCheckerResult.lastSoln = dArray5;
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public static void main(String[] stringArray) {
        boolean bl = true;
        try {
            CTMDPModelChecker cTMDPModelChecker = new CTMDPModelChecker(null);
            CTMDPSimple cTMDPSimple = new CTMDPSimple();
            cTMDPSimple.buildFromPrismExplicit(stringArray[0]);
            System.out.println(cTMDPSimple);
            Map<String, BitSet> map = cTMDPModelChecker.loadLabelsFile(stringArray[1]);
            System.out.println(map);
            BitSet bitSet = map.get(stringArray[2]);
            if (bitSet == null) {
                throw new PrismException("Unknown label \"" + stringArray[2] + "\"");
            }
            for (int i = 4; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-min")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-max")) {
                    bl = false;
                    continue;
                }
                if (!stringArray[i].equals("-nopre")) continue;
                cTMDPModelChecker.setPrecomp(false);
            }
            ModelCheckerResult modelCheckerResult = cTMDPModelChecker.computeBoundedReachProbs(cTMDPSimple, null, bitSet, Double.parseDouble(stringArray[3]), bl, null, null);
            System.out.println(modelCheckerResult.soln[0]);
        }
        catch (PrismException prismException) {
            System.out.println(prismException);
        }
    }
}

