/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.CTMC;
import explicit.CTMCSimple;
import explicit.DTMC;
import explicit.DTMCModelChecker;
import explicit.FoxGlynn;
import explicit.MinMax;
import explicit.Model;
import explicit.ModelCheckerResult;
import explicit.StateValues;
import explicit.Utils;
import explicit.rewards.MCRewards;
import explicit.rewards.StateRewardsArray;
import java.io.File;
import java.util.BitSet;
import java.util.Map;
import parser.ast.Expression;
import parser.ast.ExpressionTemporal;
import parser.type.Type;
import parser.type.TypeDouble;
import prism.PrismComponent;
import prism.PrismException;

public class CTMCModelChecker
extends DTMCModelChecker {
    public CTMCModelChecker(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    @Override
    protected StateValues checkProbPathFormulaLTL(Model model, Expression expression, boolean bl, MinMax minMax, BitSet bitSet) throws PrismException {
        this.mainLog.println("Building embedded DTMC...");
        DTMC dTMC = ((CTMC)model).getImplicitEmbeddedDTMC();
        return super.checkProbPathFormulaLTL(dTMC, expression, bl, minMax, bitSet);
    }

    @Override
    protected StateValues checkProbBoundedUntil(Model model, ExpressionTemporal expressionTemporal, MinMax minMax, BitSet bitSet) throws PrismException {
        double d;
        double d2;
        StateValues stateValues = null;
        ModelCheckerResult modelCheckerResult = null;
        ModelCheckerResult modelCheckerResult2 = null;
        Expression expression = expressionTemporal.getLowerBound();
        if (expression != null) {
            d2 = expression.evaluateDouble(this.constantValues);
            if (d2 < 0.0) {
                throw new PrismException("Invalid lower bound " + d2 + " in time-bounded until formula");
            }
        } else {
            d2 = 0.0;
        }
        if ((expression = expressionTemporal.getUpperBound()) != null) {
            d = expression.evaluateDouble(this.constantValues);
            if (d < 0.0 || d == 0.0 && expressionTemporal.upperBoundIsStrict()) {
                String string = (expressionTemporal.upperBoundIsStrict() ? "<" : "<=") + d;
                throw new PrismException("Invalid upper bound " + string + " in time-bounded until formula");
            }
            if (d < d2) {
                throw new PrismException("Upper bound must exceed lower bound in time-bounded until formula");
            }
        } else {
            d = -1.0;
        }
        BitSet bitSet2 = this.checkExpression(model, expressionTemporal.getOperand1(), null).getBitSet();
        BitSet bitSet3 = this.checkExpression(model, expressionTemporal.getOperand2(), null).getBitSet();
        if (d2 == 0.0 && d == 0.0) {
            stateValues = StateValues.createFromBitSetAsDoubles(bitSet3, model);
        } else if (d == -1.0) {
            if (d2 == 0.0) {
                modelCheckerResult2 = this.computeUntilProbs((DTMC)model, bitSet2, bitSet3);
                stateValues = StateValues.createFromDoubleArray(modelCheckerResult2.soln, model);
            } else {
                modelCheckerResult = this.computeUntilProbs((DTMC)model, bitSet2, bitSet3);
                modelCheckerResult2 = this.computeTransientBackwardsProbs((CTMC)model, bitSet2, bitSet2, d2, modelCheckerResult.soln);
                stateValues = StateValues.createFromDoubleArray(modelCheckerResult2.soln, model);
            }
        } else if (d2 == 0.0) {
            bitSet2.andNot(bitSet3);
            modelCheckerResult2 = this.computeTransientBackwardsProbs((CTMC)model, bitSet3, bitSet2, d, null);
            stateValues = StateValues.createFromDoubleArray(modelCheckerResult2.soln, model);
            int n = model.getNumStates();
            for (int i = 0; i < n; ++i) {
                if (!bitSet3.get(i)) continue;
                stateValues.setDoubleValue(i, 1.0);
            }
        } else {
            BitSet bitSet4 = (BitSet)bitSet2.clone();
            bitSet4.andNot(bitSet3);
            modelCheckerResult = this.computeTransientBackwardsProbs((CTMC)model, bitSet3, bitSet4, d - d2, null);
            modelCheckerResult2 = this.computeTransientBackwardsProbs((CTMC)model, bitSet2, bitSet2, d2, modelCheckerResult.soln);
            stateValues = StateValues.createFromDoubleArray(modelCheckerResult2.soln, model);
        }
        return stateValues;
    }

    public StateValues doTransient(CTMC cTMC, double d) throws PrismException {
        return this.doTransient(cTMC, d, (StateValues)null);
    }

    public StateValues doTransient(CTMC cTMC, double d, File file) throws PrismException {
        StateValues stateValues = this.readDistributionFromFile(file, cTMC);
        return this.doTransient(cTMC, d, stateValues);
    }

    public StateValues doTransient(CTMC cTMC, double d, StateValues stateValues) throws PrismException {
        ModelCheckerResult modelCheckerResult = null;
        StateValues stateValues2 = null;
        StateValues stateValues3 = null;
        if (stateValues == null) {
            stateValues2 = new StateValues((Type)TypeDouble.getInstance(), new Double(0.0), cTMC);
            double d2 = 1.0 / (double)cTMC.getNumInitialStates();
            for (int n : cTMC.getInitialStates()) {
                stateValues2.setDoubleValue(n, d2);
            }
        } else {
            stateValues2 = stateValues;
        }
        modelCheckerResult = this.computeTransientProbs(cTMC, d, stateValues2.getDoubleArray());
        stateValues3 = StateValues.createFromDoubleArray(modelCheckerResult.soln, cTMC);
        return stateValues3;
    }

    public ModelCheckerResult computeNextProbs(CTMC cTMC, BitSet bitSet) throws PrismException {
        this.mainLog.println("Building embedded DTMC...");
        DTMC dTMC = cTMC.getImplicitEmbeddedDTMC();
        return super.computeNextProbs(dTMC, bitSet);
    }

    public ModelCheckerResult computeReachProbs(CTMC cTMC, BitSet bitSet) throws PrismException {
        this.mainLog.println("Building embedded DTMC...");
        DTMC dTMC = cTMC.getImplicitEmbeddedDTMC();
        return super.computeReachProbs(dTMC, bitSet);
    }

    public ModelCheckerResult computeUntilProbs(CTMC cTMC, BitSet bitSet, BitSet bitSet2) throws PrismException {
        this.mainLog.println("Building embedded DTMC...");
        DTMC dTMC = cTMC.getImplicitEmbeddedDTMC();
        return super.computeUntilProbs(dTMC, bitSet, bitSet2);
    }

    public ModelCheckerResult computeReachProbs(CTMC cTMC, BitSet bitSet, BitSet bitSet2, double[] dArray, BitSet bitSet3) throws PrismException {
        this.mainLog.println("Building embedded DTMC...");
        DTMC dTMC = cTMC.getImplicitEmbeddedDTMC();
        return super.computeReachProbs(dTMC, bitSet, bitSet2, dArray, bitSet3);
    }

    public ModelCheckerResult computeTimeBoundedReachProbs(CTMC cTMC, BitSet bitSet, double d) throws PrismException {
        return this.computeTimeBoundedUntilProbs(cTMC, null, bitSet, d);
    }

    public ModelCheckerResult computeTimeBoundedUntilProbs(CTMC cTMC, BitSet bitSet, BitSet bitSet2, double d) throws PrismException {
        BitSet bitSet3 = null;
        if (bitSet != null) {
            bitSet3 = (BitSet)bitSet.clone();
            bitSet3.andNot(bitSet2);
        }
        ModelCheckerResult modelCheckerResult = this.computeTransientBackwardsProbs(cTMC, bitSet2, bitSet3, d, null);
        int n = cTMC.getNumStates();
        for (int i = 0; i < n; ++i) {
            if (!bitSet2.get(i)) continue;
            modelCheckerResult.soln[i] = 1.0;
        }
        return modelCheckerResult;
    }

    public ModelCheckerResult computeTransientBackwardsProbs(CTMC cTMC, BitSet bitSet, BitSet bitSet2, double d, double[] dArray) throws PrismException {
        int n;
        int n2;
        ModelCheckerResult modelCheckerResult = null;
        if ((bitSet2 != null && bitSet2.isEmpty() || d == 0.0) && dArray == null) {
            modelCheckerResult = new ModelCheckerResult();
            modelCheckerResult.soln = Utils.bitsetToDoubleArray(bitSet, cTMC.getNumStates());
            return modelCheckerResult;
        }
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting backwards transient probability computation...");
        int n3 = cTMC.getNumStates();
        double d2 = cTMC.getDefaultUniformisationRate(bitSet2);
        double d3 = d2 * d;
        this.mainLog.println("\nUniformisation: q.t = " + d2 + " x " + d + " = " + d3);
        double d4 = this.termCritParam / 8.0;
        FoxGlynn foxGlynn = new FoxGlynn(d3, 1.0E-300, 1.0E300, d4);
        int n4 = foxGlynn.getLeftTruncationPoint();
        int n5 = foxGlynn.getRightTruncationPoint();
        if (n5 < 0) {
            throw new PrismException("Overflow in Fox-Glynn computation (time bound too big?)");
        }
        double[] dArray2 = foxGlynn.getWeights();
        double d5 = foxGlynn.getTotalWeight();
        for (n2 = n4; n2 <= n5; ++n2) {
            int n6 = n2 - n4;
            dArray2[n6] = dArray2[n6] / d5;
        }
        this.mainLog.println("Fox-Glynn (" + d4 + "): left = " + n4 + ", right = " + n5);
        DTMC dTMC = cTMC.buildImplicitUniformisedDTMC(d2);
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        double[] dArray5 = new double[n3];
        if (dArray != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray4[n2] = bitSet.get(n2) ? dArray[n2] : 0.0;
                dArray3[n2] = dArray4[n2];
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray4[n2] = bitSet.get(n2) ? 1.0 : 0.0;
                dArray3[n2] = dArray4[n2];
            }
        }
        if (n4 == 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                int n7 = n2;
                dArray5[n7] = dArray5[n7] + dArray2[0] * dArray3[n2];
            }
        }
        for (n = 1; n <= n5; ++n) {
            dTMC.mvMult(dArray3, dArray4, bitSet2, false);
            double[] dArray6 = dArray3;
            dArray3 = dArray4;
            dArray4 = dArray6;
            if (n < n4) continue;
            for (n2 = 0; n2 < n3; ++n2) {
                int n8 = n2;
                dArray5[n8] = dArray5[n8] + dArray2[n - n4] * dArray3[n2];
            }
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Backwards transient probability computation");
        this.mainLog.println(" took " + n + " iters and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray5;
        modelCheckerResult.lastSoln = dArray4;
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = 0.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeCumulativeRewards(CTMC cTMC, MCRewards mCRewards, double d) throws PrismException {
        int n;
        int n2;
        ModelCheckerResult modelCheckerResult = null;
        if (d == 0.0) {
            modelCheckerResult = new ModelCheckerResult();
            modelCheckerResult.soln = new double[cTMC.getNumStates()];
            return modelCheckerResult;
        }
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting backwards cumulative rewards computation...");
        int n3 = cTMC.getNumStates();
        double d2 = cTMC.getDefaultUniformisationRate();
        double d3 = d2 * d;
        this.mainLog.println("\nUniformisation: q.t = " + d2 + " x " + d + " = " + d3);
        double d4 = this.termCritParam / 8.0;
        FoxGlynn foxGlynn = new FoxGlynn(d3, 1.0E-300, 1.0E300, d4);
        int n4 = foxGlynn.getLeftTruncationPoint();
        int n5 = foxGlynn.getRightTruncationPoint();
        if (n5 < 0) {
            throw new PrismException("Overflow in Fox-Glynn computation (time bound too big?)");
        }
        double[] dArray = foxGlynn.getWeights();
        double d5 = foxGlynn.getTotalWeight();
        for (n2 = n4; n2 <= n5; ++n2) {
            int n6 = n2 - n4;
            dArray[n6] = dArray[n6] / d5;
        }
        for (n2 = n4 + 1; n2 <= n5; ++n2) {
            int n7 = n2 - n4;
            dArray[n7] = dArray[n7] + dArray[n2 - 1 - n4];
        }
        for (n2 = n4; n2 <= n5; ++n2) {
            dArray[n2 - n4] = (1.0 - dArray[n2 - n4]) / d2;
        }
        this.mainLog.println("Fox-Glynn (" + d4 + "): left = " + n4 + ", right = " + n5);
        DTMC dTMC = cTMC.buildImplicitUniformisedDTMC(d2);
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[n2] = mCRewards.getStateReward(n2);
        }
        double[] dArray4 = new double[n3];
        if (n4 == 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                int n8 = n2;
                dArray4[n8] = dArray4[n8] + dArray[0] * dArray2[n2];
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                int n9 = n2;
                dArray4[n9] = dArray4[n9] + dArray2[n2] / d2;
            }
        }
        for (n = 1; n <= n5; ++n) {
            dTMC.mvMult(dArray2, dArray3, null, false);
            double[] dArray5 = dArray2;
            dArray2 = dArray3;
            dArray3 = dArray5;
            if (n >= n4) {
                for (n2 = 0; n2 < n3; ++n2) {
                    int n10 = n2;
                    dArray4[n10] = dArray4[n10] + dArray[n - n4] * dArray2[n2];
                }
                continue;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                int n11 = n2;
                dArray4[n11] = dArray4[n11] + dArray2[n2] / d2;
            }
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Backwards transient cumulative rewards computation");
        this.mainLog.println(" took " + n + " iters and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray4;
        modelCheckerResult.lastSoln = dArray3;
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = 0.0;
        return modelCheckerResult;
    }

    @Override
    public ModelCheckerResult computeInstantaneousRewards(DTMC dTMC, MCRewards mCRewards, double d) throws PrismException {
        int n;
        int n2;
        ModelCheckerResult modelCheckerResult = null;
        int n3 = dTMC.getNumStates();
        if (d == 0.0) {
            modelCheckerResult = new ModelCheckerResult();
            modelCheckerResult.soln = new double[dTMC.getNumStates()];
            for (int i = 0; i < n3; ++i) {
                modelCheckerResult.soln[i] = mCRewards.getStateReward(i);
            }
            return modelCheckerResult;
        }
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting backwards instantaneous rewards computation...");
        CTMC cTMC = (CTMC)dTMC;
        double d2 = cTMC.getDefaultUniformisationRate();
        double d3 = d2 * d;
        this.mainLog.println("\nUniformisation: q.t = " + d2 + " x " + d + " = " + d3);
        double d4 = this.termCritParam / 8.0;
        FoxGlynn foxGlynn = new FoxGlynn(d3, 1.0E-300, 1.0E300, d4);
        int n4 = foxGlynn.getLeftTruncationPoint();
        int n5 = foxGlynn.getRightTruncationPoint();
        if (n5 < 0) {
            throw new PrismException("Overflow in Fox-Glynn computation (time bound too big?)");
        }
        double[] dArray = foxGlynn.getWeights();
        double d5 = foxGlynn.getTotalWeight();
        for (n2 = n4; n2 <= n5; ++n2) {
            int n6 = n2 - n4;
            dArray[n6] = dArray[n6] / d5;
        }
        this.mainLog.println("Fox-Glynn (" + d4 + "): left = " + n4 + ", right = " + n5);
        dTMC = cTMC.buildImplicitUniformisedDTMC(d2);
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[n2] = mCRewards.getStateReward(n2);
        }
        double[] dArray4 = new double[n3];
        if (n4 == 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                int n7 = n2;
                dArray4[n7] = dArray4[n7] + dArray[0] * dArray2[n2];
            }
        }
        for (n = 1; n <= n5; ++n) {
            dTMC.mvMult(dArray2, dArray3, null, false);
            double[] dArray5 = dArray2;
            dArray2 = dArray3;
            dArray3 = dArray5;
            if (n < n4) continue;
            for (n2 = 0; n2 < n3; ++n2) {
                int n8 = n2;
                dArray4[n8] = dArray4[n8] + dArray[n - n4] * dArray2[n2];
            }
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Backwards transient instantaneous rewards computation");
        this.mainLog.println(" took " + n + " iters and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray4;
        modelCheckerResult.lastSoln = dArray3;
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = 0.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeReachRewards(CTMC cTMC, MCRewards mCRewards, BitSet bitSet) throws PrismException {
        this.mainLog.println("Building embedded DTMC...");
        DTMC dTMC = cTMC.getImplicitEmbeddedDTMC();
        int n = cTMC.getNumStates();
        StateRewardsArray stateRewardsArray = new StateRewardsArray(n);
        for (int i = 0; i < n; ++i) {
            stateRewardsArray.setStateReward(i, mCRewards.getStateReward(i) / cTMC.getExitRate(i));
        }
        return super.computeReachRewards(dTMC, stateRewardsArray, bitSet);
    }

    public ModelCheckerResult computeTransientProbs(CTMC cTMC, double d, double[] dArray) throws PrismException {
        int n;
        int n2;
        ModelCheckerResult modelCheckerResult = null;
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting transient probability computation...");
        int n3 = cTMC.getNumStates();
        double d2 = cTMC.getDefaultUniformisationRate();
        double d3 = d2 * d;
        this.mainLog.println("\nUniformisation: q.t = " + d2 + " x " + d + " = " + d3);
        this.termCritParam = 1.0E-6;
        double d4 = this.termCritParam / 8.0;
        FoxGlynn foxGlynn = new FoxGlynn(d3, 1.0E-300, 1.0E300, d4);
        int n4 = foxGlynn.getLeftTruncationPoint();
        int n5 = foxGlynn.getRightTruncationPoint();
        if (n5 < 0) {
            throw new PrismException("Overflow in Fox-Glynn computation (time bound too big?)");
        }
        double[] dArray2 = foxGlynn.getWeights();
        double d5 = foxGlynn.getTotalWeight();
        for (n2 = n4; n2 <= n5; ++n2) {
            int n6 = n2 - n4;
            dArray2[n6] = dArray2[n6] / d5;
        }
        this.mainLog.println("Fox-Glynn (" + d4 + "): left = " + n4 + ", right = " + n5);
        DTMC dTMC = cTMC.buildImplicitUniformisedDTMC(d2);
        double[] dArray3 = dArray;
        double[] dArray4 = new double[n3];
        double[] dArray5 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray5[n2] = 0.0;
        }
        if (n4 == 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                int n7 = n2;
                dArray5[n7] = dArray5[n7] + dArray2[0] * dArray3[n2];
            }
        }
        for (n = 1; n <= n5; ++n) {
            dTMC.vmMult(dArray3, dArray4);
            double[] dArray6 = dArray3;
            dArray3 = dArray4;
            dArray4 = dArray6;
            if (n < n4) continue;
            for (n2 = 0; n2 < n3; ++n2) {
                int n8 = n2;
                dArray5[n8] = dArray5[n8] + dArray2[n - n4] * dArray3[n2];
            }
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Transient probability computation");
        this.mainLog.println(" took " + n + " iters and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray5;
        modelCheckerResult.lastSoln = dArray4;
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = 0.0;
        return modelCheckerResult;
    }

    public static void main(String[] stringArray) {
        try {
            CTMCModelChecker cTMCModelChecker = new CTMCModelChecker(null);
            CTMCSimple cTMCSimple = new CTMCSimple();
            cTMCSimple.buildFromPrismExplicit(stringArray[0]);
            Map<String, BitSet> map = cTMCModelChecker.loadLabelsFile(stringArray[1]);
            BitSet bitSet = map.get(stringArray[2]);
            if (bitSet == null) {
                throw new PrismException("Unknown label \"" + stringArray[2] + "\"");
            }
            for (int i = 4; i < stringArray.length; ++i) {
                if (!stringArray[i].equals("-nopre")) continue;
                cTMCModelChecker.setPrecomp(false);
            }
            ModelCheckerResult modelCheckerResult = cTMCModelChecker.computeTimeBoundedReachProbs(cTMCSimple, bitSet, Double.parseDouble(stringArray[3]));
            System.out.println(modelCheckerResult.soln[0]);
        }
        catch (PrismException prismException) {
            System.out.println(prismException);
        }
    }
}

