/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.FoxGlynn;
import java.util.ArrayList;
import prism.PrismException;

public class BirthProcess {
    double unifRate;
    double epsilon = 1.0E-7;
    double time;
    double[] probs;
    double[] newProbs;
    boolean withRateArray = true;
    ArrayList<Double> jumpRates;
    boolean initialising = true;
    int stageNr = 0;
    boolean avoidBirthComputation = true;

    public void setWithRateArray(boolean bl) {
        if (!this.initialising) {
            throw new IllegalArgumentException("this method might not be called after calculateNextRate");
        }
        this.withRateArray = bl;
    }

    public void setTime(double d) {
        if (!this.initialising) {
            throw new IllegalArgumentException("this method might not be called after calculateNextRate");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("time must be nonnegative");
        }
        this.time = d;
    }

    public void setEpsilon(double d) {
        if (!this.initialising) {
            throw new IllegalArgumentException("this method might not be called after calculateNextRate");
        }
        this.epsilon = d;
    }

    public void setAvoidBirthComputation(boolean bl) {
        if (!this.initialising) {
            throw new IllegalArgumentException("this method might not be called after calculateNextRate");
        }
        this.avoidBirthComputation = bl;
    }

    public double calculateNextProb(double d) throws PrismException {
        if (this.initialising && 0.0 == this.unifRate && !this.withRateArray) {
            throw new IllegalArgumentException("unifRate must be set if withRateArray is false");
        }
        if (this.withRateArray && this.initialising) {
            this.jumpRates = new ArrayList();
        }
        this.initialising = false;
        if (!this.withRateArray && d > this.unifRate) {
            throw new IllegalArgumentException("cannot use rates larger than initial rate if withRateArray is false");
        }
        if (this.withRateArray) {
            this.jumpRates.add(d);
        }
        boolean bl = false;
        if (d > this.unifRate) {
            if (!this.avoidBirthComputation) {
                bl = true;
                this.unifRate = d * 1.25 * 1.02;
            } else {
                this.unifRate = d;
            }
        }
        if (this.jumpRates.size() != 1 && Math.abs(d - this.jumpRates.get(this.jumpRates.size() - 2)) > 1.0E-100) {
            if (this.avoidBirthComputation) {
                bl = true;
            }
            this.avoidBirthComputation = false;
        }
        if (null == this.probs || bl) {
            this.initPoisson();
        }
        double d2 = 0.0;
        if (bl) {
            this.stageNr = 0;
            while (this.stageNr < this.jumpRates.size()) {
                d2 = this.compNextStageProb(this.jumpRates.get(this.stageNr));
                ++this.stageNr;
            }
        } else if (this.avoidBirthComputation) {
            d2 = this.stageNr < this.probs.length ? this.probs[this.stageNr] : 0.0;
            ++this.stageNr;
        } else {
            d2 = this.compNextStageProb(d);
            ++this.stageNr;
        }
        return d2;
    }

    private double compNextStageProb(double d) {
        int n;
        assert (d > 0.0);
        double d2 = d / this.unifRate;
        double d3 = 1.0 - d2;
        double d4 = 0.0;
        double d5 = 1.0;
        for (n = 0; n < this.probs.length; ++n) {
            d4 += d5 * this.probs[n];
            d5 *= d3;
        }
        this.newProbs[this.newProbs.length - 1] = 0.0;
        for (n = this.probs.length - 1; n >= 1; --n) {
            this.newProbs[n - 1] = this.newProbs[n] * d3 + this.probs[n] * d2;
        }
        double[] dArray = this.probs;
        this.probs = this.newProbs;
        this.newProbs = dArray;
        return d4;
    }

    private void initPoisson() throws PrismException {
        long l;
        double[] dArray;
        double d;
        long l2;
        long l3;
        double d2 = this.unifRate * this.time;
        double d3 = this.epsilon / 8.0;
        if (this.unifRate * this.time == 0.0) {
            l3 = 0L;
            l2 = 0L;
            d = 1.0;
            dArray = new double[]{1.0};
        } else {
            FoxGlynn foxGlynn = new FoxGlynn(d2, 1.0E-300, 1.0E300, d3);
            l3 = foxGlynn.getLeftTruncationPoint();
            l2 = foxGlynn.getRightTruncationPoint();
            if (l2 < 0L || l2 == Integer.MAX_VALUE) {
                throw new PrismException("Overflow in Fox-Glynn computation (time bound too big?)");
            }
            dArray = foxGlynn.getWeights();
            d = foxGlynn.getTotalWeight();
        }
        for (l = l3; l <= l2; ++l) {
            int n = (int)(l - l3);
            dArray[n] = dArray[n] / d;
        }
        this.probs = new double[(int)(l2 + 1L)];
        this.newProbs = new double[(int)(l2 + 1L)];
        for (l = l3; l <= l2; ++l) {
            this.probs[(int)l] = dArray[(int)(l - l3)];
        }
    }
}

