/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.IterableBitSet;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IterableStateSet
implements Iterable<Integer> {
    private BitSet setOfStates;
    private Integer numStates = null;
    private boolean complement = false;

    public IterableStateSet(int n) {
        this(null, n, false);
    }

    public IterableStateSet(BitSet bitSet, int n) {
        this(bitSet, n, false);
    }

    public IterableStateSet(BitSet bitSet, int n, boolean bl) {
        this.setOfStates = bitSet;
        this.numStates = n;
        this.complement = bl;
    }

    @Override
    public Iterator<Integer> iterator() {
        if (this.setOfStates == null) {
            if (!this.complement) {
                return new AllStatesIterator();
            }
            return new NoStatesIterator();
        }
        return new IterableBitSet(this.setOfStates, this.numStates - 1, this.complement).iterator();
    }

    public static void main(String[] stringArray) {
        BitSet bitSet = new BitSet();
        bitSet.set(1);
        bitSet.set(3);
        int n = 5;
        System.out.println("\n" + bitSet + " - included states:");
        for (Integer n2 : new IterableStateSet(bitSet, n)) {
            System.out.println(n2);
        }
        System.out.println("\n" + bitSet + " - excluded states:");
        for (Integer n2 : new IterableStateSet(bitSet, n, true)) {
            System.out.println(n2);
        }
        System.out.println("\nAll " + n + " states:");
        for (Integer n2 : new IterableStateSet(null, n)) {
            System.out.println(n2);
        }
        System.out.println("\nNo " + n + " states:");
        for (Integer n2 : new IterableStateSet(null, n, true)) {
            System.out.println(n2);
        }
    }

    private class NoStatesIterator
    implements Iterator<Integer> {
        private NoStatesIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Integer next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class AllStatesIterator
    implements Iterator<Integer> {
        private int current = 0;

        private AllStatesIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current < IterableStateSet.this.numStates;
        }

        @Override
        public Integer next() {
            if (this.hasNext()) {
                return this.current++;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

