/*
 * Decompiled with CFR 0.152.
 */
package automata;

import acceptance.AcceptanceOmega;
import acceptance.AcceptanceRabin;
import acceptance.AcceptanceType;
import automata.DA;
import automata.DASimplifyAcceptance;
import automata.HOAF2DA;
import automata.LTL2RabinLibrary;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAIntermediateStoreAndManipulate;
import jhoafparser.parser.HOAFParser;
import jhoafparser.parser.generated.ParseException;
import jhoafparser.storage.StoredAutomatonManipulator;
import jhoafparser.transformations.ToStateAcceptance;
import jltl2ba.APSet;
import jltl2ba.SimpleLTL;
import jltl2dstar.LTL2Rabin;
import parser.Values;
import parser.ast.Expression;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismNotSupportedException;

public class LTL2DA
extends PrismComponent {
    public LTL2DA(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    public DA<BitSet, AcceptanceRabin> convertLTLFormulaToDRA(Expression expression, Values values) throws PrismException {
        return this.convertLTLFormulaToDA(expression, values, AcceptanceType.RABIN);
    }

    public DA<BitSet, ? extends AcceptanceOmega> convertLTLFormulaToDA(Expression expression, Values values, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        DA<BitSet, AcceptanceOmega> dA = null;
        boolean bl = this.useExternal();
        boolean bl2 = Expression.containsTemporalTimeBounds(expression);
        if (bl2) {
            bl = false;
        }
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.RABIN) && !bl) {
            try {
                dA = LTL2RabinLibrary.getDRAforLTL(expression, values);
                if (dA != null) {
                    this.getLog().println("Taking deterministic Rabin automaton from library...");
                }
            }
            catch (Exception exception) {
                if (bl2) {
                    throw exception;
                }
                this.getLog().println("Warning: Exception during attempt to construct DRA using the LTL2RabinLibrary:");
                this.getLog().println(" " + exception.getMessage());
            }
        }
        if (dA == null && !bl2) {
            dA = bl ? this.convertLTLFormulaToDAWithExternalTool(expression, values, acceptanceTypeArray) : LTL2Rabin.ltl2da(expression.convertForJltl2ba(), acceptanceTypeArray);
        }
        if (dA == null) {
            throw new PrismNotSupportedException("Could not convert LTL formula to deterministic automaton");
        }
        dA = DASimplifyAcceptance.simplifyAcceptance(dA, acceptanceTypeArray);
        return dA;
    }

    public DA<BitSet, ? extends AcceptanceOmega> convertLTLFormulaToDAWithExternalTool(Expression expression, Values values, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        Object object;
        String string = this.getSettings().getString("prism.ltl2daTool");
        SimpleLTL simpleLTL = expression.convertForJltl2ba();
        SimpleLTL simpleLTL2 = simpleLTL.clone();
        simpleLTL2.renameAP("L", "p");
        DA<BitSet, ? extends AcceptanceOmega> dA = null;
        try {
            int n;
            String string2;
            object = this.getSettings().getString("prism.ltl2daSyntax");
            if (object == null || ((String)object).isEmpty()) {
                throw new PrismException("No LTL syntax option provided");
            }
            switch (object) {
                case "LBT": {
                    string2 = simpleLTL2.toStringLBT();
                    break;
                }
                case "Spin": {
                    string2 = simpleLTL2.toStringSpin();
                    break;
                }
                case "Spot": {
                    string2 = simpleLTL2.toStringSpot();
                    break;
                }
                case "Rabinizer": {
                    simpleLTL2 = simpleLTL2.toBasicOperators();
                    string2 = simpleLTL2.toStringSpot();
                    break;
                }
                default: {
                    throw new PrismException("Unknown LTL syntax option \"" + (String)object + "\"");
                }
            }
            Object object3 = File.createTempFile("prism-ltl-external-", ".ltl", null);
            File file = File.createTempFile("prism-ltl-external-", ".hoa", null);
            File file2 = File.createTempFile("prism-ltl-external-", ".output", null);
            FileWriter fileWriter = new FileWriter((File)object3);
            fileWriter.write(string2);
            fileWriter.close();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.getLog().print("Calling external LTL->DA tool: ");
            for (String object22 : arrayList) {
                this.getLog().print(" " + object22);
            }
            this.getLog().println();
            this.getLog().print("LTL formula (in " + (String)object + " syntax):  ");
            this.getLog().println(string2);
            this.getLog().println();
            arrayList.add(((File)object3).getAbsolutePath());
            arrayList.add(file.getAbsolutePath());
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            processBuilder.redirectOutput(file2);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            process.getInputStream().close();
            while (true) {
                try {
                    n = process.waitFor();
                }
                catch (InterruptedException object6) {
                    continue;
                }
                break;
            }
            if (n != 0) {
                throw new PrismException("Call to external LTL->DA tool failed, return value = " + n + ".\n" + "To investigate, please consult the following files:" + "\n LTL formula:                     " + ((File)object3).getAbsolutePath() + "\n Automaton output:                " + file.getAbsolutePath() + "\n Tool output (stdout and stderr): " + file2.getAbsolutePath() + "\n");
            }
            file2.delete();
            try {
                Object object2;
                Object i;
                Object transitionBasedAcceptanceException;
                try {
                    transitionBasedAcceptanceException = new HOAF2DA();
                    i = new FileInputStream(file);
                    HOAFParser.parseHOA((InputStream)i, (HOAConsumer)transitionBasedAcceptanceException);
                    dA = ((HOAF2DA)transitionBasedAcceptanceException).getDA();
                }
                catch (HOAF2DA.TransitionBasedAcceptanceException parseException) {
                    this.getLog().println("Automaton with transition-based acceptance, automatically converting to state-based acceptance...");
                    i = new HOAF2DA();
                    object2 = new HOAIntermediateStoreAndManipulate((HOAConsumer)i, new StoredAutomatonManipulator[]{new ToStateAcceptance()});
                    FileInputStream fileInputStream = new FileInputStream(file);
                    HOAFParser.parseHOA((InputStream)fileInputStream, (HOAConsumer)object2);
                    dA = ((HOAF2DA)i).getDA();
                }
                if (dA == null) {
                    throw new PrismException("Could not construct DA");
                }
                this.checkAPs(simpleLTL2, dA.getAPList());
                transitionBasedAcceptanceException = dA.getAPList();
                for (int j = 0; j < transitionBasedAcceptanceException.size(); ++j) {
                    if (!((String)transitionBasedAcceptanceException.get(j)).startsWith("p")) continue;
                    object2 = "L" + ((String)transitionBasedAcceptanceException.get(j)).substring("p".length());
                    transitionBasedAcceptanceException.set(j, object2);
                }
            }
            catch (ParseException prismException) {
                throw new PrismException("Parse error: " + prismException.getMessage() + ".\n" + "To investigate, please consult the following files:\n" + " LTL formula:        " + ((File)object3).getAbsolutePath() + "\n Automaton output: " + file.getAbsolutePath() + "\n");
            }
            catch (PrismException prismException) {
                throw new PrismException(prismException.getMessage() + ".\n" + "To investigate, please consult the following files:" + "\n LTL formula: " + ((File)object3).getAbsolutePath() + "\n Automaton output: " + file.getAbsolutePath() + "\n");
            }
            file.delete();
            ((File)object3).delete();
        }
        catch (IOException iOException) {
            throw new PrismException(iOException.getMessage());
        }
        object = dA.getAcceptance();
        if (AcceptanceType.contains(acceptanceTypeArray, object.getType())) {
            return dA;
        }
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.GENERIC)) {
            DA.switchAcceptance(dA, object.toAcceptanceGeneric());
            return dA;
        }
        throw new PrismException("The external LTL->DA tool returned an automaton with " + object.getTypeName() + " acceptance, which is not yet supported for model checking this model / property");
    }

    private boolean useExternal() {
        String string = this.getSettings().getString("prism.ltl2daTool");
        return string != null && !string.isEmpty();
    }

    private void checkAPs(SimpleLTL simpleLTL, List<String> list) throws PrismException {
        APSet aPSet = simpleLTL.getAPs();
        for (String string : list) {
            if (aPSet.hasAP(string)) continue;
            throw new PrismException("Generated automaton has extra atomic proposition \"" + string + "\"");
        }
    }
}

