/*
 * Decompiled with CFR 0.152.
 */
package acceptance;

import acceptance.AcceptanceOmegaDD;
import acceptance.AcceptanceReach;
import acceptance.AcceptanceType;
import common.IterableBitSet;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;

public class AcceptanceReachDD
implements AcceptanceOmegaDD {
    private JDDNode goalStates;

    public AcceptanceReachDD(JDDNode jDDNode) {
        this.goalStates = jDDNode;
    }

    public AcceptanceReachDD(AcceptanceReach acceptanceReach, JDDVars jDDVars) {
        this.goalStates = JDD.Constant(0.0);
        for (int n : IterableBitSet.getSetBits(acceptanceReach.getGoalStates())) {
            this.goalStates = JDD.SetVectorElement(this.goalStates, jDDVars, n, 1.0);
        }
    }

    public JDDNode getGoalStates() {
        JDD.Ref(this.goalStates);
        return this.goalStates;
    }

    public void setGoalStates(JDDNode jDDNode) {
        this.clear();
        this.goalStates = jDDNode;
    }

    @Override
    public boolean isBSCCAccepting(JDDNode jDDNode) {
        return JDD.AreIntersecting(this.goalStates, jDDNode);
    }

    @Override
    public String getSizeStatistics() {
        return "one set of goal states";
    }

    @Override
    public AcceptanceType getType() {
        return AcceptanceType.REACH;
    }

    @Override
    public String getTypeAbbreviated() {
        return "F";
    }

    @Override
    public String getTypeName() {
        return "Finite";
    }

    @Override
    public void clear() {
        if (this.goalStates != null) {
            JDD.Deref(this.goalStates);
        }
    }
}

