/*
 * Decompiled with CFR 0.152.
 */
package acceptance;

import acceptance.AcceptanceGeneric;
import acceptance.AcceptanceOmega;
import acceptance.AcceptanceReachDD;
import acceptance.AcceptanceType;
import java.util.BitSet;
import jdd.JDDVars;

public class AcceptanceReach
implements AcceptanceOmega {
    private BitSet goalStates = new BitSet();

    public AcceptanceReach() {
    }

    public AcceptanceReach(BitSet bitSet) {
        this.goalStates = bitSet;
    }

    public BitSet getGoalStates() {
        return this.goalStates;
    }

    public void setGoalStates(BitSet bitSet) {
        this.goalStates = bitSet;
    }

    @Override
    public AcceptanceReach clone() {
        return new AcceptanceReach((BitSet)this.goalStates.clone());
    }

    @Override
    public boolean isBSCCAccepting(BitSet bitSet) {
        return bitSet.intersects(this.goalStates);
    }

    @Override
    public void lift(AcceptanceOmega.LiftBitSet liftBitSet) {
        this.goalStates = liftBitSet.lift(this.goalStates);
    }

    @Override
    public AcceptanceReachDD toAcceptanceDD(JDDVars jDDVars) {
        return new AcceptanceReachDD(this, jDDVars);
    }

    @Override
    public AcceptanceGeneric toAcceptanceGeneric() {
        return new AcceptanceGeneric(AcceptanceGeneric.ElementType.INF, (BitSet)this.goalStates.clone());
    }

    @Override
    public String getSignatureForState(int n) {
        return this.goalStates.get(n) ? "!" : " ";
    }

    public String toString() {
        return this.goalStates.toString();
    }

    @Override
    public String getSizeStatistics() {
        return this.goalStates.cardinality() + " goal states";
    }

    @Override
    public AcceptanceType getType() {
        return AcceptanceType.REACH;
    }

    @Override
    public String getTypeAbbreviated() {
        return "F";
    }

    @Override
    public String getTypeName() {
        return "Finite";
    }
}

