/*
 * Decompiled with CFR 0.152.
 */
package acceptance;

import acceptance.AcceptanceOmegaDD;
import acceptance.AcceptanceRabin;
import acceptance.AcceptanceType;
import common.IterableBitSet;
import java.util.ArrayList;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;

public class AcceptanceRabinDD
extends ArrayList<RabinPairDD>
implements AcceptanceOmegaDD {
    public AcceptanceRabinDD(AcceptanceRabin acceptanceRabin, JDDVars jDDVars) {
        for (AcceptanceRabin.RabinPair rabinPair : acceptanceRabin) {
            JDDNode jDDNode = JDD.Constant(0.0);
            Object object = IterableBitSet.getSetBits(rabinPair.getL()).iterator();
            while (object.hasNext()) {
                int n = object.next();
                jDDNode = JDD.SetVectorElement(jDDNode, jDDVars, n, 1.0);
            }
            object = JDD.Constant(0.0);
            Object object2 = IterableBitSet.getSetBits(rabinPair.getK()).iterator();
            while (object2.hasNext()) {
                int n = object2.next();
                object = JDD.SetVectorElement((JDDNode)object, jDDVars, n, 1.0);
            }
            object2 = new RabinPairDD(jDDNode, (JDDNode)object);
            this.add(object2);
        }
    }

    @Override
    public boolean isBSCCAccepting(JDDNode jDDNode) {
        for (RabinPairDD rabinPairDD : this) {
            if (!rabinPairDD.isBSCCAccepting(jDDNode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (RabinPairDD rabinPairDD : this) {
            rabinPairDD.clear();
        }
        super.clear();
    }

    @Override
    public String toString() {
        String string = "";
        for (RabinPairDD rabinPairDD : this) {
            string = string + rabinPairDD.toString();
        }
        return string;
    }

    @Override
    public String getSizeStatistics() {
        return this.size() + " Rabin pairs";
    }

    @Override
    public AcceptanceType getType() {
        return AcceptanceType.RABIN;
    }

    @Override
    public String getTypeAbbreviated() {
        return "R";
    }

    @Override
    public String getTypeName() {
        return "Rabin";
    }

    public static class RabinPairDD {
        private JDDNode L;
        private JDDNode K;

        public RabinPairDD(JDDNode jDDNode, JDDNode jDDNode2) {
            this.L = jDDNode;
            this.K = jDDNode2;
        }

        public void clear() {
            if (this.L != null) {
                JDD.Deref(this.L);
            }
            if (this.K != null) {
                JDD.Deref(this.K);
            }
        }

        public JDDNode getL() {
            JDD.Ref(this.L);
            return this.L;
        }

        public JDDNode getK() {
            JDD.Ref(this.K);
            return this.K;
        }

        public boolean isBSCCAccepting(JDDNode jDDNode) {
            if (JDD.AreIntersecting(this.L, jDDNode)) {
                return false;
            }
            return JDD.AreIntersecting(this.K, jDDNode);
        }

        public String toString() {
            return "(" + this.L + "," + this.K + ")";
        }
    }
}

