/*
 * Decompiled with CFR 0.152.
 */
package acceptance;

import acceptance.AcceptanceGenericDD;
import acceptance.AcceptanceOmega;
import acceptance.AcceptanceOmegaDD;
import acceptance.AcceptanceType;
import java.util.BitSet;
import jdd.JDDVars;

public class AcceptanceGeneric
implements AcceptanceOmega {
    private ElementType kind;
    private AcceptanceGeneric left = null;
    private AcceptanceGeneric right = null;
    private BitSet states = null;

    public AcceptanceGeneric(boolean bl) {
        this.kind = bl ? ElementType.TRUE : ElementType.FALSE;
    }

    public AcceptanceGeneric(ElementType elementType, BitSet bitSet) {
        this.kind = elementType;
        this.states = bitSet;
    }

    public AcceptanceGeneric(ElementType elementType, AcceptanceGeneric acceptanceGeneric, AcceptanceGeneric acceptanceGeneric2) {
        this.kind = elementType;
        this.left = acceptanceGeneric;
        this.right = acceptanceGeneric2;
    }

    public ElementType getKind() {
        return this.kind;
    }

    public AcceptanceGeneric getLeft() {
        return this.left;
    }

    public AcceptanceGeneric getRight() {
        return this.right;
    }

    public BitSet getStates() {
        return this.states;
    }

    @Override
    public boolean isBSCCAccepting(BitSet bitSet) {
        switch (this.kind) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case AND: {
                return this.left.isBSCCAccepting(bitSet) && this.right.isBSCCAccepting(bitSet);
            }
            case OR: {
                return this.left.isBSCCAccepting(bitSet) || this.right.isBSCCAccepting(bitSet);
            }
            case INF: {
                return bitSet.intersects(this.states);
            }
            case INF_NOT: {
                BitSet bitSet2 = (BitSet)bitSet.clone();
                bitSet2.andNot(this.states);
                return !bitSet2.isEmpty();
            }
            case FIN: {
                return !bitSet.intersects(this.states);
            }
            case FIN_NOT: {
                BitSet bitSet3 = (BitSet)bitSet.clone();
                bitSet3.and(this.states);
                return bitSet3.equals(bitSet);
            }
        }
        return false;
    }

    @Override
    public String getSignatureForState(int n) {
        return "";
    }

    @Override
    public String getSizeStatistics() {
        return "generic acceptance with " + this.countAcceptanceSets() + " acceptance sets";
    }

    @Override
    public AcceptanceType getType() {
        return AcceptanceType.GENERIC;
    }

    @Override
    public String getTypeAbbreviated() {
        return "";
    }

    @Override
    public String getTypeName() {
        return "generic";
    }

    @Override
    public AcceptanceGeneric clone() {
        switch (this.kind) {
            case INF: 
            case INF_NOT: 
            case FIN: 
            case FIN_NOT: {
                return new AcceptanceGeneric(this.kind, this.states);
            }
            case AND: 
            case OR: {
                return new AcceptanceGeneric(this.kind, this.left.clone(), this.right.clone());
            }
            case FALSE: {
                return new AcceptanceGeneric(false);
            }
            case TRUE: {
                return new AcceptanceGeneric(true);
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in generic acceptance condition");
    }

    @Override
    public void lift(AcceptanceOmega.LiftBitSet liftBitSet) {
        switch (this.kind) {
            case TRUE: 
            case FALSE: {
                return;
            }
            case INF: 
            case INF_NOT: 
            case FIN: 
            case FIN_NOT: {
                this.states = liftBitSet.lift(this.states);
                return;
            }
            case AND: 
            case OR: {
                this.left.lift(liftBitSet);
                this.right.lift(liftBitSet);
                return;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in generic acceptance condition");
    }

    public int countAcceptanceSets() {
        switch (this.kind) {
            case TRUE: 
            case FALSE: {
                return 0;
            }
            case INF: 
            case INF_NOT: 
            case FIN: 
            case FIN_NOT: {
                return 1;
            }
            case AND: 
            case OR: {
                return this.left.countAcceptanceSets() + this.right.countAcceptanceSets();
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in generic acceptance condition");
    }

    @Override
    public AcceptanceOmegaDD toAcceptanceDD(JDDVars jDDVars) {
        return new AcceptanceGenericDD(this, jDDVars);
    }

    @Override
    public AcceptanceGeneric toAcceptanceGeneric() {
        return this.clone();
    }

    public String toString() {
        switch (this.kind) {
            case TRUE: {
                return "true";
            }
            case FALSE: {
                return "false";
            }
            case AND: {
                return "(" + this.left.toString() + " & " + this.right.toString() + ")";
            }
            case OR: {
                return "(" + this.left.toString() + " | " + this.right.toString() + ")";
            }
            case INF: {
                return "Inf(" + this.states.toString() + ")";
            }
            case FIN: {
                return "Fin(" + this.states.toString() + ")";
            }
            case INF_NOT: {
                return "Inf(!" + this.states.toString() + ")";
            }
            case FIN_NOT: {
                return "Fin(!" + this.states.toString() + ")";
            }
        }
        return null;
    }

    public static enum ElementType {
        FALSE,
        TRUE,
        OR,
        AND,
        INF,
        FIN,
        INF_NOT,
        FIN_NOT;

    }
}

