/*
 * Decompiled with CFR 0.152.
 */
package acceptance;

import acceptance.AcceptanceGenRabin;
import acceptance.AcceptanceOmegaDD;
import acceptance.AcceptanceType;
import common.IterableBitSet;
import java.util.ArrayList;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;

public class AcceptanceGenRabinDD
extends ArrayList<GenRabinPairDD>
implements AcceptanceOmegaDD {
    public AcceptanceGenRabinDD(AcceptanceGenRabin acceptanceGenRabin, JDDVars jDDVars) {
        for (AcceptanceGenRabin.GenRabinPair genRabinPair : acceptanceGenRabin) {
            int n;
            JDDNode jDDNode = JDD.Constant(0.0);
            Object object = IterableBitSet.getSetBits(genRabinPair.getL()).iterator();
            while (object.hasNext()) {
                n = object.next();
                jDDNode = JDD.SetVectorElement(jDDNode, jDDVars, n, 1.0);
            }
            object = new ArrayList();
            n = genRabinPair.getNumK();
            for (int i = 0; i < n; ++i) {
                JDDNode jDDNode2 = JDD.Constant(0.0);
                for (int n2 : IterableBitSet.getSetBits(genRabinPair.getK(i))) {
                    jDDNode2 = JDD.SetVectorElement(jDDNode2, jDDVars, n2, 1.0);
                }
                ((ArrayList)object).add(jDDNode2);
            }
            GenRabinPairDD genRabinPairDD = new GenRabinPairDD(jDDNode, (ArrayList<JDDNode>)object);
            this.add(genRabinPairDD);
        }
    }

    @Override
    public boolean isBSCCAccepting(JDDNode jDDNode) {
        for (GenRabinPairDD genRabinPairDD : this) {
            if (!genRabinPairDD.isBSCCAccepting(jDDNode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (GenRabinPairDD genRabinPairDD : this) {
            genRabinPairDD.clear();
        }
        super.clear();
    }

    @Override
    public String toString() {
        String string = "";
        for (GenRabinPairDD genRabinPairDD : this) {
            string = string + genRabinPairDD.toString();
        }
        return string;
    }

    @Override
    public String getSizeStatistics() {
        return this.size() + " Generalized Rabin pairs";
    }

    @Override
    public AcceptanceType getType() {
        return AcceptanceType.GENERALIZED_RABIN;
    }

    @Override
    public String getTypeAbbreviated() {
        return "GR";
    }

    @Override
    public String getTypeName() {
        return "Generalized Rabin";
    }

    public static class GenRabinPairDD {
        private JDDNode L;
        private ArrayList<JDDNode> K_list;

        public GenRabinPairDD(JDDNode jDDNode, ArrayList<JDDNode> arrayList) {
            this.L = jDDNode;
            this.K_list = arrayList;
        }

        public void clear() {
            if (this.L != null) {
                JDD.Deref(this.L);
            }
            for (JDDNode jDDNode : this.K_list) {
                JDD.Deref(jDDNode);
            }
        }

        public JDDNode getL() {
            JDD.Ref(this.L);
            return this.L;
        }

        public int getNumK() {
            return this.K_list.size();
        }

        public JDDNode getK(int n) {
            JDD.Ref(this.K_list.get(n));
            return this.K_list.get(n);
        }

        public boolean isBSCCAccepting(JDDNode jDDNode) {
            if (JDD.AreIntersecting(this.L, jDDNode)) {
                return false;
            }
            for (JDDNode jDDNode2 : this.K_list) {
                if (JDD.AreIntersecting(jDDNode2, jDDNode)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            String string = "(" + this.L;
            for (JDDNode jDDNode : this.K_list) {
                string = string + "," + jDDNode;
            }
            string = string + ")";
            return string;
        }
    }
}

