/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;

public class ProcessCSV {
    Config config;

    public ProcessCSV(Config c) {
        this.config = c;
    }

    public String Process() {
        String delayBlock = "";
        for (String shortname : this.config.components.keySet()) {
            Component comp = this.config.components.get(shortname);
            try {
                String fileLocation;
                Object outFile;
                File checkFile;
                String tFile = comp.trainingFile;
                if (this.config.multiWhich != -1 && !(checkFile = new File(tFile = comp.trainingFile.replace("#", this.config.multiWhich.toString()))).exists()) {
                    tFile = comp.trainingFile.replace("#", this.config.multiMin.toString());
                }
                if (((File)(outFile = new File(fileLocation = "temp/" + comp.shortName + "Data.csv"))).exists()) {
                    System.out.println("File " + fileLocation + " already exists");
                } else {
                    String line;
                    Integer val = 0;
                    BufferedWriter bw = new BufferedWriter(new FileWriter(fileLocation));
                    BufferedReader br = new BufferedReader(new FileReader(tFile));
                    if (this.config.useDelay.booleanValue()) {
                        while ((line = br.readLine()) != null) {
                            try {
                                val = Integer.parseInt(line);
                                if (comp.traceDelay >= 0 && val >= comp.traceDelay) continue;
                                comp.traceDelay = val;
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Invalid Number format in data file");
                            }
                        }
                        br.close();
                        if ((double)comp.traceDelay.intValue() / 1000.0 < this.config.delayCutoff) {
                            comp.traceDelay = 0;
                            comp.hasDelay = false;
                            System.out.println("**************************** Ignoring Delay *****************************");
                        }
                    }
                    br = new BufferedReader(new FileReader(tFile));
                    System.out.println("Writing " + fileLocation + " for HyperStar fitting");
                    while ((line = br.readLine()) != null) {
                        try {
                            val = Integer.parseInt(line);
                            if (this.config.useDelay.booleanValue() && (comp.hasDelay || comp.preDelay || comp.combine != null)) {
                                val = val - comp.traceDelay + 1;
                            }
                            bw.write(String.valueOf(val.toString()) + "\r\n");
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid Number format in data file");
                        }
                    }
                    br.close();
                    bw.close();
                }
                if (!comp.hasDelay && comp.combine == null && !comp.always) continue;
                delayBlock = String.valueOf(delayBlock) + "const double " + shortname + "Time = " + (double)comp.traceDelay.intValue() / 1000.0 + ";\r\n";
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Boolean delaysRemoved = true;
        for (String shortname : this.config.components.keySet()) {
            Component comp = this.config.components.get(shortname);
            if (!comp.hasDelay) continue;
            delaysRemoved = false;
        }
        if (delaysRemoved.booleanValue()) {
            this.config.useDelay = false;
            delayBlock = "";
        }
        Hashtable<String, String> htCombine = new Hashtable<String, String>();
        String pre = "";
        int preVal = 0;
        for (String shortname : this.config.components.keySet()) {
            Component c = this.config.components.get(shortname);
            if (c.preDelay) {
                pre = String.valueOf(pre) + c.shortName + " ";
                preVal += c.traceDelay.intValue();
            }
            if (c.combine == null) continue;
            String target = "";
            String source = c.shortName;
            Component t = c.combine;
            target = t.shortName;
            while (t.combine != null) {
                target = t.combine.shortName;
                t = t.combine;
            }
            if (htCombine.containsKey(target)) {
                String existing = (String)htCombine.get(target);
                htCombine.put(t.shortName, String.valueOf(existing) + source + " ");
                continue;
            }
            htCombine.put(target, String.valueOf(source) + " ");
        }
        this.config.Display();
        String[] lines = delayBlock.split("\n");
        for (String shortname : htCombine.keySet()) {
            String[] parts = ((String)htCombine.get(shortname)).trim().split(" ");
            int i = 0;
            while (i < lines.length) {
                if (lines[i].contains("const double " + shortname + "Time")) {
                    int j = 0;
                    while (j < parts.length) {
                        String append = " + " + parts[j] + "Time;";
                        lines[i] = lines[i].replaceFirst(";", append);
                        ++j;
                    }
                }
                ++i;
            }
        }
        delayBlock = "";
        int i = 0;
        while (i < lines.length) {
            delayBlock = String.valueOf(delayBlock) + lines[i] + "\n";
            ++i;
        }
        delayBlock = "// Predelay value is sum of : " + pre + " (" + preVal + "/1000)\r\n" + delayBlock;
        return delayBlock;
    }
}

