/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import prism.Prism;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLangException;
import prism.PrismLog;
import prism.Result;

public class PrismInterface {
    private String PROPERTIESFILENAME;
    private final String PRISMOUTPUTFILENAME = "output_Prism.txt";
    private PrismLog mainLog;
    private Prism prism;
    private ModulesFile modulesFile;
    private PropertiesFile propertiesFile;
    public String modelString;
    private File propertyFile;
    private static PrismInterface instance;

    public static PrismInterface getInstance(String propertiesFilename) {
        if (instance == null) {
            instance = new PrismInterface(propertiesFilename);
        }
        return instance;
    }

    public PrismInterface(String propertiesFilename) {
        try {
            this.PROPERTIESFILENAME = propertiesFilename;
            this.propertyFile = new File(this.PROPERTIESFILENAME);
            this.mainLog = new PrismFileLog("output_Prism.txt", false);
            this.prism = new Prism(this.mainLog, this.mainLog);
            this.prism.initialise();
            this.prism.setLinEqMethod(1);
            this.prism.setMaxIters(100000);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    public void reloadProps() {
        try {
            this.propertiesFile = this.prism.parsePropertiesFile(this.modulesFile, this.propertyFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (PrismLangException e) {
            e.printStackTrace();
        }
    }

    public void loadModel(String modelString) {
        try {
            this.modelString = new String(Files.readAllBytes(Paths.get(modelString, new String[0])));
            this.modulesFile = this.prism.parseModelString(this.modelString);
            this.modulesFile.setUndefinedConstants(null);
            this.propertiesFile = this.prism.parsePropertiesFile(this.modulesFile, this.propertyFile);
            this.propertiesFile.setUndefinedConstants(null);
            this.prism.buildModel(this.modulesFile);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    public List<Double> runPrism() {
        ArrayList<Double> results = new ArrayList<Double>();
        try {
            int i = 0;
            while (i < this.propertiesFile.getNumProperties()) {
                Result result = this.prism.modelCheck(this.propertiesFile, this.propertiesFile.getProperty(i));
                if (result.getResult() instanceof Boolean) {
                    boolean boolRes = (Boolean)result.getResult();
                    if (boolRes) {
                        results.add(1.0);
                    } else {
                        results.add(0.0);
                    }
                } else {
                    results.add(Double.parseDouble(result.getResult().toString()));
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Model checking error");
            System.exit(-1);
        }
        return results;
    }

    public void closeDown() {
        if (this.mainLog != null) {
            this.mainLog.close();
        }
    }

    public void getTrans(String fName) {
        try {
            this.prism.exportTransToFile(true, 1, new File("temp/" + fName + ".tra"));
            this.prism.exportStatesToFile(1, new File("temp/" + fName + ".sta"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (PrismException e) {
            e.printStackTrace();
        }
    }
}

