/*
 * Decompiled with CFR 0.152.
 */
public class OmniCmd {
    public static void main(String[] args) {
        System.out.println("Starting OMNI2 version 1.3 --- ");
        System.out.println("Colin Paterson, University of York, 2017 ");
        Config config = new Config();
        config.load();
        do {
            ParseModel parser = new ParseModel(config);
            String ctmc = parser.makeCTMC();
            analyseCTMC engine = new analyseCTMC(1, parser.totalStateCount, config);
            Utility u = new Utility();
            u.writeToFile(ctmc, "temp/ctmc.pm");
            engine.modelFile = "temp/ctmc.pm";
            long startTime = System.nanoTime();
            long midTime = 0L;
            config.clearFitFiles();
            int propCounter = 0;
            while (propCounter < config.properties.length) {
                long propStart = System.nanoTime();
                config.clearIntermediateFiles();
                parser.clearNCStates();
                engine.property = config.properties[propCounter];
                System.out.println("Evaluating property : " + engine.property);
                engine.breakProperty();
                engine.testVisited();
                if (config.useDelay.booleanValue()) {
                    engine.getTrans();
                }
                config.updateComponent(engine.htStates);
                midTime = System.nanoTime();
                long durationM = midTime - startTime;
                ProcessCSV pcsv = new ProcessCSV(config);
                String delayBlock = pcsv.Process();
                System.out.println("New model has " + config.totalStates + " states in the structural model");
                parser.makeTemplate(delayBlock);
                Refine r = new Refine(config);
                r.start(false);
                ModelBuilder m = new ModelBuilder(config);
                String oFile = config.outFile.replace("{P#}", "P" + propCounter);
                if (config.multiWhich >= 0) {
                    oFile = oFile.replace("{M#}", "M" + config.multiWhich);
                }
                m.Build(oFile);
                long propEnd = System.nanoTime();
                System.out.println("Prop " + propCounter + ": analyse Time (ms) " + (midTime - propStart) / 1000000L + ": refine Time (ms) " + (propEnd - midTime) / 1000000L);
                ++propCounter;
            }
            long endTime = System.nanoTime();
            long durationC = endTime - startTime;
            System.out.println("Model Complete --- " + durationC / 1000000000L);
            config.resetComponents();
        } while (config.incMulti().booleanValue());
        System.out.println("Complete --- ");
    }
}

