/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ExecuteHS {
    public String HSLocation;
    public String trainingFile;
    public int branches;
    public int length;
    public Integer maxTiming = 0;
    private TimingData td;
    public Double CDF;

    public void initTmingData() {
        this.td = new TimingData();
        this.td.read("temp/" + this.trainingFile, false);
        this.maxTiming = this.td.maxValue;
    }

    public void run(final Boolean diag, String outFile) throws IOException, InterruptedException {
        String cmd = "java -jar " + this.HSLocation + " -cli -f temp/" + this.trainingFile + " -of " + outFile + " -bn " + this.branches + " -ep " + this.length + " -qu > temp/HSDump.txt";
        final Process p = Runtime.getRuntime().exec(cmd);
        new Thread(new Runnable(){

            @Override
            public void run() {
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = null;
                try {
                    while ((line = input.readLine()) != null) {
                        if (!diag.booleanValue()) continue;
                        System.out.println(line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
        p.waitFor();
        this.extractCDF(outFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractCDF(String fileName) {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try {
                BufferedReader br = new BufferedReader(new FileReader(fileName));
                try {
                    String line;
                    do {
                        if ((line = br.readLine()) != null) continue;
                        return;
                    } while (!line.contains("cdf-difference"));
                    this.lineToCDF(line);
                    return;
                }
                finally {
                    if (br == null) return;
                    br.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found : out_fit.txt in extractCDF");
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            System.err.println("Error in reading fitting data in extractCDF");
            e.printStackTrace();
        }
    }

    private void lineToCDF(String line) {
        String s = line.split(":")[1];
        this.CDF = (s = s.trim()).equals("NaN") ? Double.valueOf(999999.0) : Double.valueOf(Double.parseDouble(s) * 100.0 / (double)this.maxTiming.intValue());
    }
}

