/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Config {
    public String HSLocation;
    public String H2PLocation;
    public String TemplateLocation;
    public String ModelLocation;
    public Integer bCountLimit;
    public Integer bLengthLimit;
    public Integer kStart;
    public Integer kInc;
    public Double epsilon;
    public Integer staticStepCount;
    public Integer totalStates = -99;
    public Boolean useDelay = true;
    public Double delayCutoff = 0.0;
    public Integer multiWhich = -1;
    public Integer multiMin = -1;
    public Integer multiMax = -1;
    public String property;
    public String[] properties;
    public String outFile;
    HashMap<Integer, String> componentLookup = new HashMap();
    HashMap<String, Component> components = new HashMap();
    HashMap<String, Integer> termStates = new HashMap();

    public void load() {
        Integer ordinal = 1;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            File fXmlFile = new File("config.xml");
            Document doc = builder.parse(fXmlFile);
            NodeList nTools = doc.getElementsByTagName("Tool");
            int i = 0;
            while (i < nTools.getLength()) {
                Node n = nTools.item(i);
                Element eTool = (Element)n;
                if (eTool.getAttribute("ID").compareTo("HSLocation") == 0) {
                    this.HSLocation = eTool.getTextContent();
                }
                if (eTool.getAttribute("ID").compareTo("H2PLocation") == 0) {
                    this.H2PLocation = eTool.getTextContent();
                }
                ++i;
            }
            Node nTemplate = doc.getElementsByTagName("Template").item(0);
            this.TemplateLocation = nTemplate.getTextContent();
            Node nModel = doc.getElementsByTagName("Model").item(0);
            this.ModelLocation = nModel.getTextContent();
            Node nOutFile = doc.getElementsByTagName("OutFile").item(0);
            this.outFile = nOutFile.getTextContent();
            Node nDelay = doc.getElementsByTagName("UseDelay").item(0);
            this.useDelay = nDelay.getTextContent().compareTo("False") == 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
            try {
                Node nDelayC = doc.getElementsByTagName("DelayCutoff").item(0);
                this.delayCutoff = Double.parseDouble(nDelayC.getTextContent());
            }
            catch (NullPointerException e) {
                this.delayCutoff = 0.0;
            }
            Node nCriteria = doc.getElementsByTagName("Criteria").item(0);
            NodeList nCriteriaList = nCriteria.getChildNodes();
            int i2 = 0;
            while (i2 < nCriteriaList.getLength()) {
                Node n = nCriteriaList.item(i2);
                switch (n.getNodeName()) {
                    case "bCountLimit": {
                        this.bCountLimit = Integer.parseInt(n.getTextContent());
                        break;
                    }
                    case "bLengthLimit": {
                        this.bLengthLimit = Integer.parseInt(n.getTextContent());
                        break;
                    }
                    case "kStart": {
                        this.kStart = Integer.parseInt(n.getTextContent());
                        break;
                    }
                    case "kInc": {
                        this.kInc = Integer.parseInt(n.getTextContent());
                        break;
                    }
                    case "epsilon": {
                        this.epsilon = Double.parseDouble(n.getTextContent());
                        break;
                    }
                    case "staticStepCount": {
                        this.staticStepCount = Integer.parseInt(n.getTextContent());
                        break;
                    }
                    case "multiBuild": {
                        String mb = n.getTextContent();
                        this.multiMin = Integer.parseInt(mb.split(",")[0].trim());
                        this.multiMax = Integer.parseInt(mb.split(",")[1].trim());
                        this.multiWhich = this.multiMin;
                    }
                }
                ++i2;
            }
            NodeList nTermList = doc.getElementsByTagName("TermState");
            int i3 = 0;
            while (i3 < nTermList.getLength()) {
                Node nTerm = nTermList.item(i3);
                this.termStates.put(nTerm.getTextContent(), 0);
                ++i3;
            }
            NodeList nPropList = doc.getElementsByTagName("Property");
            this.properties = new String[nPropList.getLength()];
            int i4 = 0;
            while (i4 < nPropList.getLength()) {
                this.properties[i4] = nPropList.item(i4).getTextContent();
                ++i4;
            }
            this.property = this.properties[0];
            NodeList nCompList = doc.getElementsByTagName("Component");
            int i5 = 0;
            while (i5 < nCompList.getLength()) {
                Component c = new Component();
                NodeList nChildren = nCompList.item(i5).getChildNodes();
                int j = 0;
                while (j < nChildren.getLength()) {
                    Node nProp = nChildren.item(j);
                    switch (nProp.getNodeName()) {
                        case "ModuleName": {
                            c.Name = nProp.getTextContent();
                            break;
                        }
                        case "ModuleShortName": {
                            c.shortName = nProp.getTextContent();
                            break;
                        }
                        case "TimingFile": {
                            c.trainingFile = nProp.getTextContent();
                            System.out.println("Training File :" + c.trainingFile);
                            break;
                        }
                        case "TrainingFile": {
                            c.trainingFile = nProp.getTextContent();
                            System.out.println("Training File :" + c.trainingFile);
                        }
                    }
                    ++j;
                }
                c.ordinal = ordinal;
                ordinal = ordinal + 1;
                this.components.put(c.shortName, c);
                ++i5;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
    }

    public void Display() {
        System.out.println("HS Loc: " + this.HSLocation);
        System.out.println("bCountLimit: " + this.bCountLimit);
        System.out.println("bLengthLimit: " + this.bLengthLimit);
        System.out.println("kStart: " + this.kStart);
        System.out.println("kInc: " + this.kInc);
        System.out.println("epsilon: " + this.epsilon);
        System.out.println("staticStepCount: " + this.staticStepCount);
        System.out.println("Components (" + this.components.size() + "):");
        for (String key : this.components.keySet()) {
            Component c = this.components.get(key);
            System.out.println("Component : " + c.Name);
            System.out.println("  Short name : " + c.shortName);
            System.out.println("  Ordinal :" + c.ordinal);
            System.out.println("  State :" + c.state);
            if (c.ignore) {
                System.out.println("  Ignored");
            }
            if (c.hasDelay) {
                System.out.println("  Has a Delay");
            }
            if (c.combine == null) continue;
            System.out.println("  Delay combined with : " + c.combine.shortName);
        }
    }

    public void updateComponent(Hashtable<Integer, State> htStates) {
        State s;
        for (String shortname : this.components.keySet()) {
            Component c = this.components.get(shortname);
            this.componentLookup.put(c.ordinal, c.shortName);
            s = htStates.get(c.ordinal);
            c.ignore = s.ignore;
            c.always = s.alwaysVisited;
            if (this.useDelay.booleanValue()) {
                c.preDelay = s.preDelay;
                if (s.preDelay.booleanValue() || s.ignore.booleanValue()) {
                    c.hasDelay = false;
                }
                if (s.Combine == null) continue;
                c.hasDelay = false;
                continue;
            }
            c.hasDelay = false;
            c.preDelay = false;
        }
        Integer stateCount = 0;
        for (Integer i : this.componentLookup.keySet()) {
            Component c = this.components.get(this.componentLookup.get(i));
            c.state = stateCount + 1;
            stateCount = c.hasDelay ? Integer.valueOf(stateCount + 2) : Integer.valueOf(stateCount + 1);
        }
        for (Integer id : htStates.keySet()) {
            Component cTarget;
            s = htStates.get(id);
            if (s.Combine == null) continue;
            State sTarget = s.Combine;
            Component c = this.components.get(this.componentLookup.get(id));
            c.combine = cTarget = this.components.get(this.componentLookup.get(sTarget.ID));
        }
        this.totalStates = stateCount;
    }

    public Boolean incMulti() {
        if (this.multiWhich == -1) {
            return false;
        }
        if (this.multiWhich < this.multiMax) {
            this.multiWhich = this.multiWhich + 1;
            return true;
        }
        this.multiWhich = -1;
        return false;
    }

    public void clearFitFiles() {
        for (String shortname : this.components.keySet()) {
            Component comp = this.components.get(shortname);
            String fileLocation = "temp/" + comp.shortName + "Data.csv";
            File outFile = new File(fileLocation);
            if (outFile.exists()) {
                System.out.println("File " + fileLocation + " removed");
                outFile.delete();
            }
            if (!(outFile = new File(fileLocation = "temp/" + comp.shortName + "_fit.txt")).exists()) continue;
            System.out.println("File " + fileLocation + " removed");
            outFile.delete();
        }
    }

    public void resetComponents() {
        for (String shortname : this.components.keySet()) {
            Component c = this.components.get(shortname);
            c.traceDelay = -1;
            c.ignore = false;
            c.always = false;
            c.hasDelay = true;
            c.preDelay = false;
            c.combine = null;
        }
    }

    public void clearIntermediateFiles() {
        File f = new File("temp/module.prism");
        if (f.exists()) {
            f.delete();
        }
        if ((f = new File("temp/stem.tmpl")).exists()) {
            f.delete();
        }
        if ((f = new File(this.TemplateLocation)).exists()) {
            f.delete();
        }
    }
}

