
/*----------------------------------------------------------------------
 *  WCET Benchmark created by Jakob Engblom, Uppsala university
 *
 * Test of deeply nested loops and non-local exits */


/* -------------------------------------------------- *
 * Trace facility built-in
 *  Define DO_TRACING to do tracing on PC
 * -- all output to stdout
 *  Define TEST to check the # iterations in inner loop,
 *  and that the right value is found and returned
 * -------------------------------------------------- */


#undef FIND_TARGET             /* should we find a number? */

#define DO_TRACING

#ifdef DO_TRACING   // ON PC

  #include <stdio.h>
  #define TRACE(x) trace((x))
  #undef TEST                   /* finished testing! */
  void trace(char *s) 
    {
    printf("%s\n",s);
    }

#else               // ON TARGET 

#define TRACE(x)
#undef TEST

#endif



/* --------------------------------------------------
 *  Array of keys and values, 4-dimensional just 
 *  for the fun of it.
 * -------------------------------------------------- */
int keys[5][5][5][5] =
{
  // [0]
  {
    // [0][0]
    {
      {0,0,0,0,0},
      {0,0,0,0,0},
      {0,0,0,0,0},
      {0,0,0,0,0},      
      {0,0,0,0,0}
    },
    // [0][1]
    {
      {0,0,0,0,0},
      {0,0,0,0,0},
      {0,0,0,0,0},
      {0,0,0,0,0},      
      {0,0,0,0,0}
    },
    // [0][2]
    {
      {0,0,0,0,0},
      {0,0,0,0,0},
      {0,0,0,0,0},
      {0,0,0,0,0},      
      {0,0,0,0,0}
    },
    // [0][3]
    {
      {0,0,0,0,0},
      {0,0,0,0,0},
      {0,0,0,0,0},
      {0,0,0,0,0},      
      {0,0,0,0,0}
    },
    // [0][4]
    {
      {0,0,0,0,0},
      {0,0,0,0,0},
      {0,0,0,0,0},
      {0,0,0,0,0},      
      {0,0,0,0,0}
    }
  },
  // [1]
  {
    // [1][0]
    {
      {1,1,1,1,1},
      {1,1,1,1,1},
      {1,1,1,1,1},
      {1,1,1,1,1},      
      {1,1,1,1,1}
    },
    // [1][1]
    {
      {1,1,1,1,1},
      {1,1,1,1,1},
      {1,1,1,1,1},
      {1,1,1,1,1},      
      {1,1,1,1,1}
    },
    // [1][2]
    {
      {1,1,1,1,1},
      {1,1,1,1,1},
      {1,1,1,1,1},
      {1,1,1,1,1},      
      {1,1,1,1,1}
    },
    // [1][3]
    {
      {1,1,1,1,1},
      {1,1,1,1,1},
      {1,1,1,1,1},
      {1,1,1,1,1},      
      {1,1,1,1,1}
    },
    // [1][4]
    {
      {1,1,1,1,1},
      {1,1,1,1,1},
      {1,1,1,1,1},
      {1,1,1,1,1},      
      {1,1,1,1,1}
    }
  },
  // [2]
  {
    // [2][0]
    {
      {2,2,2,2,2},
      {2,2,2,2,2},
      {2,2,2,2,2},
      {2,2,2,2,2},      
      {2,2,2,2,2}
    },
    // [2][1]
    {
      {2,2,2,2,2},
      {2,2,2,2,2},
      {2,2,2,2,2},
      {2,2,2,2,2},      
      {2,2,2,2,2}
    },
    // [2][2]
    {
      {2,2,2,2,2},
      {2,2,2,2,2},
      {2,2,2,2,2},
      {2,2,2,2,2},      
      {2,2,2,2,2}
    },
    // [2][3]
    {
      {2,2,2,2,2},
      {2,2,2,2,2},
      {2,2,2,2,2},
      {2,2,2,2,2},      
      {2,2,2,2,2}
    },
    // [2][4]
    {
      {2,2,2,2,2},
      {2,2,2,2,2},
      {2,2,2,2,2},
      {2,2,2,2,2},      
      {2,2,2,2,2}
    }
  },
  // [3]
  {
    // [3][0]
    {
      {3,3,3,3,3},
      {3,3,3,3,3},
      {3,3,3,3,3},
      {3,3,3,3,3},      
      {3,3,3,3,3}
    },
    // [3][1]
    {
      {3,3,3,3,3},
      {3,3,3,3,3},
      {3,3,3,3,3},
      {3,3,3,3,3},      
      {3,3,3,3,3}
    },
    // [3][2]
    {
      {3,3,3,3,3},
      {3,3,3,3,3},
      {3,3,3,3,3},
      {3,3,3,3,3},      
      {3,3,3,3,3}
    },
    // [3][3]
    {
      {3,3,3,3,3},
      {3,3,3,3,3},
      {3,3,3,3,3},
      {3,3,3,3,3},      
      {3,3,3,3,3}
    },
    // [3][4]
    {
      {3,3,3,3,3},
      {3,3,3,3,3},
      {3,3,3,3,3},
      {3,3,3,3,3},      
      {3,3,3,3,3}
    }
  },
  // [4]
  {
    // [4][0]
    {
      {4,4,4,4,4},
      {4,4,4,4,4},
      {4,4,4,4,4},
      {4,4,4,4,4},      
      {4,4,4,4,4}
    },
    // [4][1]
    {
      {4,4,4,4,4},
      {4,4,4,4,4},
      {4,4,4,4,4},
      {4,4,4,4,4},      
      {4,4,4,4,4}
    },
    // [4][2]
    {
      {4,4,4,4,4},
      {4,4,4,4,4},
      {4,4,4,4,4},
      {4,4,4,4,4},      
      {4,4,4,4,4}
    },
    // [4][3]
    {
      {4,4,4,4,4},
      {4,4,4,4,4},
      {4,4,4,4,4},
      {4,4,4,4,4},      
      {4,4,4,4,4}
    },
    // [4][4]
    {
      {4,4,4,4,4},
      {4,4,4,4,4},
      {4,4,4,4,4},
      {4,4,4,4,4},      
      {4,4,4,4,
#ifdef FIND_TARGET
       400
#else
       401                      /* not searched for */
#endif
      }
    }
  }
};



int answer[5][5][5][5] =
{
  // [0]
  {
    // [0][0]
    {
      {123,123,123,123,123},
      {123,123,123,123,123},
      {123,123,123,123,123},
      {123,123,123,123,123},      
      {123,123,123,123,123}
    },
    // [0][1]
    {
      {123,123,123,123,123},
      {123,123,123,123,123},
      {123,123,123,123,123},
      {123,123,123,123,123},      
      {123,123,123,123,123}
    },
    // [0][2]
    {
      {123,123,123,123,123},
      {123,123,123,123,123},
      {123,123,123,123,123},
      {123,123,123,123,123},      
      {123,123,123,123,123}
    },
    // [0][3]
    {
      {123,123,123,123,123},
      {123,123,123,123,123},
      {123,123,123,123,123},
      {123,123,123,123,123},      
      {123,123,123,123,123}
    },
    // [0][4]
    {
      {123,123,123,123,123},
      {123,123,123,123,123},
      {123,123,123,123,123},
      {123,123,123,123,123},      
      {123,123,123,123,123}
    }
  },
  // [1]
  {
    // [1][0]
    {
      {234,234,234,234,234},
      {234,234,234,234,234},
      {234,234,234,234,234},
      {234,234,234,234,234},      
      {234,234,234,234,234}
    },
    // [1][1]
    {
      {234,234,234,234,234},
      {234,234,234,234,234},
      {234,234,234,234,234},
      {234,234,234,234,234},      
      {234,234,234,234,234}
    },
    // [1][2]
    {
      {234,234,234,234,234},
      {234,234,234,234,234},
      {234,234,234,234,234},
      {234,234,234,234,234},      
      {234,234,234,234,234}
    },
    // [1][3]
    {
      {234,234,234,234,234},
      {234,234,234,234,234},
      {234,234,234,234,234},
      {234,234,234,234,234},      
      {234,234,234,234,234}
    },
    // [1][4]
    {
      {234,234,234,234,234},
      {234,234,234,234,234},
      {234,234,234,234,234},
      {234,234,234,234,234},      
      {234,234,234,234,234}
    }
  },
  // [2]
  {
    // [2][0]
    {
      {345,345,345,345},
      {345,345,345,345},
      {345,345,345,345},
      {345,345,345,345},      
      {345,345,345,345}
    },
    // [2][1]
    {
      {345,345,345,345},
      {345,345,345,345},
      {345,345,345,345},
      {345,345,345,345},      
      {345,345,345,345}
    },
    // [2][2]
    {
      {345,345,345,345},
      {345,345,345,345},
      {345,345,345,345},
      {345,345,345,345},      
      {345,345,345,345}
    },
    // [2][3]
    {
      {345,345,345,345},
      {345,345,345,345},
      {345,345,345,345},
      {345,345,345,345},      
      {345,345,345,345}
    },
    // [2][4]
    {
      {345,345,345,345},
      {345,345,345,345},
      {345,345,345,345},
      {345,345,345,345},      
      {345,345,345,345}
    }
  },
  // [3]
  {
    // [3][0]
    {
      {456,456,456,456,456},
      {456,456,456,456,456},
      {456,456,456,456,456},
      {456,456,456,456,456},      
      {456,456,456,456,456}
    },
    // [3][1]
    {
      {456,456,456,456,456},
      {456,456,456,456,456},
      {456,456,456,456,456},
      {456,456,456,456,456},      
      {456,456,456,456,456}
    },
    // [3][2]
    {
      {456,456,456,456,456},
      {456,456,456,456,456},
      {456,456,456,456,456},
      {456,456,456,456,456},      
      {456,456,456,456,456}
    },
    // [3][3]
    {
      {456,456,456,456,456},
      {456,456,456,456,456},
      {456,456,456,456,456},
      {456,456,456,456,456},      
      {456,456,456,456,456}
    },
    // [3][4]
    {
      {456,456,456,456,456},
      {456,456,456,456,456},
      {456,456,456,456,456},
      {456,456,456,456,456},      
      {456,456,456,456,456}
    }
  },
  // [4]
  {
    // [4][0]
    {
      {567,567,567,567,567},
      {567,567,567,567,567},
      {567,567,567,567,567},
      {567,567,567,567,567},      
      {567,567,567,567,567}
    },
    // [4][1]
    {
      {567,567,567,567,567},
      {567,567,567,567,567},
      {567,567,567,567,567},
      {567,567,567,567,567},      
      {567,567,567,567,567}
    },
    // [4][2]
    {
      {567,567,567,567,567},
      {567,567,567,567,567},
      {567,567,567,567,567},
      {567,567,567,567,567},      
      {567,567,567,567,567}
    },
    // [4][3]
    {
      {567,567,567,567,567},
      {567,567,567,567,567},
      {567,567,567,567,567},
      {567,567,567,567,567},      
      {567,567,567,567,567}
    },
    // [4][4]
    {
      {567,567,567,567,567},
      {567,567,567,567,567},
      {567,567,567,567,567},
      {567,567,567,567,567},      
      {567,567,567,567,1111}
    }
  }
};


int foo(int x)
{
#ifdef TEST
  int c = 0;                    /* counter for innerloop */
#endif
  int i,j,k,l;

  TRACE("foo");

  for(i=0; TRACE("XXfoo_0"),i<5; TRACE("XXfoo_1"),i++)
    for(TRACE("BB1"),j=0 ; TRACE("XXfoo_3"),j<5 ; TRACE("XXfoo_4"),j++)
      for(TRACE("BB2"),k=0 ; TRACE("XXfoo_5"),k<5 ; TRACE("XXfoo_6"),k++)
        for(TRACE("BB3"),l=0 ; TRACE("XXfoo_7"),l<5 ; TRACE("XXfoo_8"),l++)
        {
#ifdef TEST
          c++;
#endif
          TRACE("BB4"); 
          if( keys[i][j][k][l] == x )
            {
#ifdef TEST
              TRACE("!!!found");
              printf("   %d\n",c);
#endif
              TRACE("BB5");
              TRACE("XXfoo_9"); /* jump to clean-up code */
              
              return answer[i][j][k][l] + keys[i][j][k][l];
            }
        }
  
  TRACE("XXfoo_2");
  TRACE("XXfoo_9");             /* clean-up code */
  return -1;
}


int main(void)
{
  TRACE("main");
#ifdef TEST
  printf("result=%d\n",foo(400));
#else
  foo(400);
#endif
  TRACE("BB6");
  return 0;
}
