/* sumcntmatrix.c */

#include <sys/types.h>
#include <sys/times.h>

#define WORSTCASE 1
#define MAXSIZE 10

typedef unsigned int matrix [MAXSIZE][MAXSIZE];

int Seed;
matrix Array;
int Postotal, Negtotal, Poscnt, Negcnt;

int main ()
{
   InitSeed();
   printf("\n   *** MATRIX SUM AND COUNT BENCHMARK TEST ***\n\n");
   printf("RESULTS OF THE TEST:\n");
   Test(Array);
   return 0;
}


Test(Array)
matrix Array;
{
   long StartTime, StopTime;
   float TotalTime;
   void Sum();

   Initialize(Array);
   StartTime = ttime();
   Sum(Array);
   StopTime = ttime();

   TotalTime = (StopTime - StartTime) / 1000.0;

   printf("    - Size of array is %d\n", MAXSIZE);
   printf("    - Num pos was %d and Sum was %d\n", Poscnt, Postotal);
   printf("    - Num neg was %d and Sum was %d\n", Negcnt, Negtotal);
   printf("    - Num neg was %d\n", Negcnt);
   printf("    - Total sum time is %3.3f seconds\n\n", TotalTime);
}


Initialize ()
/*
 * Intializes the given array with random integers.
 */
{
   register int OuterIndex, InnerIndex;

   for (OuterIndex = 0; OuterIndex < MAXSIZE; OuterIndex++)
      for (InnerIndex = 0; InnerIndex < MAXSIZE; InnerIndex++)
         Array[OuterIndex][InnerIndex] = RandomInteger();
}


InitSeed ()
/*
 * Initializes the seed used in the random number generator.
 */
{
   Seed = 0;
}


void Sum(Array)
matrix Array;
{
   register int Outer, Inner;

   int Ptotal = 0; /* changed these to locals in order to drive worst case */
   int Ntotal = 0;
   int Pcnt = 0;
   int Ncnt = 0;

   for (Outer = 0; Outer < MAXSIZE; Outer++)
      for (Inner = 0; Inner < MAXSIZE; Inner++)
#ifdef WORSTCASE
         if (Array[Outer][Inner] >= 0) {
#else
         if (Array[Outer][Inner] < 0) {
#endif
            Ptotal += Array[Outer][Inner];
            Pcnt++;
         }
         else {
            Ntotal += Array[Outer][Inner];
            Ncnt++;
         }

   Postotal = Ptotal;
   Poscnt = Pcnt;
   Negtotal = Ntotal;
   Negcnt = Ncnt;
}


int ttime()
/*
 * This function returns in milliseconds the amount of compiler time
 * used prior to it being called.
 */
{
   struct tms buffer;
   int utime;

   times(&buffer);
   utime = (buffer.tms_utime / 60.0) * 1000.0;
   return (utime);
}


RandomInteger()
/*
 * Generates random integers between 0 and 8095
 */
{
   Seed = ((Seed * 133) + 81) % 8095;
   return Seed;
}
