/* summatrix.c */

#include <sys/types.h>
#include <sys/times.h>

/* MATRIX SUM BENCHMARK PROGRAM:
 * This program multiplies 2 square matrices resulting in a 3rd
 * matrix. It tests a compiler's speed in handling multidimensional
 * arrays and simple arithmetic.
 */

#define WORSTCASE 1
#define MAXSIZE 100

typedef int matrix[MAXSIZE][MAXSIZE];

int Seed;
matrix Array;

main()
{
   InitSeed();
   printf("\n   *** MATRIX SUM BENCHMARK TEST ***\n\n");
   printf("RESULTS OF THE TEST:\n");
   Test(Array);
   return 0;
}


InitSeed()
/*
 * Initializes the seed used in the random number generator.
 */
{
   Seed = 0;
}


Test(Array)
matrix Array;
/*
 * Runs a multiplication test on an array.  Calculates and prints the
 * time it takes to multiply the matrices.
 */
{
   long StartTime, StopTime;
   float TotalTime;
   int Total;

   Initialize(Array);
   StartTime = ttime();
   Total = Sum(Array);
   StopTime = ttime();
   TotalTime = (StopTime - StartTime) / 1000.0;
   printf("    - Size of array is %d\n", MAXSIZE);
   printf("    - Total was %d\n", Total);
   printf("    - Total multiplication time is %3.3f seconds\n\n", TotalTime);
}


Initialize(Array)
matrix Array;
/*
 * Intializes given array with random integers.
 */
{
   register int OuterIndex, InnerIndex;

   for (OuterIndex = 0; OuterIndex < MAXSIZE; OuterIndex++)
      for (InnerIndex = 0; InnerIndex < MAXSIZE; InnerIndex++)
         Array[OuterIndex][InnerIndex] = RandomInteger();
}


int ttime()
/* 
 * This function returns in milliseconds the amount of compiler time
 * used prior to it being called.
 */
{
   struct tms buffer;
   int utime;

   times(&buffer);
   utime = (buffer.tms_utime / 60.0) * 1000.0;
   return (utime);
}


Sum(Array)
matrix Array;
/*
 * Multiplies 2 arrays and stores the result in ResultArray.
 */
{
   register int Outer, Inner, Total;

   Total = 0;
   for (Outer = 0; Outer < MAXSIZE; Outer++)
      for (Inner = 0; Inner < MAXSIZE; Inner++)
#ifdef WORSTCASE
         if (Array[Outer][Inner] >= 0)
#else
         if (Array[Outer][Inner] < 0)
#endif
            Total += Array[Outer][Inner];

   return Total;
}


RandomInteger()
/*
 * Generates random integers between 0 and 8095
 */
{
   Seed = ((Seed * 133) + 81) % 8095;
   return (Seed);
}
