#!/usr/bin/perl

####
#This perl scripts is used to update the path variable after successfully install
#The cross compiler and simple scalar toolsets.
#Author : Xun Dong. University of York
#Date   : 10/09/2005
####

use strict;

########
#Other modules used in this scripts
########
use Getopt::Long;

my $profile_name;
my $cross_compiler_bin;
my $ss_arm;
my $ss_pisa;
my @contents;
my $index = 0;
my $exist = 0;

parse();

open(PROFILE, "$profile_name") or die("Warning :: Can't open the profile. User must manually update the PATH variable before using the tools\n");

while(<PROFILE>){

	$contents[$index] = $_;
	chomp($contents[$index]);
	if($_ =~ /^\s*PATH=/){
		$exist = 1;
		if($_ =~ /$cross_compiler_bin/){
			if($_ =~ /$ss_arm/){
				if($_ =~ /$ss_pisa/){
					print "NOthing need to be changed in the Profile\n";
					exit 0;
				}
				else{
					$contents[$index] = $contents[$index].':'."$ss_pisa";
				}
			}
			else{
				$contents[$index] = $contents[$index].':'."$ss_arm";
				if($_ =~ /$ss_pisa/){
					;
	USBCp%                     v vex] = $contents[$index].':'."$ss_pisa";
				}
			}
		}
	
		else{
			$contents[$index] = $contents[$index].':'."$cross_compiler_bin";			
			if($_ =~ /$ss_arm/){
				if($_ =~ /$ss_pisa/){
					;
				}
				else{
					$contents[$index] = $contents[$index].':'."$ss_pisa";
				}
			}
			else{
				$contents[$index] = $contents[$index].':'."$ss_arm";
				if($_ =~ /$ss_pisa/){
					;
				}
				else{
					$contents[$index] = $contents[$index].':'."$ss_pisa";
				}
			}	
		}
	}		
	#print "$contents[$index]";
	$contents[$index]=$contents[$index]."\n";
	$index++;
	
	
}

close(PROFILE);

if($exist ==0){
	open(PROFILE, ">>$profile_name") or die("Warning :: Can't open the profile. User must manually update the PATH variable before using the tools\n");
	my $PATH='PATH=$PATH'.":$cross_compiler_bin:$ss_arm:$ss_pisa";
	print PROFILE $PATH;
	print PROFILE "\n";
	print PROFILE "export PATH\n";	
	close(PROFILE);
	exit 0;
}

open(PROFILE, ">$profile_name") or die("Warning :: Can't open the profile. User must manually update the PATH variable before using the tools\n");

foreach my $line (@contents){
	print PROFILE $line;
}	

close(PROFILE);

########
#Function : parse()
#Other function invoked: process_spec; verify_ss_inst;
#Parameter : @ARGV(array of arguments given on the command line)
#Description : This procedure will parse the arguments given on the 
#              commandline and assign relevant value to the scalar variables.
#return : None
########
sub parse{
	GetOptions(
		'profile=s' => \$profile_name ,
		'gcc_bin=s' => \$cross_compiler_bin,
		'ss_arm:s'  => \$ss_arm,
		'ss_pisa:s' => \$ss_pisa
	);	
	
	if(-e $profile_name ){
		print "Profile located\n";
 	}
	else{
		print "Warning :: Can't fine the profile. User must manually update the PATH variable before using the tools\n"	;
		exit(0);
	}
	
	(-d $cross_compiler_bin) or die ("Cannot locate the $cross_compiler_bin directory\n");
	
}
