/*
 * include/asm-arm/arch-clps7110/touch_psion.h
 *
 * Psion touch-screen
 *
 * Written 1999 by Werner Almesberger
 */
 
#ifndef __ASM_ARCH_TOUCH_PSION_H
#define __ASM_ARCH_TOUCH_PSION_H

#include <linux/types.h>


#define TOUCH_PSION_DEV_MINOR	10

#define TOUCH_PSION_SCALE_LOG2	13	/* lots of bits for x*y coefficient */


struct touch_psion_config {
	int		xc[4];
	int		yc[4];
};

/* Raw-mode structure */

struct touch_psion_event {
	__u16		down;	/* non-zero if pen down */
	__u16		x_r;	/* raw "X" value */
	__u16		y_r;	/* raw "Y" value */
	__s16		x_c;	/* converted x value */
	__s16		y_c;	/* converted y value */
	__u16		__rsvd1;
	__u16		__rsvd2;
};

/*
 * Real coordinates are calculated as
 *   x = (x_r*xc[0]+y_r*xc[1]+x_r*y_r/scale*xc[2]+xc[3])/scale
 *   y = (x_r*yc[0]+y_r*yc[1]+x_r*y_r/scale*yc[2]+yc[3])/scale
 *
 * where
 *
 *   scale = 1 << TOUCH_PSION_SCALE_LOG2
 *
 * The corresponding system of linear equations has to be solved based on
 * calibration data obtained at four points.
 */

#endif
