/*
 * include/asm-arm/arch-clps7110/keyboard.h
 *   
 * Part of the clps7110 keyboard driver.
 *
 * Copyright (C) Roger Gammans 1998
 *
 */


#ifndef __ASM_ARCH_KEYBOARD_H
#define __ASM_ARCH_KEYBOARD_H

#include <asm/arch/clps7110.h>
#include <asm/spinlock.h>

#ifdef CONFIG_ARCH_GEOFOX
#include <asm/arch/kbd_geofox.h>
#else
#ifdef CONFIG_ARCH_PSION
#include <asm/arch/kbd_psion.h>
#else
#error Unknown Architecture
#endif
#endif
/*
 *#warning Keymaps for this architecture haven't been completed yet
 */
#define KB_JIFMASK (127)


#ifdef KB_DELAY
extern unsigned int kbd_delay[];
#endif

/*
 * Later on we'll try a struct of
 * two arrays then the existing keyboard.c can
 * test our array directly but until then....
 */

typedef struct {
    int in:1;   /* If the key down */
    int jif:7;  /* how long has key been down for (approx) */
} kbd_keyinfo;


static kbd_keyinfo kbdstate[NR_KEYCODES];

#if NR_KEYCODES>0x80 
#error Out of bits for scancode.. 
#endif

#define  KBUP    (0x80)
#define  KBDOWN  (0)

#define  KBSCANCDE(x,y) ((x) | (y))

/*
 * We have a spinlock we use to ensure that keysdown
 * is consisent with kbd_state[]
 *
 * This is prolly overkill since the arm doesn't support SMP.
 */
// Yes, it is - WA  static spinlock_t kbd_spinlock;

 /*
  * #define for functions we can't make use of 
  */

#define kbd_leds(x)
#define kbd_setleds(x)
#define kbd_getledstate		(0)
extern int  kbd7110_translate(unsigned char sc,unsigned char *keycode_p);
#define kbd_translate(sc,kc,rm)	kbd7110_translate(sc,kc)
extern unsigned char kbd7110_sysrq_xlate[NR_KEYCODES];
#define kbd_sysrq_xlate		((sysrq_pressed = 0), kbd7110_sysrq_xlate)
#define kbd_pretranslate(x,y)	(1)
#define kbd_unexpected_up(kc)	(0x80)
#define kbd_setkeycode(sc,kc)   (-EINVAL)
#define kbd_getkeycode(sc)      (-EINVAL)

extern void kbd7110_arch_handler(unsigned char value, char up_flag);
#define kbd_arch_handler	kbd7110_arch_handler

extern void kbd7110_hw_init(void);
#define kbd_init_hw()		 kbd7110_hw_init()

extern void kbd7110_cleartable(void);

#define SYSRQ_KEY 0x100	/* dummy */

/*
 * I need to do something better for these two...
 * Sometime v. soon. I don't like these at all, as they 
 *   
 * don't look like fn calls. 
 */

#define kbd_disable_irq()        { \
                                    int flags; \
                                    spin_lock_irqsave(&kbd_spinlock,flags);


#define  kbd_enable_irq()           spin_unlock_irqrestore(&kbd_spinlock,flags); \
                               }

#endif
