/*
 * include/asm-arm/arch-clps7110/kbd_psion.h
 *
 * Psion specific defines for it's keyboard.
 *
 * Copyright (C) Roger Gammans 1998
 */
 

#ifndef __ASM_ARCH_PSION_H
#define __ASM_ARCH_PSION_H

#include <asm/arch/clps7110.h>
#include <asm/arch/hardware.h>

 /*
  * Arm's keyboard is active high row select...
  *  (must try to remember)
  */
#define KB_ALLCOLS   KBSC_HI 
#define KB_DISCHARGE KBSC_LO
#define KB_LASTROW   7

   /*
    *  Be sure to change the if you increase the
    *  number of kbd rows...
    */
#define KEYCODE(r,c)  ( ((c)<<3) + (r)+1)
#define NR_KEYCODES 64

#define KB_ROWMASK(r) (1 << (r))

 /*
  * KB_DELAY is used to allow the matrix 
  * to stabilize.., value is determined via
  * experimentation. 
  */

#define KB_DELAY   {16 ,16 ,16 ,16 ,16 ,16 ,16 ,16 ,16}

 /*
  * Not sure whether this trick works yet!
  * 
  */
#undef KBD_SUPPORTS_WIREOR

 
  /*
   * treat debounce monostable as 30ms
   */
   
#define KB_DEB_JIFFY (30/HZ)
 
 /*
  * only read from
  */
#define KB_ROW (IO_PADR & 0x7f)
 
 /*
  * only written to
  */
#define KB_COL(n)  IO_SYSCON = ((IO_SYSCON & ~KBDSCAN)  | (KBSC_COL0+n)) 


/*
 * Architecture-specific keys. Value 0 is invalid. 1 is SysRq.
 */

#define KBD_ARCHKEY_2	psion_off()
#define KBD_ARCHKEY_3	psion_toggle_backlight()
#define KBD_ARCHKEY_4	psion_contrast(0)
#define KBD_ARCHKEY_5	psion_contrast(1)

/* KBD_ARCHKEY_6 to KBD_ARCHKEY_10 reserved for debugging */

/* #define KBD_ARCHKEY_11	psion_debug_cf() */

void psion_off(void);
void psion_toggle_backlight(void);
void psion_contrast(int increase);

void psion_debug_cf(void);

#endif
