/*
 * include/asm-arm/arch-clps7110/kbd_geofox.h
 *
 * Geofox specific defines for it's keyboard.
 *
 * Copyright (C) Roger Gammans 1998
 */
 

#ifndef __ASM_ARCH_GEOFOX_H
#define __ASM_ARCH_GEOFOX_H

#include <asm/arch/clps7110.h>
#include <asm/arch/hardware.h>

 /*
  * Arm's keyboard is active high row select...
  *  (must try to remember)
  */
#define KB_ALLCOLS   KBSC_HI 
#define KB_DISCHARGE KBSC_LO
#define KB_LASTROW   12

   /*
    *  Be sure to change the if you increase the
    *  number of kbd rows...
    */
#define KEYCODE(r,c)  ( ((c)<<4) + (r)+1)
#define NR_KEYCODES 128

#define KB_ROWMASK(r) (1 << (r))

 /*
  * KB_DELAY is used to allow the matrix 
  * to stabilize.., values determined by
  * experimentation. 
  *
  * These values represent what works on *my* geofox
  * I'll try to make these as general as possible but
  * if you have trouble use /proc to find a working set.
  *   -  I only have one machine to test on, so they have 
  *      to reflect that machine (atm).
  *
  * TODO: Link arrary into /proc.
  */
#define KB_DELAY {16 ,16,  16, 16, 16, 16, 16, 16 ,16}
                 
extern unsigned int kb_delay[];

 /*
  * Not sure whether this trick works yet!
  * 
  */
#undef KBD_SUPPORTS_WIREOR

 
  /*
   * treat debounce monostable as 30ms
   */
   
#define KB_DEB_JIFFY ((30*HZ)/1000)
 
 /*
  * only read from
  */
#define KB_ROW ((IO_PADR) + ((IO_PBDR & 0x0f) << 8))
 
 /*
  * only written to
  */
#define KB_COL(n)  IO_SYSCON = ((IO_SYSCON & ~KBDSCAN)  | (KBSC_COL0+n)) 


/*
 * Architecture-specific keys. Value 0 is invalid. 1 is SysRq.
 */

#define KBD_ARCHKEY_2	geofox_off()
#define KBD_ARCHKEY_3	geofox_toggle_backlight()
#define KBD_ARCHKEY_4	geofox_contrast(0)
#define KBD_ARCHKEY_5	geofox_contrast(1)

void geofox_off(void);
void geofox_toggle_backlight(void);
void geofox_contrast(int increase);

#endif
