/*
 * linux/include/asm-arm/arch-clps7110/io.h
 *
 * Written 1998,1999 by Werner Almesberger
 * Strongly inspired by the other asm-atm/arch-*?/io.h files
 */

#ifndef __ASM_ARCH_IO_H
#define __ASM_ARCH_IO_H

/* No delayed IO required */

#undef	ARCH_IO_DELAY

/*
 * Use outb/outl/inb/etc. for PC-style hardware. In our case, that's
 * everything in the CF/PCMCIA slot.
 */

#if 1
#define __inb(p)	(*(volatile uint8_t *) PCMCIA_IO8(p))
#define __outb(v,p)	(*(volatile uint8_t *) PCMCIA_IO8(p) = (v))
#define __inw(p)	(*(volatile uint32_t *) PCMCIA_IO16(p) & 0xffff)
#define __outw(v,p)	(*(volatile uint32_t *) PCMCIA_IO16(p) = (v))
#else
#define __inb(p)	({ uint8_t v; \
			  v = *(volatile uint8_t *) PCMCIA_IO8(p); \
			  printk("inb(0x%x) = 0x%02x\n",p,v); v;})
#define __outb(v,p)	({ uint8_t _v = (v); \
			  printk("outb(0x%x) := 0x%02x\n",p,_v); \
			  *(volatile uint8_t *) PCMCIA_IO8(p) = _v;})
#define __inw(p)	({ uint16_t v; \
			  v = *(volatile uint32_t *) PCMCIA_IO16(p) & 0xffff; \
			  if (p != 0x1f0) \
			    /*printk("inw(0x%x) = 0x%04x\n",p,v)*/; v;})
#define __outw(v,p)	({ uint16_t _v = (v); \
			  printk("outw(0x%x) := 0x%04x\n",p,_v); \
			  *(volatile uint32_t *) PCMCIA_IO16(p) = _v;})
#endif
#define __inl(p)	({ panic("__inl"); })
#define __outl(v,p)	panic("__outl")

#if 0
#define DECLARE_DYN_OUT(fnsuffix,instr) \
  extern __inline__ void __out##fnsuffix(unsigned int value,unsigned int port) \
  { \
	__asm__ __volatile__( \
		"str" ##instr## " %0,[%1,%2]" \
		: : "r" (value), "r" (IO_BASE), "Jr" (port)); \
  }


#define DECLARE_DYN_IN(sz,fnsuffix,instr) \
  extern __inline__ unsigned sz __in##fnsuffix(unsigned int port) \
  { \
	unsigned long value; \
	__asm__ __volatile__( \
		"ldr" ##instr## " %0,[%1,%2]" \
		: "=&r" (value) : "r" (IO_BASE), "Jr" (port)); \
	return (unsigned sz) value; \
  }


extern __inline__ unsigned int __ioaddr(unsigned int port)
{
	return (unsigned int) (IO_BASE + port);
}


#define DECLARE_IO(sz,fnsuffix,instr)	\
	DECLARE_DYN_OUT(fnsuffix,instr)	\
	DECLARE_DYN_IN(sz,fnsuffix,instr)

DECLARE_IO(char,b,"b")
/* The ARM710 doesn't support strh/ldrh */
DECLARE_IO(long,l,"")

#undef DECLARE_IO
#undef DECLARE_DYN_OUT
#undef DECLARE_DYN_IN

/* Constant-address functions */

#define __outbc(value,port) \
	({ __asm__ __volatile__( \
  	    "strb %0,[%1,%2]" \
	    : : "r" (value), "r" (IO_BASE), "Jr" (port)); })

#define __inbc(port) \
	({ unsigned char result; \
	  __asm__ __volatile__( \
  	    "ldrb %0,[%1,%2]" \
	    : "=r" (result) : "r" (IO_BASE), "Jr" (port)); \
	  result; })

#define __outlc(value,port) \
	({ __asm__ __volatile__( \
  	    "str %0,[%1,%2]" \
	    : : "r" (value), "r" (IO_BASE), "Jr" (port)); })

#define __inlc(port) \
	({ unsigned long result; \
	  __asm__ __volatile__( \
  	    "ldr %0,[%1,%2]" \
	    : "=r" (result) : "r" (IO_BASE), "Jr" (port)); \
	    result; })

#define __ioaddrc(port)	((unsigned long) (IO_BASE+port)

/* Translated IO: address is already virtual address */

#define outb_t(v,p)	(*(volatile unsigned char *) (p) = (v))
#define inb_t(v,p)	(*(volatile unsigned char *) (p))
#define outl_t(v,p)	(*(volatile unsigned long *) (p) = (v))
#define inl_t(v,p)	(*(volatile unsigned long *))

#endif

#endif
