/*
 * linux/include/asm-arm/arch-clps7110/hw_geofox.h
 *
 * Written 1998 by Werner Almesberger
 *
 * This file contains the hardware definitions of the Geofox One
 */

#ifndef __ASM_ARCH_HW_GEOFOX_H
#define __ASM_ARCH_HW_GEOFOX_H

/*
 * Our memory model:
 *
 * Physical		Size	Type			Virtual
 * (_START)		(_SIZE)				(_BASE)
 * 00000000-00800000 	   8MB	ROM			n/a
 * 80000000-80000fff	   4kB	internal registers	f0000000
 * 80001000-bfffffff 	4092kB	not used		n/a
 * c0000000-c03fffff	   4MB	RAM bank 0 (RAM0)	c0000000
 * c0400000-c07fffff	   4MB	RAM1			c0400000
 * c1000000-c17fffff	   8MB	RAM2			c1000000
 */

/*
 * Physical address of PCMCIA area.
 */

#define PCMCIA_START		0x70000000

/*
 * LCD display size
 */

#define LCD_X_SIZE		640
#define LCD_Y_SIZE		320

/*
 * Register/port usage
 */

/*
 * Port A
 *
 * +--7--+--6--+--5--+--4--+--3--+--2--+--1--+--0--+
 * | KB7 | KB6 | KB5 | KB4 | KB3 | KB2 | KB1 | KB0 |
 * | in  | in  | in  | in  | in  | in  | in  | in  |
 * +-----+-----+-----+-----+-----+-----+-----+-----+
 *
 * Port B
 *
 * +--7--+--6--+--5--+--4--+--3--+--2--+--1--+--0--+
 * |  ?  |  ?  |  ?  |  ?  |KB11 |KB10 | KB9 | KB8 |
 * |  in?| in? |  ?  |  in?| in  | in  | in  | in  |
 * +-----+-----+-----+-----+-----+-----+-----+-----+
 *
 * Direction guess above based on "e 80000040" in arlo.
 *
 *
 * Port C
 *
 * +--7--+--6--+--5--+--4--+--3--+--2--+--1--+--0--+
 * | DC3 | DC2 | DC1 | DC0 |  ?  |  ?  | DTR?| RTS?|
 * | out | out | out | out |  ?  |  ?  | out?| out?|
 * +-----+-----+-----+-----+-----+-----+-----+-----+
 */

/*
 * I don't have any evidence these are right atm (25/10/1998)
 *                           ^^^^^ (The serial bits)
 *
 * They are chosen because they are the same as the psion, and
 * dont conflict with anything we do know about.
 *                                               RGG
 */

#define HW_RTS_PORT		IO_PCDR
#define HW_RTS_BIT		0x01
#define HW_DTR_PORT		IO_PCDR
#define HW_DTR_BIT		0x02

/*
 * Note that unlike the psion, the geofox (appears to) use(s) a 
 * binary encoding for the LCD contrast yielding 16 settings.
 */

#define HW_VLD_PORT             IO_PCDR
#define HW_VLD_DIR              IO_PCDDR
#define HW_VLD_MASK             0xf0
#define HW_VLD_SHIFT            2

/*
 * Port D
 *
 * +--7--+--6--+--5--+--4--+--3--+--2--+--1--+--0--+
 * |  ?  |  ?  |  ?  |  ?  |  ?  |  ?  |  ?  |  ?  |
 * |  ?  |  ?  |  ?  |  ?  |  ?  |  ?  |  ?  |  ?  |
 * +-----+-----+-----+-----+-----+-----+-----+-----+
 *
 * Port E
 *
 * +--3--+--2--+--1--+--0--+
 * |  ?  |  ?  |  ?  |  ?  |
 * |  ?  |  ?  |  ?  |  ?  |
 * +-----+-----+-----+-----+
 */

/*
 * ADC timing
 */


#define ADC1213X_T_SK     65  /*16 Khz for Touchpad interface*/

#define SSI_SPD     ADCS_32

#endif
