/*
 * linux/include/asm-arm/arch-clps7110/adc1213x.h
 *
 * Written 1999 by Werner Almesberger
 *
 * NS ADC1213X interface
 */

#ifndef __ASM_ARCH_ADC1213X_H
#define __ASM_ARCH_ADC1213X_H

#include <linux/types.h>
#include <asm/atomic.h>


#define ADC1213X_CHANNELS	8	/* ADC12138 */

/*
 * All times are in microseconds.
 *
 * The following timing parameters depend on the environment:
 *
 * ADC1213X_T_CK	conversion clock cycle time
 * ADC1213X_T_SK	serial data clock cycle time
 */

#define ADC1213X_T_C	(44*ADC1213X_T_CK)	/* Conversion Time */
#define ADC1213X_T_A_6	(7*ADC1213X_T_CK)	/* Acquisition Time */
#define ADC1213X_T_A_10	(11*ADC1213X_T_CK)
#define ADC1213X_T_A_18	(19*ADC1213X_T_CK)
#define ADC1213X_T_A_34	(35*ADC1213X_T_CK)
#define ADC1213X_T_CAL	(4944*ADC1213X_T_CK)	/* Self-Calibration Time */
#define ADC1213X_T_AZ	(76*ADC1213X_T_CK)	/* Auto-Zero Time */
#define ADC1213X_T_DOR	(9*ADC1213X_T_SK)	/* DOR High Time */
#define	ADC1213X_T_CONV	(8*ADC1213X_T_SK)	/* CONV valid time */
#define ADC1213X_T_SPU	700			/* Software Power-Up Time */

#define	ADC1213X_CONV(chan,flags)	(((chan) << 1) | (flags))
#define ADC1213X_FLG_DIFF	0x00		/* Differential */
#define ADC1213X_FLG_SNGL	0x01		/* Single-Ended */
#define ADC1213X_FLG_12		0x00		/* 12/13 bit conversion */
#define ADC1213X_FLG_16		0x80		/* 16/17 bit conversion */
#define ADC1213X_FLG_LSB	0x20		/* LSB first */
#define ADC1213X_FLG_MSB	0x00		/* MSB first */

#define ADC12130_CMD(cmd)	((cmd & 0x03) | ((cmd & 0xf0) >> 2))

#define ADC1213X_CAL		0x10		/* Auto Cal */
#define	ADC1213X_AZ		0x90		/* Auto Zero */
#define ADC1213X_PWUP		0x50		/* Power Up */
#define ADC1213X_PWDN		0xd0		/* Power Down */
#define ADC1213X_STATUS		0x30		/* Read Status Register */
#define ADC1213X_DATA_U		0xb0		/* Data Out without Sign */
#define ADC1213X_DATA_S		0xb1		/* Data Out with Sign */
#define ADC1213X_ACQ6		0x70		/* Acquisition Time - 6 CCLK */
#define ADC1213X_ACQ10		0x72		/* Acquisition Time - 10 CCLK */
#define ADC1213X_ACQ18		0x71		/* Acquisition Time - 18 CCLK */
#define ADC1213X_ACQ34		0x73		/* Acquisition Time - 34 CCLK */

#define ADC1213X_CHAN0		0
#define ADC1213X_CHAN1		1
#define ADC1213X_CHAN2		4
#define ADC1213X_CHAN3		5
#define ADC1213X_CHAN4		2
#define ADC1213X_CHAN5		3
#define ADC1213X_CHAN6		6
#define ADC1213X_CHAN7		7


int adc_sample(unsigned long channels,unsigned long *result);
void adc_up(void);
void adc_down(void);
void adc_init(int cycles);

#endif
