#ifndef _LINUX_PCMCIA_H_
#define _LINUX_PCMCIA_H_

/*
 * PCMCIA device finder functions
 *
 * Written 1999 by Werner Almesberger
 */

#include <linux/types.h>


/*
 * Find a disk device. "millivolts" is the available Vcc. Returns the base
 * address of the configuration registers in *fcr, the index of the selected
 * configuration in *cfg, and the base addresses of the two IO ranges in
 * *io_base0 and *io_base1. (Unused IO ranges are returned as 0.) The return
 * value is positive if a suitable device has been found, zero if not, and
 * negative if the CIS was absent or unparseable.
 */

int parse_cis(int millivolts,unsigned long *fcr,u8 *cfg,
    unsigned long *io_base0,unsigned long *io_base1);

/*
 * Dump the CIS content using printk.
 */

void dump_cis(void);

/*
 * Read a byte from the CIS at the specified offset. This function needs to be
 * provided by the architecture-specific interface.
 */

u8 cis_read(unsigned long offset);

/*
 * Enable the PCMCIA bus, call parse_cis, and activate any devices
 */

void pcmcia_init(void);

#endif
