/*
 * linux/include/asm-arm/arch-rpc/time.h
 *
 * Copyright (c) 1996 Russell King.
 *
 * Changelog:
 *  24-Sep-1996	RMK	Created
 *  10-Oct-1996	RMK	Brought up to date with arch-sa110eval
 *  04-Dec-1997	RMK	Updated for new arch/arm/time.c
 */
#include <asm/iomd.h>

extern __inline__ unsigned long gettimeoffset (void)
{
	unsigned long offset = 0;
	unsigned int count1, count2, status1, status2;

	status1 = IOMD_IRQREQA;
	barrier ();
	outb(0, IOMD_T0LATCH);
	barrier ();
	count1 = inb(IOMD_T0CNTL) | (inb(IOMD_T0CNTH) << 8);
	barrier ();
	status2 = inb(IOMD_IRQREQA);
	barrier ();
	outb(0, IOMD_T0LATCH);
	barrier ();
	count2 = inb(IOMD_T0CNTL) | (inb(IOMD_T0CNTH) << 8);

	if (count2 < count1) {
		/*
		 * This means that we haven't just had an interrupt
		 * while reading into status2.
		 */
		if (status2 & (1 << 5))
			offset = tick;
		count1 = count2;
	} else if (count2 > count1) {
		/*
		 * We have just had another interrupt while reading
		 * status2.
		 */
		offset += tick;
		count1 = count2;
	}

	count1 = LATCH - count1;
	/*
	 * count1 = number of clock ticks since last interrupt
	 */
	offset += count1 * tick / LATCH;
	return offset;
}

static void timer_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
	do_timer(regs);
}

static struct irqaction timerirq = {
	timer_interrupt,
	0,
	0,
	"timer",
	NULL,
	NULL
};

/*
 * Set up timer interrupt, and return the current time in seconds.
 */
extern __inline__ void setup_timer(void)
{
	extern int iic_control (unsigned char, int, char *, int);
	unsigned int year, mon, day, hour, min, sec;
	char buf[8];

	outb(LATCH & 255, IOMD_T0LTCHL);
	outb(LATCH >> 8, IOMD_T0LTCHH);
	outb(0, IOMD_T0GO);

	iic_control (0xa0, 0xc0, buf, 1);
	year = buf[0];
	if ((year += 1900) < 1970)
		year += 100;

	iic_control (0xa0, 2, buf, 5);
	mon  = buf[4] & 0x1f;
	day  = buf[3] & 0x3f;
	hour = buf[2];
	min  = buf[1];
	sec  = buf[0];
	BCD_TO_BIN(mon);
	BCD_TO_BIN(day);
	BCD_TO_BIN(hour);
	BCD_TO_BIN(min);
	BCD_TO_BIN(sec);

	xtime.tv_sec = mktime(year, mon, day, hour, min, sec);

	setup_arm_irq(IRQ_TIMER, &timerirq);
}
