/*
 * linux/include/asm-arm/arch-clps7110/time.h
 *
 * Written 1998,1999 by Werner Almesberger
 *
 */

#ifndef _ASM_ARCH_TIME_H
#define _ASM_ARCH_TIME_H

#include <asm/arch-clps7110/hardware.h>


extern __inline__ unsigned long gettimeoffset(void)
{
	return (LATCH-IO_TC2D)*tick/LATCH;
	/* @@@ is it really that easy ? */
}


static void timer_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
	do_timer(regs);
	IO_TC2EOI = 0;	    /* reset timer interrupt */ 
}


/*
 * Writing back the time to RTC isn't supported yet.
 */


#define update_rtc()


/*
 * Set up timer interrupt, and return the current time in seconds.
 */

static struct irqaction timerirq = {
	timer_interrupt,
	0,
	0,
	"timer",
	NULL,
	NULL
};


extern __inline__ void setup_timer(void)
{
	/* Timer 2: 2 kHz, Pre-scale mode */
	IO_SYSCON |= TC2M;
	IO_SYSCON &= ~TC2S;
        IO_TC2D = LATCH;
	setup_arm_irq(IRQ_TC2OI, &timerirq);
}

#endif
