/*
 * linux/include/asm-arm/arch-clps7110/system.h
 *
 */

#ifndef __ASM_ARCH_SYSTEM_H
#define __ASM_ARCH_SYSTEM_H

extern __inline__ void arch_reset(char mode)
{
	cli();
	__asm__("mov r1,#070\n"		/* turn off MMU */
		"mcr p15,0,r1,c1,c0\n"
		"mov pc,#0");		/* bang */
	/*
	 * If we're still alive, just loop.
	 */
	while (1);
}

#if 0
#define ARCH_IDLE_OK

#define arch_start_idle()       /* power-saving ? @@@ */
#define arch_end_idle()         /* power-saving ? @@@ */
#endif

#undef proc_idle /* ours is better than proc/system.h's */
#define proc_idle() IO_HALT = 1

#endif
