/*
 * linux/include/asm-arm/arch-clps7110/power.h
 *
 * Written 1999 by Werner Almesberger
 *
 * Power management
 */

#ifndef __ASM_ARCH_PM_H
#define __ASM_ARCH_PM_H

#include <linux/sched.h>
#include <linux/proc_fs.h>

#define PM_DEV_MINOR	153	/* steal /dev/apm ... oops, it's mergemem :-( */

#define PM_EVENT_SWITCH_ON		0x01
#define PM_EVENT_SWITCH_OFF		0x02
#define PM_EVENT_DEV_ON			0x04
#define PM_EVENT_DEV_OFF		0x08

/*
 * @@@ known bug: switch on/off can easily get de-synscronized between user
 * power management and the kernel. What needs to be done is this: whenever
 * user power management changes state, it writes on/off to /dev/apm. /dev/apm
 * promptly echoes back the change, suppressing redundant requests (which can
 * result from the user pressing "Off" just when PM decides to shut down).
 * Also, in order to know the state when the user hits on/off repeatedly before
 * PM reads /dev/apm, on and off need to clear the event bit of the respective
 * antagonist.
 */

#define PM_CPU_IDLE_DEFAULT		0 /*(  1*HZ)*/
#define PM_ADC_IDLE_DEFAULT		/* ( 10*HZ) */ 0 /* power-on broken */
#define PM_AUDIO_IDLE_DEFAULT		( 30*HZ)
#define PM_BACKLIGHT_IDLE_DEFAULT	( 60*HZ)
#define PM_KEYBOARD_IDLE_DEFAULT	(300*HZ)
#define PM_SCREEN_IDLE_DEFAULT		0 /* use screen blanker instead */
#define PM_SERIAL_IDLE_DEFAULT		(300*HZ)
#define PM_DISK_IDLE_DEFAULT		0 /* use internal power management */


struct pm_device {
	const char *name;
	void (*power)(struct pm_device *dev,int on);
	int idle;		/* for use by /proc/pm/...; 0: never;
				   else: idle timer in jiffies */
	/* ----- fields below are initialized by pm_register ----- */
	unsigned long last_use;	/* in jiffies */
	int changing;		/* 0: off or on; 1: in transition */
	int goal;		/* 0: off; 1: on */
	int next_state;		/* state after change */
	int enabled;		/* 0: don't power on on "On" */
	struct proc_dir_entry proc_entry;
	struct pm_device *next;
};


extern void cpu_standby(void);

/*
 * The following may be used across components.
 */

extern struct pm_device backlight_pm_dev;


static __inline__ void pm_activity(struct pm_device *dev)
{
	dev->last_use = jiffies;
}


void pm_complete(struct pm_device *dev);
void pm_activate(struct pm_device *dev);
void pm_activate_wait(struct pm_device *dev);
void pm_deactivate(struct pm_device *dev);
void pm_toggle(struct pm_device *dev); /* activate/deactivate */
void pm_enable(struct pm_device *dev);
void pm_disable(struct pm_device *dev);
void pm_register(struct pm_device *dev,int on);
void pm_deregister(struct pm_device *dev);
void pm_switch_on(void);
void pm_switch_off(void);

#endif
