/*
 * linux/include/asm-arm/arch-clps7110/mmu.h
 *
 * Written 1998,1999 by Werner Almesberger
 *
 * General memory mapping definitions plus special functions to help managing
 * physically fragmented memory.
 */

#ifndef __ASM_ARCH_MMU_H
#define __ASM_ARCH_MMU_H


#define FRAG_LIST_START		0xc0023600	/* @@@ fix this later */
#define frag_list		((struct frag_list_entry *) FRAG_LIST_START)


#ifndef __ASSEMBLY__

struct frag_list_entry {
	unsigned long start;	/* physical start address */
	unsigned long size;	/* size (in bytes) */
};

#endif


#ifdef CONFIG_ARCH_PSION
#define KMEM_IS_VIRTUAL
#include <asm/arch/mmu_psion.h>
#else
#undef KMEM_IS_VIRTUAL
#endif


#ifndef __ASSEMBLY__

#define __virt_to_bus__is_a_macro
#define __virt_to_bus(x) __virt_to_phys(x)
#define __bus_to_virt__is_a_macro
#define __bus_to_virt(x) __phys_to_virt(x)

#ifndef KMEM_IS_VIRTUAL

#define __virt_to_phys__is_a_macro
#define __virt_to_phys(vpage) vpage
#define __phys_to_virt__is_a_macro
#define __phys_to_virt(ppage) ppage

#else /* KMEM_IS_VIRTUAL */

extern unsigned long __virt_to_phys(unsigned long vpage);
extern unsigned long __phys_to_virt(unsigned long ppage);

#endif /* KMEM_IS_VIRTUAL */

#endif /* __ASSEMBLY__ */

#endif
