/*
 * include/asm-arm/arch-clps7110/irq.h
 *
 * Written 1998,1999 by Werner Almesberger
 */

#ifndef _ASM_ARCH_IRQ_H
#define	_ASM_ARCH_IRQ_H

#include <linux/config.h>
#include <asm/io.h>
#include <asm/arch/hardware.h>


#define fixup_irq(x) (x)


static void clps7110_mask_irq(unsigned int irq)
{
#ifdef DEBUG_IRQ
	printk ("masking IRQ:%d\n",irq);
#endif
	IO_INTMR &= ~(1 << irq);
}


static void clps7110_unmask_irq(unsigned int irq)
{
#ifdef DEBUG_IRQ
	printk("unmasking IRQ:%d\n" ,irq);
#endif
	IO_INTMR |= 1 << irq;
}


#ifdef CONFIG_ARCH_PSION

/*
 * Psion has a special chip in the CF/IDE path. Only the chip's first CF port
 * seems to be used, so we can take a few shortcuts.
 */

static void etna_cf_mask_ack(unsigned int irq)
{
	clps7110_mask_irq(irq);
	IO_ETNA_INT_MASK = 0;
	IO_ETNA_INT_CLEAR = ETNA_CF_IRQ;
}


static void etna_cf_unmask(unsigned int irq)
{
	IO_ETNA_INT_MASK = ETNA_CF_IRQ;
	clps7110_unmask_irq(irq);
}

#endif


static __inline__ void irq_init_irq(void)
{
	int i;

#ifdef DEBUG_IRQ
        printk("Disabling all ints..\n");
#endif
	IO_INTMR = 0; /* disable all interrupts */
	for (i = 0; i < NR_IRQS; i++) {
		irq_desc[i].valid	= 1;
		irq_desc[i].probe_ok	= 1;
		irq_desc[i].mask_ack	= clps7110_mask_irq;
		irq_desc[i].mask	= clps7110_mask_irq;
		irq_desc[i].unmask	= clps7110_unmask_irq;
	}
#ifdef CONFIG_ARCH_PSION
	irq_desc[IRQ_EINT1].mask_ack = etna_cf_mask_ack;
	irq_desc[IRQ_EINT1].unmask = etna_cf_unmask;
	etna_cf_mask_ack(IRQ_EINT1);
#endif
}

#endif
