/*
 * linux/include/asm-arm/arch-clps7110/hw_psion.h
 *
 * Written 1998,1999 by Werner Almesberger
 *
 * This file contains the hardware definitions of the Psion S5
 */

#ifndef __ASM_ARCH_HW_PSION_H
#define __ASM_ARCH_HW_PSION_H

/*
 * Physical address of PCMCIA area. Actually it's CF, but they're accessed in
 * the same way.
 */

#define PCMCIA_START		0x40000000

/*
 * LCD display size
 */

#define LCD_X_SIZE		640
#define LCD_Y_SIZE		240

/*
 * Register/port usage
 */

/*
 * Port B
 *
 * +--7--+--6--+--5--+--4--+--3--+--2--+--1--+--0--+
 * |VPCEN|OPEN |VLDD3|VLDD2|VLDD1|VLDD0|EECLK|EECS |
 * | out |in/ou|in/ou|in/ou|in/ou|in/ou| out | out |
 * +-----+-----+-----+-----+-----+-----+-----+-----+
 */

#define HW_VLD_PORT		IO_PBDR	/* Contrast control */
#define HW_VLD_DIR		IO_PBDDR
#define HW_VLD_MASK		0x3c
#define HW_VLD_SHIFT		2
#define HW_OPEN_PORT		IO_PBDR	/* Indicates that the case is open */
#define HW_OPEN_DIR		IO_PBDDR
#define HW_OPEN_BIT		0x40
#define HW_VPCEN_PORT		IO_PBDR /* Enables the power to the CF Card */
#define HW_VPCEN_BIT		0x80

/*
 * Port C
 *
 * +--7--+--6--+--5--+--4--+--3--+--2--+--1--+--0--+
 * |ADICT|BBLD |IREN |ELEN |RSEN |PLED | DTR | RTS |
 * | out | out | out | out | out | out | out | out |
 * +-----+-----+-----+-----+-----+-----+-----+-----+
 */

#define HW_RTS_PORT		IO_PCDR	/* RS-232 RTS */
#define HW_RTS_BIT		0x01
#define HW_DTR_PORT		IO_PCDR	/* RS-232 DTR */
#define HW_DTR_BIT		0x02
#define HW_PLED_PORT		IO_PCDR	/* Disable power LED */
#define HW_PLED_BIT		0x04
#define HW_RSEN_PORT		IO_PCDR	/* Enable RS-232 driver */
#define HW_RSEN_BIT		0x08
#define HW_ELEN_PORT		IO_PCDR	/* Enable backlight */
#define	HW_ELEN_BIT		0x10
#define HW_IREN_PORT		IO_PCDR	/* Enable IR receiver */
#define HW_IREN_BIT		0x20
#define HW_BBLD_PORT		IO_PCDR	/* Apply load to backup battery */
#define	HW_BBLD_BIT		0x40
#define HW_ADICT_PORT		IO_PCDR	/* Set audio circuit to "dictaphone" */
#define	HW_ADICT_BIT		0x80

/*
 * Port D
 *
 * +--7--+--6--+--5--+--4--+--3--+--2--+--1--+--0--+
 * | X2  | VLL |TRIX2|SLED |DORSW| DON |AMPEN|CDEN |
 * |in/ou| out | n/a | out | out | out | out | out |
 * +-----+-----+-----+-----+-----+-----+-----+-----+
 */

#define HW_CDEN_PORT		IO_PDDR	/* CODEC enable */
#define HW_CDEN_BIT		0x01
#define HW_AMPEN_PORT		IO_PDDR /* Audio Amplifier Enable */
#define HW_AMPEN_BIT		0x02
#define HW_DON_PORT		IO_PDDR /* Display On */
#define HW_DON_BIT		0x04
#define HW_SLED_PORT		IO_PDDR /* Turns Status LED ON */
#define HW_SLED_BIT		0x10
#define HW_VLL_PORT		IO_PDDR /* LCD Logic Rail */
#define HW_VLL_BIT		0x40
#define HW_X2_PORT		IO_PDDR	/* Pen Down Detect Line */
#define HW_X2_DIR		IO_PDDDR
#define HW_X2_BIT		0x80

/*
 * Port E
 *
 * +--3--+--2--+--1--+--0--+
 * |Y1EN |X1EN |Y2EN |X2EN |
 * | out | out | out | out |
 * +-----+-----+-----+-----+
 */

#define HW_X2EN_PORT		IO_PEDR	/* Digitiser X2 Drive */
#define HW_X2EN_BIT		0x01
#define HW_Y2EN_PORT		IO_PEDR	/* Digitiser Y2 Drive */
#define HW_Y2EN_BIT		0x02
#define HW_X1EN_PORT		IO_PEDR	/* Digitiser X1 Drive */
#define HW_X1EN_BIT		0x04
#define HW_Y1EN_PORT		IO_PEDR	/* Digitiser Y1 Drive */
#define HW_Y1EN_BIT		0x08

/*
 * ADC channels
 */

#define ADC_DIG_X	ADC1213X_CHAN0	/* Digitiser Y */
#define	ADC_DIG_Y	ADC1213X_CHAN1	/* Digitiser X */
#define ADC_VBATT	ADC1213X_CHAN2	/* Primary Battery Voltage */
#define ADC_VBACKUP	ADC1213X_CHAN3	/* Back-up Battery Voltage */
#define	ADC_VREF	ADC1213X_CHAN4	/* Reference Voltage */
#define	ADC_VPC		ADC1213X_CHAN5	/* Vpc/2 - CF power rail Voltage */
#define	ADC_VDC		ADC1213X_CHAN6	/* DC in (/2.5) */
#define	ADC_VPP		ADC1213X_CHAN7	/* VPP (/4) */

/*
 * ADC timing
 */

#define ADC1213X_T_CK	/*4*/5	/* SMPCLK, 256 kHz */
#define ADC1213X_T_SK	/*8*/9	/* ADCCLK, 128 kHz */

#define SSI_SPD      ADCS_256

/*
 * "ETNA" peripheral controller
 */

#define ETNA_START		0x20000000	/* physical */
#define ETNA_BASE		0xe0000000	/* virtual */
#define ETNA_SIZE		0x00100000	/* use section map */

#define ETNA_INT_STATUS	6	/* Interrupt Status */
#define ETNA_INT_MASK	7	/* Interrupt Mask */
#define ETNA_INT_CLEAR	8	/* Interrupt Clear */
#define	ETNA_CF_IRQ	0x01	/* Card Interrupt */
#define ETNA_CONTROL	11	/* CF control */

#define __ETNAB(x)	(*(volatile unsigned char *) (ETNA_BASE+(x)))

#define IO_ETNA_INT_STATUS	__ETNAB(ETNA_INT_STATUS)
#define IO_ETNA_INT_MASK	__ETNAB(ETNA_INT_MASK)
#define IO_ETNA_INT_CLEAR	__ETNAB(ETNA_INT_CLEAR)
#define IO_ETNA_CONTROL		__ETNAB(ETNA_CONTROL)

#endif
