VERSION 5.00
Begin VB.Form Data_load_form 
   Caption         =   "Euredit Summary Statistics"
   ClientHeight    =   8535
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   7830
   LinkTopic       =   "Form1"
   ScaleHeight     =   8535
   ScaleWidth      =   7830
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton show_plots 
      Caption         =   "Show Plots"
      Height          =   615
      Left            =   1080
      TabIndex        =   14
      Top             =   7680
      Width           =   1575
   End
   Begin VB.ListBox out_list 
      Height          =   2595
      ItemData        =   "Summary_statistcs.frx":0000
      Left            =   3720
      List            =   "Summary_statistcs.frx":0002
      TabIndex        =   13
      Top             =   4800
      Width           =   3135
   End
   Begin VB.ListBox var_list 
      Height          =   2595
      ItemData        =   "Summary_statistcs.frx":0004
      Left            =   360
      List            =   "Summary_statistcs.frx":0006
      TabIndex        =   12
      Top             =   4800
      Width           =   2775
   End
   Begin VB.CheckBox Check_i 
      Caption         =   "Exclude imputed"
      Height          =   375
      Left            =   5040
      TabIndex        =   11
      Top             =   2760
      Visible         =   0   'False
      Width           =   2055
   End
   Begin VB.CheckBox Check_s 
      Caption         =   "Exclude suspect"
      Height          =   255
      Left            =   2760
      TabIndex        =   10
      Top             =   2760
      Visible         =   0   'False
      Width           =   1695
   End
   Begin VB.CheckBox Check_e 
      Caption         =   "Exclude errors"
      Height          =   255
      Left            =   480
      TabIndex        =   9
      Top             =   2760
      Value           =   1  'Checked
      Visible         =   0   'False
      Width           =   1455
   End
   Begin VB.CommandButton go_end 
      Caption         =   "Exit"
      Height          =   615
      Left            =   5040
      TabIndex        =   8
      Top             =   7680
      Width           =   1215
   End
   Begin VB.TextBox show_file_name 
      Height          =   495
      Left            =   240
      TabIndex        =   6
      Top             =   3480
      Width           =   5655
   End
   Begin VB.DriveListBox drive_set 
      Height          =   315
      Left            =   360
      TabIndex        =   3
      Top             =   2160
      Width           =   1095
   End
   Begin VB.CommandButton go_load 
      Caption         =   "Compute"
      Height          =   855
      Left            =   6360
      TabIndex        =   2
      Top             =   3360
      Width           =   1215
   End
   Begin VB.FileListBox File_set 
      Height          =   1845
      Left            =   2520
      TabIndex        =   1
      Top             =   480
      Width           =   1935
   End
   Begin VB.DirListBox Dir_set 
      Height          =   1440
      Left            =   360
      TabIndex        =   0
      Top             =   480
      Width           =   1815
   End
   Begin VB.Frame Frame1 
      Caption         =   "Working Directory"
      Height          =   2295
      Left            =   240
      TabIndex        =   4
      Top             =   240
      Width           =   2055
   End
   Begin VB.Frame file_frame 
      Caption         =   "Data (XML) file"
      Height          =   2295
      Left            =   2400
      TabIndex        =   5
      Top             =   240
      Width           =   2175
   End
   Begin VB.Frame Frame2 
      Caption         =   "XML File"
      Height          =   975
      Left            =   120
      TabIndex        =   7
      Top             =   3240
      Width           =   5895
   End
   Begin VB.Image Image1 
      Height          =   2265
      Left            =   5160
      Picture         =   "Summary_statistcs.frx":0008
      Top             =   240
      Width           =   2400
   End
End
Attribute VB_Name = "Data_load_form"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Copyright NAG 2002

Private Sub Dir_set_Change()
Dim scratch As String
Dim l As Long
File_set.Path = Dir_set.Path
File_set.Pattern = "*.xml"
scratch = Dir_set.Path
l = Len(scratch)
If Right(scratch, 1) = "\" Then
    l = l - 1
End If
work_dir = Left(scratch, l)
End Sub

Private Sub drive_set_Change()
Dir_set.Path = drive_set.Drive
drive_set_up = drive_set.Drive
Call Dir_set_Change
End Sub



Private Sub File_set_Click()
Dim i As Long, j As Long
Dim linetext As String, scratch As String
data_file = File_set.FileName
work_dir = File_set.Path
If work_dir <> "" Then
    data_file = work_dir & "\" & data_file
End If
i = InStr(1, data_file, ".", 1)
xml_file = Left(data_file, i - 1) & ".xml"
svg_file = Left(data_file, i - 1) & ".svg"
scratch = xml_file
On Error GoTo file_error
Open scratch For Input As #2
Line Input #2, linetxt
Line Input #2, linetxt
j = InStr(1, linetxt, "href=", 1)
k = InStr(1, linetxt, "?>", 1)
If j = 0 Or k = 0 Or k < j + 7 Then
    MsgBox ("Error in xml file")
    Close #2
    Exit Sub
End If
xsl_file = Mid(linetxt, j + 6, k - j - 7)
Line Input #2, linetxt
j = InStr(1, linetxt, "x-schema:", 1)
k = InStr(1, linetxt, ">", 1)
If j = 0 Or k = 0 Or k < j + 10 Then
    MsgBox ("Error in xml file")
    Close #2
    Exit Sub
End If
xdr_file = Mid(linetxt, j + 9, k - j - 10)
show_file_name.Text = xml_file
Close #2

Exit Sub
file_error:
    MsgBox (Err.Description)
    Close #2
End Sub

Private Sub Form_Load()

maxcat = 100
miss_val = -309931245.1
mset = 3
plots_done = 0

End Sub

Private Sub go_load_Click()
Dim i As Long, k As Long
Dim temp As Double
Dim mid_pts() As Double
Dim info(1) As Long
Dim lname As nagstrg
Dim scratch As String

Call xml_data_size(xdr_file, n, m, maxname, info(0))

If info(0) <> 0 Then
    MsgBox ("Error in XDR file: " & Str$(info(0)) & " , " & Str$(info(1)))
End If
ReDim data(n * m)
ReDim n_cat(m)
ReDim cat_val(m * maxcat)
ReDim var_name(m)
ReDim mean(m)
ReDim sd(m)
ReDim vmin(m)
ReDim vmax(m)
ReDim n_valid(m)
ReDim counts(m * maxcat)
ReDim mid_pts(m * maxcat)

var_list.Clear
var_num = 0

For i = 0 To m - 1
    Call alloc_names(name_ptr, m, i, maxname)
Next i

Call xml_read(xml_file, xdr_file, miss_val, n, m, data(0), name_ptr, _
n_cat(0), cat_val(0), maxcat, -mset, nmiss, info(0))

For i = 0 To m - 1
    Call get_names(name_ptr, i, lname)
    scratch = Left(lname.name, maxname + 7)
    k = InStr(1, scratch, "</name>", 1) - 1
    var_name(i) = Left(scratch, k)
Next i

If info(0) <> 0 Then
    MsgBox ("Error in XML file")
End If
 
cat_val(m * max_cat) = -309931245

Call summ_stats(n, m, miss_val, data(0), n_cat(0), cat_val(0), maxcat, mean(0), _
sd(0), vmin(0), vmax(0), n_valid(0), mid_pts(0), counts(0), info(0))

If info(0) = 10 Then
    temp = info(1)
    temp = temp / 10000#
    MsgBox ("Error in category, variable " & Str$(temp))
    Exit Sub
End If
 
For i = 0 To m - 1
    var_list.AddItem (var_name(i))
Next i

Call bar_chart(svg_file, m, name_ptr, n_cat(0), cat_val(0), counts(0), maxcat, _
mid_pts(0), plot_height, info(0))

If info(0) <> 0 Then
    MsgBox ("Error in forming SVG plots")
    Exit Sub
End If
Call free_list(name_ptr, m)

plots_done = 1
End Sub

Private Sub go_end_Click()
Dim i As Long, j As Long, k As Long
Dim scratch As String
If run_from_menu = 1 Then
    scratch = xml_file
    k = Len(scratch)
    i = 0
    For j = 1 To k
        If Mid(scratch, j, 1) = "\" Then
            i = j
        End If
    Next j
    If i > 0 Then
        xml_file = Right(scratch, k - i)
    End If
    Data_load_form.Visible = False
Else
    End
End If
End Sub



Private Sub show_file_name_Change()
xml_file = show_file_name.Text
End Sub

Private Sub Check_s_Click()
    If Check_s.Value = Checked Then
        mset = 2
        Check_e.Value = Checked
    End If
    If Check_s.Value = Unchecked And mset = 2 Then
        mset = 3
    End If
End Sub

Private Sub Check_e_Click()
    If Check_e.Value = Checked And mset > 3 Then
        mset = 3
    End If
    If Check_e.Value = Unchecked Then
        Check_s.Value = Unchecked
        mset = 4
    End If
End Sub
Private Sub Check_i_Click()
    If Check_i.Value = Checked Then
        mset = 1
        Check_s.Value = Checked
        Check_e.Value = Checked
    End If
    If Check_s.Value = Unchecked And mset = 1 Then
        mset = 2
    End If

End Sub

Private Sub show_plots_Click()
Dim launch_browser As String
Dim html_file As String
Dim k As Long
Dim RetVal

If plots_done <> 1 Then
    MsgBox ("Calculations not complete")
    Exit Sub
End If

html_file = work_dir & "\esys_temp.htm"
k = plot_height / 10 + 1
If k > 16000 Then
    k = 16000
End If
Open html_file For Output Shared As #4
Print #4, "<html>"
Print #4, "<p><center>"
Print #4, "<embed src=""" & svg_file & """ width=""500"" height=""" & Str$(k) & """ type=""image/svg-xml \>"""
Print #4, "</p></center>"
Print #4, "</html>"
Close #4

launch_browser = """c:\Program Files\Internet Explorer\IEXPLORE.EXE""" & " " & html_file
RetVal = Shell(launch_browser, vbNormalFocus)

End Sub

Private Sub var_list_Click()
Dim i As Long, l As Long, k As Long
var_num = var_list.ListIndex
out_list.Clear
If n_cat(var_num) <= 0 Then
    out_list.AddItem (" Name : " & var_name(var_num))
    out_list.AddItem (" Mean : " & Str$(mean(var_num)))
    out_list.AddItem (" S.D. : " & Str$(sd(var_num)))
    out_list.AddItem (" Min  : " & Str$(vmin(var_num)))
    out_list.AddItem (" Max  : " & Str$(vmax(var_num)))
    out_list.AddItem (" Valid: " & Str$(n_valid(var_num)))
Else
    out_list.AddItem (" Name : " & var_name(var_num))
    out_list.AddItem (" Category    |  Count")
    l = n_cat(var_num) - 1
    For l = 0 To l
        k = cat_val(var_num * maxcat + l)
        If k > 9 Then
            out_list.AddItem (" " & Str$(k) & "             |  " & Str$(counts(var_num * maxcat + l)))
        ElseIf k >= 0 Then
            out_list.AddItem ("  " & Str$(k) & "             |  " & Str$(counts(var_num * maxcat + l)))
        ElseIf k < -9 Then
            out_list.AddItem (Str$(k) & "             |  " & Str$(counts(var_num * maxcat + l)))
        Else
            out_list.AddItem (" " & Str$(k) & "             |  " & Str$(counts(var_num * maxcat + l)))
        End If
    Next l
End If

End Sub
